/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.exporters.pdf;

import com.tridium.data.BDataTable;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.report.exporters.BGridToText;
import javax.baja.collection.ColumnList;
import javax.baja.gx.BFont;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.report.grid.BIGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

public class BGridToPdf
extends BPdfExporter {
    public static final Type TYPE = Sys.loadType(BGridToPdf.class);

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        BIGrid grid = (BIGrid)op.get();
        BComponent gridComp = (BComponent)grid;
        GridModel model = grid.resolve((BObject)gridComp, (Context)op);
        BLabel name = new BLabel(gridComp.getName());
        BLabel path = new BLabel(gridComp.getSlotPath().toString());
        BLabel time = new BLabel(BAbsTime.now().toString());
        name.setFont(BFont.make((String)Lexicon.make((String)"pdf").getText("pdf.propertySheetToPdf.font")));
        name.setHalign(BHalign.left);
        path.setHalign(BHalign.left);
        time.setHalign(BHalign.left);
        BDataTable data = BGridToText.makeTable((GridModel)model, (Context)op);
        BTable table = new BTable((TableModel)new Model(data, (Context)op));
        BPdfFlowPane flow = new BPdfFlowPane();
        flow.add(null, (BValue)name);
        flow.add(null, (BValue)path);
        flow.add(null, (BValue)time);
        flow.add(null, (BValue)new BLabel(""));
        flow.add(null, (BValue)table);
        flow.setupPane();
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)flow, doc, op);
    }

    static class Model
    extends TableModel {
        BDataTable data;
        ColumnList cols;
        Context cx;

        Model(BDataTable data, Context cx) {
            this.data = data;
            this.cols = data.getColumns();
            this.cx = cx;
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int col) {
            return this.cols.get(col).getDisplayName(this.cx);
        }

        public Object getValueAt(int row, int col) {
            return this.data.get(row).cell(this.cols.get(col));
        }
    }
}

