/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point.actions;

import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.point.BKnxNumericProxyExt;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.point.actions.BKnxAction;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
abstract class BKnxStepAction
extends BKnxAction {
    public static final Type TYPE = Sys.loadType(BKnxStepAction.class);
    private static final int UP_DOWN_MASK = 8;
    private static final int DIRECTION_UP = 8;
    private static final int DIRECTION_DOWN = 0;
    private static final int PREVIOUS_COMMAND_MINIMUM = 0;
    private static final int PREVIOUS_COMMAND_MAXIMUM = 15;
    private static final int DEFAULT_PREVIOUS_COMMAND = 0;
    private static final int STEP_SIZE_MASK = 7;
    private static final int STEP_SIZE_MINIMUM = 1;
    private static final int STEP_SIZE_MAXIMUM = 7;
    private static final int DEFAULT_STEP_SIZE = 1;
    private static final String STEP_SIZE = "stepSize";
    private static final String PREVIOUS_COMMAND = "prevCmd";

    BKnxStepAction() {
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public final Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    @Override
    public BKnxComObjectSizeEnum getComObjectSize() {
        return BKnxComObjectSizeEnum._4_Bit;
    }

    @Override
    public BKnxAction.SlotDefinition[] getSlotDefinitions() {
        return new BKnxAction.SlotDefinition[]{BKnxAction.SlotDefinition.make(STEP_SIZE, (BValue)BInteger.make((int)1), 0, BFacets.makeInt((int)1, (int)7))};
    }

    protected static void doStepBreak(BKnxProxyExt proxyExt, Context cx) {
        BKnxProxyExt.log.fine("BKnxNumericProxyExt:doStepBreakAction");
        BStatusNumeric deviceValue = new BStatusNumeric(0.0);
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)deviceValue, false);
        BKnxStepAction.setPreviousCommand(proxyExt, BKnxStepAction.getPreviousCommand(proxyExt) & 8);
    }

    protected static void doStepDown(BKnxProxyExt proxyExt, Context cx) {
        int v;
        BKnxProxyExt.log.info("BKnxNumericProxyExt:doStepDownAction");
        if (BKnxStepAction.previouslyDecreasing(proxyExt)) {
            v = 0;
        } else {
            v = BKnxStepAction.getStepSize(proxyExt);
            if (v > 7) {
                v = 7;
            }
            if (v < 1) {
                v = 1;
            }
        }
        BStatusNumeric deviceValue = new BStatusNumeric((double)v);
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)deviceValue, false);
        BKnxStepAction.setPreviousCommand(proxyExt, v);
    }

    protected static void doStepUp(BKnxProxyExt proxyExt, Context cx) {
        int v;
        BKnxProxyExt.log.fine("BKnxNumericProxyExt:doStepUpAction");
        if (BKnxStepAction.previouslyIncreasing(proxyExt)) {
            v = 0;
        } else {
            v = BKnxStepAction.getStepSize(proxyExt);
            if (v > 7) {
                v = 7;
            }
            if (v < 1) {
                v = 1;
            }
        }
        BStatusNumeric deviceValue = new BStatusNumeric((double)(v |= 8));
        ((BKnxNumericProxyExt)proxyExt).setWriteValueAndWrite((BStatusValue)deviceValue, false);
        BKnxStepAction.setPreviousCommand(proxyExt, v);
    }

    private static boolean previouslyDecreasing(BKnxProxyExt proxyExt) {
        int previousDimmingCommand = BKnxStepAction.getPreviousCommand(proxyExt);
        return (previousDimmingCommand & 8) == 0 && (previousDimmingCommand & 7) > 0;
    }

    private static boolean previouslyIncreasing(BKnxProxyExt proxyExt) {
        int previousDimmingCommand = BKnxStepAction.getPreviousCommand(proxyExt);
        return (previousDimmingCommand & 8) == 8 && (previousDimmingCommand & 7) > 0;
    }

    private static int getStepSize(BKnxProxyExt proxyExt) {
        BInteger stepSize = (BInteger)proxyExt.get(STEP_SIZE);
        if (stepSize == null) {
            return 1;
        }
        return stepSize.getInt();
    }

    private static int getPreviousCommand(BKnxProxyExt proxyExt) {
        BInteger previousCommand = (BInteger)proxyExt.get(PREVIOUS_COMMAND);
        if (previousCommand == null) {
            return 0;
        }
        return previousCommand.getInt();
    }

    private static void setPreviousCommand(BKnxProxyExt proxyExt, int newCommand) {
        BInteger previousCommand = (BInteger)proxyExt.get(PREVIOUS_COMMAND);
        if (previousCommand == null) {
            proxyExt.add(PREVIOUS_COMMAND, (BValue)BInteger.make((int)newCommand), 5, BFacets.makeInt((int)0, (int)15), null);
        }
        proxyExt.set(PREVIOUS_COMMAND, (BValue)BInteger.make((int)newCommand));
    }
}

