/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.knxDataDefs;

import com.tridiumX.knxnetIp.knxDataDefs.IDataIntegrity;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;

class DataIntegrityCalculator {
    private MessageDigest md;

    private DataIntegrityCalculator() {
    }

    protected static DataIntegrityCalculator make(String digestAlgorithm) throws NoSuchAlgorithmException {
        DataIntegrityCalculator calc = new DataIntegrityCalculator();
        calc.md = MessageDigest.getInstance(digestAlgorithm);
        return calc;
    }

    protected void update(String s) {
        this.md.update(s.getBytes());
    }

    protected void update(IDataIntegrity definition) {
        IDataIntegrity[] children;
        BComponent comp = (BComponent)definition;
        for (IDataIntegrity child : children = (IDataIntegrity[])comp.getChildren(IDataIntegrity.class)) {
            ((BComplex)child).loadSlots();
            child.calcDataIntegrity(this);
        }
    }

    public byte[] digest() {
        return this.md.digest();
    }
}

