/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.parts.DeviceManagementCrd;
import com.tridiumX.knxnetIp.comms.frames.parts.TunnellingCrd;
import com.tridiumX.knxnetIp.knxSpec.BServiceFamilyEnum;
import java.io.IOException;

public abstract class ConnectionResponseData {
    protected final int length;
    protected final BServiceFamilyEnum connectionType;

    protected ConnectionResponseData(int length, BServiceFamilyEnum connectionType) {
        this.length = length;
        this.connectionType = connectionType;
    }

    public static ConnectionResponseData makeFromStream(KnxInputStream in) throws IOException {
        int length = in.read();
        int serviceType = in.read();
        ConnectionResponseData crd = null;
        switch (serviceType) {
            case 3: {
                crd = new DeviceManagementCrd(length, DeviceManagementCrd.SERVICE_FAMILY);
                break;
            }
            case 4: {
                crd = new TunnellingCrd(length, TunnellingCrd.SERVICE_FAMILY);
                break;
            }
            default: {
                throw new IOException("unsupported CRI type " + serviceType);
            }
        }
        crd.fromStream(in);
        return crd;
    }

    protected abstract void fromStream(KnxInputStream var1) throws IOException;

    public void toStream(KnxOutputStream out) {
        out.write(this.length);
        out.write(this.connectionType.getOrdinal());
        this.toOutputStream(out);
    }

    protected abstract void toOutputStream(KnxOutputStream var1);

    public String getLogString() {
        String s = "length = " + this.length;
        s = s + ", connectionType = " + (this.connectionType == null ? "null" : this.connectionType.toString());
        return s;
    }

    public BServiceFamilyEnum getConnectionType() {
        return this.connectionType;
    }
}

