/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionRequestInformation;
import com.tridiumX.knxnetIp.comms.frames.parts.HostProtocolAddressInformation;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;

public final class CoreConnectRequest
extends KnxIpFrame {
    private HostProtocolAddressInformation controlHpai;
    private HostProtocolAddressInformation dataHpai;
    private ConnectionRequestInformation cri;

    public CoreConnectRequest() {
    }

    public CoreConnectRequest(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreConnectRequest(InetAddress address, int cep, int dep, ConnectionRequestInformation cri) {
        this.controlHpai = new HostProtocolAddressInformation(address, cep);
        this.dataHpai = new HostProtocolAddressInformation(address, dep);
        this.cri = cri;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreConnectRequest;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 24;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.controlHpai = new HostProtocolAddressInformation(in);
            this.dataHpai = new HostProtocolAddressInformation(in);
            this.cri = ConnectionRequestInformation.makeFromStream(in);
        }
        catch (Exception ex) {
            if (CoreConnectRequest.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        if (this.controlHpai.getAddress() == null) {
            throw new IOException("controlHpai address is null");
        }
        if (this.controlHpai.getPort() == -1) {
            throw new IOException("controlHpai port == Constants.NO_IP_PORT_NUMBER (-1)");
        }
        if (this.dataHpai.getAddress() == null) {
            throw new IOException("dataHpai address is null");
        }
        if (this.dataHpai.getPort() == -1) {
            throw new IOException("dataHpai port == Constants.NO_IP_PORT_NUMBER (-1)");
        }
        if (this.cri == null) {
            throw new IOException("ConnectionRequestInformation is null");
        }
        this.controlHpai.toStream(out);
        this.dataHpai.toStream(out);
        this.cri.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("Control HPAI = " + this.controlHpai.getLogString());
        sb.append(", Data HPAI = " + this.dataHpai.getLogString());
        sb.append(", Connection Request Information = " + this.cri.getLogString());
    }

    public HostProtocolAddressInformation getControlHpai() {
        return this.controlHpai;
    }

    public HostProtocolAddressInformation getDataHpai() {
        return this.dataHpai;
    }

    public ConnectionRequestInformation getCri() {
        return this.cri;
    }
}

