/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.comms.BConnection;
import com.tridiumX.knxnetIp.comms.BFrameReceiverCommsCounters;
import com.tridiumX.knxnetIp.comms.ReceivedFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.util.BKnxWorker;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.baja.util.QueueFullException;

public class ReceivedFrameWorkers {
    private BKnxWorker rxPacketAckWorker;
    private BKnxWorker rxPacketProcessWorker;
    private BKnxWorker[] workers;
    private final BConnection connection;
    private static final String RX_PACKET_ACK_WORKER_BASE_NAME = "DataRxPktAckWrkr";
    private static final String RX_PACKET_PROC_WORKER_BASE_NAME = "DataRxPktProcessWrkr";

    public ReceivedFrameWorkers(BConnection connection) {
        this.connection = connection;
    }

    public synchronized void start(String hostAddress) {
        this.rxPacketAckWorker = BKnxWorker.make(RX_PACKET_ACK_WORKER_BASE_NAME + hostAddress + '.' + (Object)((Object)this.connection.getTypeCode()), this.connection.getMaximumReceivedPacketsQueSize());
        this.rxPacketAckWorker.start();
        this.rxPacketProcessWorker = BKnxWorker.make(RX_PACKET_PROC_WORKER_BASE_NAME + hostAddress + '.' + (Object)((Object)this.connection.getTypeCode()), this.connection.getMaximumReceivedPacketsQueSize());
        this.rxPacketProcessWorker.start();
        this.workers = new BKnxWorker[]{this.rxPacketAckWorker, this.rxPacketProcessWorker};
    }

    public synchronized void stop() {
        for (BKnxWorker worker : this.workers) {
            if (worker == null) continue;
            worker.stop();
            worker = null;
        }
    }

    public synchronized void receiveFrame(KnxIpFrame frame, Consumer<KnxIpFrame> frameConsumer) {
        BKnxWorker worker;
        BKnxWorker bKnxWorker = worker = frame.isAcked() ? this.rxPacketProcessWorker : this.rxPacketAckWorker;
        if (worker != null) {
            try {
                worker.post(new ReceivedFrame(frame, frameConsumer, worker.getName()));
            }
            catch (QueueFullException ex) {
                this.connection.getCommsCounters().incCounter(BFrameReceiverCommsCounters.rxFramesLostQueueFull);
                this.logQueueError(frame, (Exception)((Object)ex), "Queue Full");
            }
            catch (Exception ex) {
                this.logQueueError(frame, ex, "Unknown");
            }
        } else {
            this.connection.getCommsCounters().incCounter(BFrameReceiverCommsCounters.rxFramesLostNoPacketWorker);
        }
    }

    private void logQueueError(KnxIpFrame frame, Exception ex, String reason) {
        BConnection.log.log(Level.SEVERE, String.format("%s Received Packet Lost - %s - packet [ %s ] from %s srcPort = %s", this.connection.getDataEndPoint().getEndPointName(), reason, frame.getHexString(), frame.packet.getAddress().getHostAddress(), frame.packet.getPort()), ex);
    }

    public String spy() {
        StringBuilder string = new StringBuilder();
        for (BKnxWorker worker : this.workers) {
            string.append(String.format("%s - max[%s] current[%s] dequeued[%s] avgQueueTime[%s]\n", worker.getWorkerName(), worker.getMaxQueueSize(), worker.getQueueCount(), worker.getDequeuedCount(), worker.getAvgQueueTime()));
        }
        return string.toString();
    }
}

