/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.comms.BConnection;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.util.Queuable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReceivedFrame
implements Runnable,
Queuable {
    private static final Logger log = BConnection.log;
    private final Consumer<KnxIpFrame> frameConsumer;
    private final KnxIpFrame frame;
    private final String queueName;
    private final long enqueueTime;

    public ReceivedFrame(KnxIpFrame frame, Consumer<KnxIpFrame> frameConsumer, String queueName) {
        this.frame = frame;
        this.frameConsumer = frameConsumer;
        this.queueName = queueName;
        this.enqueueTime = System.currentTimeMillis();
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public void run() {
        if (this.frame != null) {
            try {
                this.frameConsumer.accept(this.frame);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "An exception occurred while consuming a received frame.", ex);
            }
        } else {
            log.info("frame == NULL in ReceivedFrame, queueName = " + this.queueName);
        }
    }
}

