/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridiumX.knxnetIp.comms.BKnxInstallation;
import com.tridiumX.knxnetIp.comms.BLocalInterfaces;
import com.tridiumX.knxnetIp.comms.BTcpIpAdapter;
import com.tridiumX.knxnetIp.comms.KnxMulticastSocket;
import com.tridiumX.knxnetIp.comms.enums.BLocalInterfaceConfigStatus;
import com.tridiumX.knxnetIp.comms.enums.BObtainLocalSocketBehaviourEnum;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.util.BIIncludeInTrace;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.util.Dump;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.license.LicenseManager;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="faultCause", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=67), @NiagaraProperty(name="configStatus", type="BLocalInterfaceConfigStatus", defaultValue="BLocalInterfaceConfigStatus.ok", flags=75), @NiagaraProperty(name="localInterfaceId", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="adapterId", type="BTcpIpAdapter", defaultValue="new BTcpIpAdapter()", flags=64, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"knxnetIp:TcpIpAdapterFE\")")}), @NiagaraProperty(name="adapterDescription", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=67), @NiagaraProperty(name="adapterIpAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=67), @NiagaraProperty(name="localPortMin", type="int", defaultValue="Constants.MIN_LOCAL_PORT_DEFAULT", facets={@Facet(value="BFacets.makeInt(null, Constants.MIN_LOCAL_IP_PORT, Constants.MAX_IP_PORT_NUMBER, 10)")}), @NiagaraProperty(name="localPortMax", type="int", defaultValue="Constants.MAX_LCOAL_PORT_DEFAULT", facets={@Facet(value="BFacets.makeInt(null, Constants.MIN_LOCAL_IP_PORT, Constants.MAX_IP_PORT_NUMBER, 10)")}), @NiagaraProperty(name="lastUsedLocalPort", type="int", defaultValue="Constants.NO_IP_PORT_NUMBER", flags=1), @NiagaraProperty(name="obtainLocalSocketBehaviour", type="BObtainLocalSocketBehaviourEnum", defaultValue="BObtainLocalSocketBehaviourEnum.DEFAULT"), @NiagaraProperty(name="knxInstallation", type="BKnxInstallation", defaultValue="new BKnxInstallation()"), @NiagaraProperty(name="includeInTrace", type="boolean", defaultValue="true", flags=65540)})
public abstract class BAbstractLocalInterface
extends BComponent
implements BIIncludeInTrace {
    public static final Property status = BAbstractLocalInterface.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property enabled = BAbstractLocalInterface.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BAbstractLocalInterface.newProperty((int)67, (String)"", null);
    public static final Property configStatus = BAbstractLocalInterface.newProperty((int)75, (BValue)BLocalInterfaceConfigStatus.ok, null);
    public static final Property localInterfaceId = BAbstractLocalInterface.newProperty((int)65, (int)0, null);
    public static final Property adapterId = BAbstractLocalInterface.newProperty((int)64, (BValue)new BTcpIpAdapter(), (BFacets)BFacets.make((String)"fieldEditor", (String)"knxnetIp:TcpIpAdapterFE"));
    public static final Property adapterDescription = BAbstractLocalInterface.newProperty((int)67, (String)"", null);
    public static final Property adapterIpAddress = BAbstractLocalInterface.newProperty((int)67, (String)"", null);
    public static final Property localPortMin = BAbstractLocalInterface.newProperty((int)0, (int)3500, (BFacets)BFacets.makeInt(null, (int)1, (int)65535, (int)10));
    public static final Property localPortMax = BAbstractLocalInterface.newProperty((int)0, (int)4000, (BFacets)BFacets.makeInt(null, (int)1, (int)65535, (int)10));
    public static final Property lastUsedLocalPort = BAbstractLocalInterface.newProperty((int)1, (int)-1, null);
    public static final Property obtainLocalSocketBehaviour = BAbstractLocalInterface.newProperty((int)0, (BValue)BObtainLocalSocketBehaviourEnum.DEFAULT, null);
    public static final Property knxInstallation = BAbstractLocalInterface.newProperty((int)0, (BValue)new BKnxInstallation(), null);
    public static final Property includeInTrace = BAbstractLocalInterface.newProperty((int)65540, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BAbstractLocalInterface.class);
    private static final String LOCAL_INTERFACE_LIMIT_KEY = "interface.limit";
    private static final int DEFAULT_LOCAL_INTERFACE_LIMIT = 0;
    private static final int NO_LOCAL_INTERFACE_LIMIT = -1;
    private static final Object localInterfacesLock = new Object();
    private static final Vector<BAbstractLocalInterface> localInterfaces = new Vector(1, 1);
    protected final Object socketAllocationLock = new Object();
    protected final Vector<Integer> vAllocatedLocalSockets = new Vector(3, 2);
    protected BacnetEthernetAdapter igmpAdapter;
    private boolean configFault;
    private boolean fatalFault;
    private InetAddress adapterInetAddress;
    private static final Logger logInterface = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.interface");

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BLocalInterfaceConfigStatus getConfigStatus() {
        return (BLocalInterfaceConfigStatus)this.get(configStatus);
    }

    public void setConfigStatus(BLocalInterfaceConfigStatus v) {
        this.set(configStatus, (BValue)v, null);
    }

    public int getLocalInterfaceId() {
        return this.getInt(localInterfaceId);
    }

    public void setLocalInterfaceId(int v) {
        this.setInt(localInterfaceId, v, null);
    }

    public BTcpIpAdapter getAdapterId() {
        return (BTcpIpAdapter)this.get(adapterId);
    }

    public void setAdapterId(BTcpIpAdapter v) {
        this.set(adapterId, (BValue)v, null);
    }

    public String getAdapterDescription() {
        return this.getString(adapterDescription);
    }

    public void setAdapterDescription(String v) {
        this.setString(adapterDescription, v, null);
    }

    public String getAdapterIpAddress() {
        return this.getString(adapterIpAddress);
    }

    public void setAdapterIpAddress(String v) {
        this.setString(adapterIpAddress, v, null);
    }

    public int getLocalPortMin() {
        return this.getInt(localPortMin);
    }

    public void setLocalPortMin(int v) {
        this.setInt(localPortMin, v, null);
    }

    public int getLocalPortMax() {
        return this.getInt(localPortMax);
    }

    public void setLocalPortMax(int v) {
        this.setInt(localPortMax, v, null);
    }

    public int getLastUsedLocalPort() {
        return this.getInt(lastUsedLocalPort);
    }

    public void setLastUsedLocalPort(int v) {
        this.setInt(lastUsedLocalPort, v, null);
    }

    public BObtainLocalSocketBehaviourEnum getObtainLocalSocketBehaviour() {
        return (BObtainLocalSocketBehaviourEnum)this.get(obtainLocalSocketBehaviour);
    }

    public void setObtainLocalSocketBehaviour(BObtainLocalSocketBehaviourEnum v) {
        this.set(obtainLocalSocketBehaviour, (BValue)v, null);
    }

    public BKnxInstallation getKnxInstallation() {
        return (BKnxInstallation)this.get(knxInstallation);
    }

    public void setKnxInstallation(BKnxInstallation v) {
        this.set(knxInstallation, (BValue)v, null);
    }

    @Override
    public boolean getIncludeInTrace() {
        return this.getBoolean(includeInTrace);
    }

    @Override
    public void setIncludeInTrace(boolean v) {
        this.setBoolean(includeInTrace, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BLocalInterfaces;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (context != null && !context.equals(Context.decoding) && !context.equals(Context.copying) && property.getType().equals(BKnxInstallation.TYPE)) {
            this.knxInstallationAdded((BKnxInstallation)this.get(property));
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (property.getType().equals(BKnxInstallation.TYPE)) {
            this.checkConfigKnxInstallationsIps();
        }
    }

    public void reordered(Context context) {
        super.reordered(context);
        if (this.isRunning()) {
            this.checkConfigKnxInstallationsIps();
        }
    }

    public final void started() throws Exception {
        super.started();
        this.checkLicensed();
        this.updateConfigStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopped() throws Exception {
        super.stopped();
        Object object = localInterfacesLock;
        synchronized (object) {
            localInterfaces.remove(this);
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.checkConfigKnxInstallationsIps();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(configStatus)) {
            if (!this.getConfigStatus().isConfigFault()) {
                this.configOk();
            } else {
                this.configFail(this.getConfigStatus().toString(context));
            }
        }
        if (property.equals(enabled)) {
            if (!this.isRunning()) {
                return;
            }
            this.updateStatus();
        } else if (property.equals(adapterId)) {
            if (!this.isRunning() && !Context.decoding.equals(context)) {
                return;
            }
            this.setAdapterDescription(this.getAdapterId().getDescription());
            this.setAdapterIpAddress(this.getAdapterId().getIpAddress());
            if (!this.isRunning()) {
                return;
            }
            this.updateLocalAddress();
            try {
                ((BLocalInterfaces)this.getParent()).checkConfigAdapters();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
            }
            this.updateConfigStatus();
            this.checkDevices();
        } else if (property.equals(localPortMin) || property.equals(localPortMax) && (context == null || !context.equals(Context.copying) && !context.equals(Context.decoding))) {
            this.updateConfigStatus();
        }
    }

    public final String toString(Context context) {
        return super.toString(context) + ": id=" + this.getLocalInterfaceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLicensed() {
        Object object = localInterfacesLock;
        synchronized (object) {
            if (this.getLocalInterfaceId() == 0) {
                int maxLocalInterfaceId = 0;
                for (int i = 0; i < localInterfaces.size(); ++i) {
                    int localInterfaceId = localInterfaces.elementAt(i).getLocalInterfaceId();
                    if (maxLocalInterfaceId >= localInterfaceId) continue;
                    maxLocalInterfaceId = localInterfaceId;
                }
                this.setLocalInterfaceId(maxLocalInterfaceId + 1);
            }
            if (!localInterfaces.contains(this)) {
                LicenseManager licenseManager = Sys.getLicenseManager();
                Feature feature = licenseManager.checkFeature("tridium", TYPE.getModule().getModuleName());
                int localInterfacesLimit = 0;
                String interfacesLimitAttribute = feature.get(LOCAL_INTERFACE_LIMIT_KEY);
                if (interfacesLimitAttribute != null) {
                    if ("none".equals(interfacesLimitAttribute)) {
                        localInterfacesLimit = -1;
                    } else {
                        try {
                            localInterfacesLimit = Integer.parseInt(interfacesLimitAttribute);
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                        }
                    }
                }
                boolean licenseOk = localInterfacesLimit == -1 || localInterfaces.size() < localInterfacesLimit;
                localInterfaces.addElement(this);
                if (!licenseOk) {
                    this.setConfigStatus(BLocalInterfaceConfigStatus.localInterfaceNotLicensed);
                    this.fatalFault = true;
                }
            }
        }
    }

    private void knxInstallationAdded(BKnxInstallation knxInstallation) {
        if (knxInstallation != null && knxInstallation.isRunning()) {
            this.checkConfigKnxInstallationsIps();
        }
    }

    public void checkConfigKnxInstallationsIps() {
        BKnxInstallation[] knxInstallations;
        for (BKnxInstallation knxInstallation : knxInstallations = this.getKnxInstallations()) {
            try {
                knxInstallation.updateConfigStatus();
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    public boolean isDuplicateMulticastIpAddressAndPort(BKnxInstallation knxInstallation) {
        boolean isDuplicate = false;
        String installationAddress = knxInstallation.getMulticastIpAddress();
        int installationPortNumber = knxInstallation.getMulticastPortNumber();
        if (!installationAddress.equals("")) {
            BKnxInstallation[] knxInstallations;
            for (BKnxInstallation installation : knxInstallations = this.getKnxInstallations()) {
                String address = installation.getMulticastIpAddress();
                int portNumber = installation.getMulticastPortNumber();
                if (!address.equals(installationAddress) || portNumber != installationPortNumber) continue;
                if (installation.equals(knxInstallation)) break;
                isDuplicate = true;
                break;
            }
        }
        return isDuplicate;
    }

    private BKnxInstallation[] getKnxInstallations() {
        return (BKnxInstallation[])this.getChildren(BKnxInstallation.class);
    }

    public final void updateStatus() {
        BStatus networkStatus;
        int newStatus = this.getStatus().getBits();
        newStatus &= 3;
        BKnxNetwork network = this.getNetwork();
        BStatus bStatus = networkStatus = network == null ? BStatus.ok : network.getStatus();
        newStatus = !this.getEnabled() || networkStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.fatalFault || this.configFault || networkStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        this.setStatus(BStatus.make((int)newStatus));
        this.updateKnxInstallationsStatus();
    }

    private void updateKnxInstallationsStatus() {
        BKnxInstallation[] knxInstallations;
        for (BKnxInstallation installation : knxInstallations = (BKnxInstallation[])this.getChildren(BKnxInstallation.class)) {
            try {
                installation.updateStatus();
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String cause) {
        if (cause.equals("")) {
            this.configOk();
        } else {
            this.configFault = true;
            if (this.fatalFault) {
                return;
            }
            this.setFaultCause(cause);
            this.updateStatus();
        }
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    void updateConfigStatus() {
        int newStatus = this.getConfigStatus().getBits();
        String adapterId = this.getAdapterId().getAdapterId();
        if (adapterId.equals("")) {
            newStatus |= 2;
            newStatus &= 0xFFFFFFFB;
        } else {
            newStatus &= 0xFFFFFFFD;
            BTcpIpAdapterSettings adapter = this.getTcpIpAdapter(adapterId);
            newStatus = adapter == null ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        }
        BLocalInterfaces parentLocalInterfaces = this.getLocalInterfaces();
        if (parentLocalInterfaces != null) {
            newStatus = parentLocalInterfaces.isAdapterAlreadyInUse(this) ? (newStatus |= 8) : (newStatus &= 0xFFFFFFF7);
        }
        newStatus = this.getLocalPortMin() >= this.getLocalPortMax() ? (newStatus |= 0x10) : (newStatus &= 0xFFFFFFEF);
        this.setConfigStatus(new BLocalInterfaceConfigStatus(newStatus));
    }

    protected final void checkDevices() {
        BDevice[] devices;
        for (BDevice device : devices = this.getDevices()) {
            if (!(device instanceof BKnxDevice)) continue;
            try {
                ((BKnxDevice)device).checkConnections();
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    protected final BDevice[] getDevices() {
        BKnxNetwork network = this.getNetwork();
        if (network != null) {
            return network.getDevices();
        }
        return new BDevice[0];
    }

    protected final BKnxNetwork getNetwork() {
        BComplex parent = this.getParent();
        if (parent instanceof BLocalInterfaces) {
            return (BKnxNetwork)((BLocalInterfaces)parent).getNetwork();
        }
        return null;
    }

    protected final BLocalInterfaces getLocalInterfaces() {
        BComplex parent = this.getParent();
        if (parent instanceof BLocalInterfaces) {
            return (BLocalInterfaces)parent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket obtainAMulticastSocket(InetAddress multicastAddress, int multicastPortNumber) throws SocketException {
        Object object = this.socketAllocationLock;
        synchronized (object) {
            if (multicastPortNumber < 1 || multicastPortNumber > 65535) {
                throw new SocketException("The 'Multicast' port number must be between 1 and 65535.");
            }
            if (this.vAllocatedLocalSockets.contains(multicastPortNumber)) {
                throw new SocketException("The 'Multicast' port number " + multicastPortNumber + " is already allocated.");
            }
            InetSocketAddress socketAddress = null;
            try {
                socketAddress = new InetSocketAddress(multicastAddress, multicastPortNumber);
            }
            catch (IllegalArgumentException ex) {
                throw new SocketException(String.format("Unable to create an InetSocketAddress for the 'Multicast' address (%s), port number (%s) - Caused by :- %s", multicastAddress, multicastPortNumber, ex));
            }
            InetAddress localAddress = this.getLocalAddress();
            if (localAddress == null) {
                throw new SocketException("Unable to obtain the 'Multicast' socket, the local adapter InetAddress == NULL.");
            }
            NetworkInterface netInterface = null;
            try {
                netInterface = NetworkInterface.getByInetAddress(localAddress);
            }
            catch (SocketException ex) {
                throw new SocketException(String.format("Unable to find a network interface bound to InetAddress (%s) - Caused by :- %s", localAddress, ex));
            }
            InetSocketAddress localSocketAddress = null;
            try {
                localSocketAddress = new InetSocketAddress(localAddress, multicastPortNumber);
            }
            catch (IllegalArgumentException ex) {
                throw new SocketException(String.format("Unable to create an InetSocketAddress for the 'Multicast' address (%s), port number (%s) - Caused by :- %s", multicastAddress, multicastPortNumber, ex));
            }
            KnxMulticastSocket socket = null;
            try {
                socket = new KnxMulticastSocket(multicastPortNumber, localSocketAddress, socketAddress, this.igmpAdapter, localAddress);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new SocketException(ex.toString());
            }
            try {
                try {
                    socket.setSoTimeout(1000);
                }
                catch (SocketException ex) {
                    throw new SocketException("Unable to set SO_TIMEOUT on the 'Multicast' socket (" + multicastPortNumber + ") - Caused by :- " + ex);
                }
                try {
                    if (socket instanceof MulticastSocket) {
                        ((MulticastSocket)socket).joinGroup(socketAddress, netInterface);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw new SocketException(String.format("Unable to join the 'Multicast Group' (%s on interface %s) - Caused by :- %s", socketAddress, netInterface, ex));
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                int portNumber = socketAddress.getPort();
                if (portNumber >= 1 && portNumber <= 65535 && !this.vAllocatedLocalSockets.add(portNumber)) {
                    this.releaseAMulticastSocket(socket);
                    return null;
                }
            }
            catch (SocketException ex) {
                this.releaseAMulticastSocket(socket);
                throw ex;
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                this.releaseAMulticastSocket(socket);
                return null;
            }
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAMulticastSocket(DatagramSocket socket) {
        if (socket != null) {
            Object object = this.socketAllocationLock;
            synchronized (object) {
                int multicastPortNumber;
                InetSocketAddress multicastSocketAddress = (InetSocketAddress)(socket instanceof KnxMulticastSocket ? ((KnxMulticastSocket)socket).getRemoteKnxSocketAddress() : socket.getRemoteSocketAddress());
                if (!socket.isClosed()) {
                    try {
                        InetAddress localAddress = this.getLocalAddress();
                        if (localAddress == null) {
                            throw new SocketException("Unable to obtain the 'Multicast' socket, the local adapter InetAddress == NULL.");
                        }
                        NetworkInterface netInterface = null;
                        try {
                            netInterface = NetworkInterface.getByInetAddress(localAddress);
                        }
                        catch (SocketException ex) {
                            throw new SocketException("Unable to find a netowrk interface bound to InetAddress (" + localAddress + ") - Caused by :- " + ex);
                        }
                        if (socket instanceof MulticastSocket) {
                            ((MulticastSocket)socket).leaveGroup(multicastSocketAddress, netInterface);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    socket.close();
                }
                if ((multicastPortNumber = multicastSocketAddress.getPort()) >= 1 && multicastPortNumber <= 65535) {
                    this.vAllocatedLocalSockets.remove(new Integer(multicastPortNumber));
                }
            }
        }
    }

    private int[] getMulticastPortNumbers() {
        BKnxInstallation[] knxInstallations = (BKnxInstallation[])this.getChildren(BKnxInstallation.class);
        int[] multicastPortNumbers = new int[knxInstallations.length];
        for (int i = 0; i < knxInstallations.length; ++i) {
            multicastPortNumbers[i] = knxInstallations[i].getMulticastPortNumber();
        }
        return multicastPortNumbers;
    }

    public final DatagramSocket obtainALocalSocket() throws SocketException {
        return this.obtainALocalSocket(false, false, -1);
    }

    public final DatagramSocket obtainALocalSocket(boolean broadcast) throws SocketException {
        return this.obtainALocalSocket(broadcast, false, -1);
    }

    public final DatagramSocket obtainALocalSocket(int portNumber) throws SocketException {
        return this.obtainALocalSocket(false, false, portNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DatagramSocket obtainALocalSocket(boolean broadcast, boolean reuseAddress, int portNumber) throws SocketException {
        Object object = this.socketAllocationLock;
        synchronized (object) {
            boolean traceOn;
            InetAddress localAddress;
            DatagramSocket socket = null;
            int minPort = this.getLocalPortMin();
            int maxPort = this.getLocalPortMax();
            int iPort = this.getLastUsedLocalPort();
            if (iPort < minPort || iPort > maxPort) {
                iPort = minPort;
                this.setLastUsedLocalPort(iPort);
            }
            if (this.getObtainLocalSocketBehaviour().equals((Object)BObtainLocalSocketBehaviourEnum.recyclePortsImmediately)) {
                iPort = maxPort;
            }
            if ((localAddress = this.getLocalAddress()) == null) {
                throw new SocketException("Unable to obtain a local socket, the local adapter InetAddress == NULL.");
            }
            boolean bl = traceOn = this.getIncludeInTrace() && BAbstractLocalInterface.getLogger().isLoggable(Level.FINE);
            if (!reuseAddress && portNumber == -1) {
                int[] multicastPortNumbers = this.getMulticastPortNumbers();
                int iNumPorts = maxPort - minPort + 1;
                for (int i = 0; i < iNumPorts; ++i) {
                    if (++iPort > maxPort) {
                        iPort = minPort;
                    }
                    if (traceOn) {
                        BAbstractLocalInterface.getLogger().fine("checking if port " + iPort + " is available on local interface '" + this.getName() + "'");
                    }
                    boolean portFree = true;
                    for (int multicastPortNumber : multicastPortNumbers) {
                        if (iPort != multicastPortNumber) continue;
                        portFree = false;
                        break;
                    }
                    if (!portFree) {
                        if (!traceOn) continue;
                        BAbstractLocalInterface.getLogger().fine("skipping over the KNXnet/IP 'Multicast' Port Number - " + iPort);
                        continue;
                    }
                    if (this.vAllocatedLocalSockets.contains(iPort)) {
                        if (!traceOn) continue;
                        BAbstractLocalInterface.getLogger().fine("skipping over Port Number " + iPort + " on local interface '" + this.getName() + "' -  already in use.");
                        continue;
                    }
                    socket = this.obtainALocalSocket(broadcast, reuseAddress, iPort, localAddress, traceOn);
                    if (socket == null) {
                        continue;
                    }
                    break;
                }
            } else {
                socket = this.obtainALocalSocket(broadcast, reuseAddress, portNumber, localAddress, traceOn);
                iPort = portNumber;
            }
            if (socket == null) {
                throw new SocketException("unable to find any available local ports in the range " + minPort + " to " + maxPort + " on local interface '" + this.getName() + "'");
            }
            if (traceOn) {
                BAbstractLocalInterface.getLogger().fine("obtained local socket " + iPort + " on local interface '" + this.getName() + "'");
            }
            this.setLastUsedLocalPort(iPort);
            if (iPort >= 1 && iPort <= 65535) {
                this.vAllocatedLocalSockets.add(iPort);
            }
            return socket;
        }
    }

    protected final DatagramSocket obtainALocalSocket(boolean broadcast, boolean reuseAddress, int portNumber, InetAddress localAddress, boolean traceOn) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket(portNumber, localAddress);
        }
        catch (SocketException ex) {
            if (traceOn) {
                BAbstractLocalInterface.getLogger().fine("unable to obtain local socket " + portNumber + " on local interface '" + this.getName() + "' - " + ex);
            }
            return socket;
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
            if (socket != null) {
                socket.close();
                socket = null;
            }
            return socket;
        }
        try {
            socket.setBroadcast(broadcast);
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
            socket.close();
            socket = null;
            return socket;
        }
        try {
            socket.setReuseAddress(reuseAddress);
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
            socket.close();
            socket = null;
            return socket;
        }
        try {
            socket.setSoTimeout(1000);
        }
        catch (SocketException ex) {
            if (traceOn) {
                BAbstractLocalInterface.getLogger().fine("unable to set SO_TIMEOUT on local socket " + portNumber + " on local interface '" + this.getName() + "' - " + ex);
            }
            socket.close();
            socket = null;
            return socket;
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseALocalSocket(DatagramSocket socket) {
        if (socket != null) {
            Object object = this.socketAllocationLock;
            synchronized (object) {
                int portNumber = socket.getLocalPort();
                if (!socket.isClosed()) {
                    socket.close();
                }
                if (portNumber >= 1 && portNumber <= 65535) {
                    this.vAllocatedLocalSockets.remove(new Integer(portNumber));
                }
            }
        }
    }

    public final boolean isDeviceAccessible(InetAddress deviceInetAddress) {
        if (deviceInetAddress == null) {
            return false;
        }
        BTcpIpAdapter adapter = this.getAdapterId();
        if (adapter != null && !adapter.getDisabled() && !adapter.getMissing()) {
            int deviceAddress = ByteArrayUtil.readInt((byte[])deviceInetAddress.getAddress(), (int)0);
            byte[] bytes = IPAddressUtil.numericStringToByteArray((String)adapter.getIpAddress());
            if (bytes != null) {
                int subnetMask;
                int adapterAddress = ByteArrayUtil.readInt((byte[])bytes, (int)0);
                bytes = IPAddressUtil.numericStringToByteArray((String)adapter.getSubnetMask());
                if (bytes != null && (deviceAddress & (subnetMask = ByteArrayUtil.readInt((byte[])bytes, (int)0))) == (adapterAddress & subnetMask)) {
                    return true;
                }
            }
        }
        return false;
    }

    public final String getMacAddress() {
        BTcpIpAdapterSettings adapter = this.getTcpIpAdapter();
        if (adapter != null) {
            return adapter.getMediaAccessControlAddress();
        }
        return "";
    }

    protected final BTcpIpAdapterSettings getTcpIpAdapter() {
        String adapterId = this.getAdapterId().getAdapterId();
        return this.getTcpIpAdapter(adapterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BTcpIpAdapterSettings getTcpIpAdapter(String adapterId) {
        BTcpIpHostSettings hostSettings = this.getLocalInterfaces().doFetchTcpIpHostSettings();
        if (hostSettings != null) {
            try (SlotCursor c = hostSettings.getAdapters().getProperties();){
                while (c.next(BTcpIpAdapterSettings.class)) {
                    BTcpIpAdapterSettings adapterSettings = (BTcpIpAdapterSettings)c.get();
                    if (!adapterId.equals(adapterSettings.getAdapterId())) continue;
                    BTcpIpAdapterSettings bTcpIpAdapterSettings = adapterSettings;
                    return bTcpIpAdapterSettings;
                }
            }
        }
        return null;
    }

    protected final void updateLocalAddress() {
        if (!this.isRunning()) {
            return;
        }
        try {
            BTcpIpAdapterSettings adapter = this.getTcpIpAdapter();
            if (adapter == null) {
                this.adapterInetAddress = null;
                return;
            }
            if (adapter.getIpAddress().equals("")) {
                this.adapterInetAddress = null;
                return;
            }
            this.adapterInetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)adapter.getIpAddress()));
        }
        catch (Exception ex) {
            BAbstractLocalInterface.getLogger().log(Level.SEVERE, "Invalid KNXnet/IP Interface configuration!", ex);
            this.adapterInetAddress = null;
        }
    }

    public final InetAddress getLocalAddress() {
        if (this.adapterInetAddress == null) {
            this.updateLocalAddress();
        }
        return this.adapterInetAddress;
    }

    public final void pingInterface() {
        InetAddress addr = this.getLocalAddress();
        if (addr != null && this.getAdapterIpAddress().equals("")) {
            this.setAdapterIpAddress(addr.getHostAddress());
            this.checkDevices();
        }
    }

    public boolean getUseBacnetToSend() {
        BTcpIpHostSettings hostSettings = this.getLocalInterfaces().doFetchTcpIpHostSettings();
        return !hostSettings.getUsesAdapterLevelSettings();
    }

    protected final void openRawAdapter() {
        BAbstractLocalInterface.getBacnetPlatformService().init();
        try {
            this.igmpAdapter = this.openAdapter();
        }
        catch (Exception ex) {
            BAbstractLocalInterface.getLogger().log(Level.SEVERE, "Unable to open raw adapter", ex);
        }
        if (this.igmpAdapter == null) {
            BAbstractLocalInterface.getLogger().severe("Failed to open raw adapter");
            return;
        }
        if (logInterface.isLoggable(Level.FINE)) {
            BAbstractLocalInterface.getLogger().fine("calling igmpAdapter.commStart()");
        }
        this.igmpAdapter.commStart();
    }

    protected final void closeRawAdapter() {
        if (this.igmpAdapter != null) {
            if (BAbstractLocalInterface.getLogger().isLoggable(Level.FINE)) {
                BAbstractLocalInterface.getLogger().fine("calling igmpAdapter.commStop()");
            }
            this.igmpAdapter.commStop();
            if (BAbstractLocalInterface.getLogger().isLoggable(Level.FINE)) {
                BAbstractLocalInterface.getLogger().fine("calling igmpAdapter.commCleanup()");
            }
            this.igmpAdapter.commCleanup();
            this.igmpAdapter = null;
        }
    }

    public static BBacnetEthernetPlatformService getBacnetPlatformService() {
        try {
            BBacnetEthernetPlatformService svc = (BBacnetEthernetPlatformService)Sys.getService((Type)BBacnetEthernetPlatformService.TYPE);
            svc.lease(0, 10L);
            svc.poll();
            return svc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final BacnetEthernetAdapter openAdapter() throws Exception {
        String ipAdapterName = SlotPath.unescape((String)this.getAdapterId().getAdapterId());
        String ipAdapterDescription = SlotPath.unescape((String)this.getAdapterId().getDescription());
        Vector adapterTitles = new Vector();
        Vector adapterDescriptions = new Vector();
        Vector adapterNames = new Vector();
        BacnetEthernetAdapter adapter = null;
        BAbstractLocalInterface.getBacnetPlatformService().getAdapterChoices(adapterTitles, adapterDescriptions, adapterNames);
        for (int i = 0; i < adapterNames.size(); ++i) {
            String adapterTitle = (String)adapterTitles.elementAt(i);
            String adapterDescription = (String)adapterDescriptions.elementAt(i);
            String adapterName = (String)adapterNames.elementAt(i);
            if (this.getIncludeInTrace() && BAbstractLocalInterface.getLogger().isLoggable(Level.FINE)) {
                BAbstractLocalInterface.getLogger().fine("adapterTitle " + i + ':' + adapterTitle);
                BAbstractLocalInterface.getLogger().fine("adapterDescription " + i + ':' + adapterDescription);
                BAbstractLocalInterface.getLogger().fine("adapterName " + i + ':' + adapterName);
            }
            if (adapterName.endsWith(ipAdapterName)) {
                adapter = BAbstractLocalInterface.getBacnetPlatformService().openAdapter((String)adapterNames.elementAt(i));
                continue;
            }
            if (!ipAdapterDescription.startsWith(adapterDescription)) continue;
            adapter = BAbstractLocalInterface.getBacnetPlatformService().openAdapter((String)adapterNames.elementAt(i));
        }
        return adapter;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning()) {
            return;
        }
        out.startProps();
        out.trTitle((Object)TYPE.getTypeName(), 2);
        BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapter();
        out.prop((Object)"TCP/IP Adapter:", (Object)adapterSettings);
        if (adapterSettings != null) {
            out.prop((Object)"  adapterId", (Object)adapterSettings.getAdapterId());
            out.prop((Object)"  isAdapterEnabled", adapterSettings.getIsAdapterEnabled());
            out.prop((Object)"  canDisableAdapter", adapterSettings.getCanDisableAdapter());
            out.prop((Object)"  description", (Object)adapterSettings.getDescription());
            out.prop((Object)"  isDhcpEnabled", adapterSettings.getIsDhcpEnabled());
            out.prop((Object)"  canUseDhcp", adapterSettings.getCanUseDhcp());
            out.prop((Object)"  defaultGateway", (Object)adapterSettings.getDefaultGateway());
            out.prop((Object)"  dnsHosts", (Object)Dump.dumpVec(adapterSettings.getDnsHosts()));
            out.prop((Object)"  domain", (Object)adapterSettings.getDomain());
            out.prop((Object)"  ipaddress", (Object)adapterSettings.getIpAddress());
            out.prop((Object)"  subnetmask", (Object)adapterSettings.getSubnetMask());
            out.prop((Object)"  dhcpHost", (Object)adapterSettings.getDhcpHost());
            out.prop((Object)"  dchpLeaseGranted", (Object)adapterSettings.getDhcpLeaseGranted());
            out.prop((Object)"  dhcpLeaseExpires", (Object)adapterSettings.getDhcpLeaseExpires());
        }
        out.prop((Object)"adapterInetAddress", (Object)this.adapterInetAddress.getHostAddress());
        out.endProps();
    }

    protected static Logger getLogger() {
        return logInterface;
    }
}

