/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.addresses;

import com.tridiumX.knxnetIp.addresses.BKnxAddressStyle;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.addresses.IKnxAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="address", type="int", defaultValue="0"), @NiagaraProperty(name="style", type="BKnxAddressStyleEnum", defaultValue="BKnxAddressStyleEnum.DEFAULT", flags=1)})
public abstract class BKnxAddress
extends BStruct
implements IKnxAddress {
    public static final Property address = BKnxAddress.newProperty((int)0, (int)0, null);
    public static final Property style = BKnxAddress.newProperty((int)1, (BValue)BKnxAddressStyleEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BKnxAddress.class);
    protected static final Logger logGroupAddressDisplay = Logger.getLogger(TYPE.getModule().getModuleName() + ".groupAddressDisplay");

    @Override
    public int getAddress() {
        return this.getInt(address);
    }

    @Override
    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    public BKnxAddressStyleEnum getStyle() {
        return (BKnxAddressStyleEnum)this.get(style);
    }

    public void setStyle(BKnxAddressStyleEnum v) {
        this.set(style, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BKnxAddress(BKnxAddressStyleEnum addressStyle) {
        this.setStyle(addressStyle);
    }

    protected BKnxAddress(int address, BKnxAddressStyleEnum addressStyle) {
        this.setAddress(address);
        this.setStyle(addressStyle);
    }

    @Override
    public final String getFriendlyAddress() {
        String s = "";
        switch (this.getStyle().getOrdinal()) {
            case 1: {
                s = BKnxAddressStyle.kasIndividualDevice.getFriendlyAddress(this);
                break;
            }
            case 2: {
                s = BKnxAddressStyle.kas2LevelGroup.getFriendlyAddress(this);
                break;
            }
            case 3: {
                s = BKnxAddressStyle.kas3LevelGroup.getFriendlyAddress(this);
                break;
            }
            case 4: {
                s = BKnxAddressStyle.kasFreeGroup.getFriendlyAddress(this);
                break;
            }
            default: {
                if (logGroupAddressDisplay.isLoggable(Level.FINE)) {
                    logGroupAddressDisplay.info("Unknown/Invalid AddressStyle ('" + this.getStyle().getOrdinal() + "') prevents interpreting address '" + this.getAddress() + "' as a KNXAddress.");
                }
                s = "" + this.getAddress();
            }
        }
        return s;
    }

    @Override
    public final void setFriendlyAddress(String address) throws Exception {
        switch (this.getStyle().getOrdinal()) {
            case 1: {
                this.setAddress(BKnxAddressStyle.kasIndividualDevice.getFriendlyAddress(address).getAddress());
                break;
            }
            case 2: {
                this.setAddress(BKnxAddressStyle.kas2LevelGroup.getFriendlyAddress(address).getAddress());
                break;
            }
            case 3: {
                this.setAddress(BKnxAddressStyle.kas3LevelGroup.getFriendlyAddress(address).getAddress());
                break;
            }
            case 4: {
                this.setAddress(BKnxAddressStyle.kasFreeGroup.getFriendlyAddress(address).getAddress());
                break;
            }
            default: {
                throw new Exception("Unknown/Invalid AddressStyle ('" + this.getStyle().getOrdinal() + "') prevents interpreting address '" + address + "' as a KNXAddress.");
            }
        }
    }

    public final BKnxAddressStyle getAddressStyle() throws Exception {
        BKnxAddressStyle addressStyle = null;
        switch (this.getStyle().getOrdinal()) {
            case 1: {
                addressStyle = BKnxAddressStyle.kasIndividualDevice;
                break;
            }
            case 2: {
                addressStyle = BKnxAddressStyle.kas2LevelGroup;
                break;
            }
            case 3: {
                addressStyle = BKnxAddressStyle.kas3LevelGroup;
                break;
            }
            case 4: {
                addressStyle = BKnxAddressStyle.kasFreeGroup;
                break;
            }
            default: {
                throw new Exception("Unknown/Invalid AddressStyle ('" + this.getStyle().getOrdinal() + "').");
            }
        }
        return addressStyle;
    }

    public final String toString(Context context) {
        if (logGroupAddressDisplay.isLoggable(Level.FINE)) {
            logGroupAddressDisplay.fine("context = " + context + ", getAddress() = " + this.getAddress());
        }
        return this.getFriendlyAddress();
    }
}

