/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BRuntimeBalancerOutputEnum;
import com.vykon.vykonPro.hvac.BManualBalancerCmd;
import com.vykon.vykonPro.util.BDisabledLoadsBitString;
import com.vykon.vykonPro.util.BRuntimeItem;
import com.vykon.vykonPro.util.RuntimeItemComparator;
import com.vykon.vykonPro.util.RuntimeItemComparatorDesc;
import java.util.Arrays;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRuntimeBalancer
extends BComponent {
    public static final Property facets = BRuntimeBalancer.newProperty((int)256, (BValue)BFacets.makeBoolean(), null);
    public static final Property actionFacets = BRuntimeBalancer.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)), null);
    public static final Property schedule = BRuntimeBalancer.newProperty((int)264, (BValue)new BStatusBoolean(), null);
    public static final Property loadFailed = BRuntimeBalancer.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BRuntimeBalancer.newProperty((int)256, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property requiredLoads = BRuntimeBalancer.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)10));
    public static final Property lastRotateTime = BRuntimeBalancer.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property runtimeRemainingUntilShift = BRuntimeBalancer.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property leadLoad = BRuntimeBalancer.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE))), null);
    public static final Property leadRuntimeAtStart = BRuntimeBalancer.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property nextLoad = BRuntimeBalancer.newProperty((int)1, (String)"", null);
    public static final Property nextLeadLoad = BRuntimeBalancer.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE))), null);
    public static final Property rotateMode = BRuntimeBalancer.newProperty((int)256, (boolean)false, (BFacets)BFacets.makeBoolean((String)"manual", (String)"interval"));
    public static final Property rotateInterval = BRuntimeBalancer.newProperty((int)256, (BValue)BRelTime.makeHours((int)168), null);
    public static final Property feedbackDelay = BRuntimeBalancer.newProperty((int)256, (BValue)BRelTime.make((long)30000L), null);
    public static final Property outA = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property runtimeA = BRuntimeBalancer.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeB = BRuntimeBalancer.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeC = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeD = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeE = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeF = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeG = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeH = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeI = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeJ = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property disabledLoads = BRuntimeBalancer.newProperty((int)69, (BValue)new BDisabledLoadsBitString(0), null);
    public static final Action startupTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action rotateTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action countdownTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action disableOutput = BRuntimeBalancer.newAction((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)), null);
    public static final Action enableOutput = BRuntimeBalancer.newAction((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)), null);
    public static final Action manualCmd = BRuntimeBalancer.newAction((int)0, (BValue)new BManualBalancerCmd(), null);
    public static final Action manualRotate = BRuntimeBalancer.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BRuntimeBalancer.class);
    private static final BIcon icon = BIcon.std((String)"scales.png");
    int numOutputs;
    int lastNumberOutputs;
    int lastRequiredLoads;
    int startedLoads;
    int runningLoads;
    boolean feedbackTimerActive = false;
    boolean currentIn;
    boolean wasOn = false;
    BRuntimeItem[] rt;
    Clock.Ticket rotateTicket;
    Clock.Ticket feedbackTicket;
    Clock.Ticket startupTicket;
    Clock.Ticket countdownTicket;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BFacets getActionFacets() {
        return (BFacets)this.get(actionFacets);
    }

    public void setActionFacets(BFacets v) {
        this.set(actionFacets, (BValue)v, null);
    }

    public BStatusBoolean getSchedule() {
        return (BStatusBoolean)this.get(schedule);
    }

    public void setSchedule(BStatusBoolean v) {
        this.set(schedule, (BValue)v, null);
    }

    public BStatusBoolean getLoadFailed() {
        return (BStatusBoolean)this.get(loadFailed);
    }

    public void setLoadFailed(BStatusBoolean v) {
        this.set(loadFailed, (BValue)v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public int getRequiredLoads() {
        return this.getInt(requiredLoads);
    }

    public void setRequiredLoads(int v) {
        this.setInt(requiredLoads, v, null);
    }

    public BAbsTime getLastRotateTime() {
        return (BAbsTime)this.get(lastRotateTime);
    }

    public void setLastRotateTime(BAbsTime v) {
        this.set(lastRotateTime, (BValue)v, null);
    }

    public BRelTime getRuntimeRemainingUntilShift() {
        return (BRelTime)this.get(runtimeRemainingUntilShift);
    }

    public void setRuntimeRemainingUntilShift(BRelTime v) {
        this.set(runtimeRemainingUntilShift, (BValue)v, null);
    }

    public BStatusEnum getLeadLoad() {
        return (BStatusEnum)this.get(leadLoad);
    }

    public void setLeadLoad(BStatusEnum v) {
        this.set(leadLoad, (BValue)v, null);
    }

    public BRelTime getLeadRuntimeAtStart() {
        return (BRelTime)this.get(leadRuntimeAtStart);
    }

    public void setLeadRuntimeAtStart(BRelTime v) {
        this.set(leadRuntimeAtStart, (BValue)v, null);
    }

    public String getNextLoad() {
        return this.getString(nextLoad);
    }

    public void setNextLoad(String v) {
        this.setString(nextLoad, v, null);
    }

    public BStatusEnum getNextLeadLoad() {
        return (BStatusEnum)this.get(nextLeadLoad);
    }

    public void setNextLeadLoad(BStatusEnum v) {
        this.set(nextLeadLoad, (BValue)v, null);
    }

    public boolean getRotateMode() {
        return this.getBoolean(rotateMode);
    }

    public void setRotateMode(boolean v) {
        this.setBoolean(rotateMode, v, null);
    }

    public BRelTime getRotateInterval() {
        return (BRelTime)this.get(rotateInterval);
    }

    public void setRotateInterval(BRelTime v) {
        this.set(rotateInterval, (BValue)v, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime v) {
        this.set(feedbackDelay, (BValue)v, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean v) {
        this.set(feedbackA, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean v) {
        this.set(feedbackB, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean v) {
        this.set(feedbackC, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean v) {
        this.set(feedbackD, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean v) {
        this.set(feedbackE, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean v) {
        this.set(feedbackF, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean v) {
        this.set(feedbackG, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean v) {
        this.set(feedbackH, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean v) {
        this.set(feedbackI, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean v) {
        this.set(feedbackJ, (BValue)v, null);
    }

    public BRelTime getRuntimeA() {
        return (BRelTime)this.get(runtimeA);
    }

    public void setRuntimeA(BRelTime v) {
        this.set(runtimeA, (BValue)v, null);
    }

    public BRelTime getRuntimeB() {
        return (BRelTime)this.get(runtimeB);
    }

    public void setRuntimeB(BRelTime v) {
        this.set(runtimeB, (BValue)v, null);
    }

    public BRelTime getRuntimeC() {
        return (BRelTime)this.get(runtimeC);
    }

    public void setRuntimeC(BRelTime v) {
        this.set(runtimeC, (BValue)v, null);
    }

    public BRelTime getRuntimeD() {
        return (BRelTime)this.get(runtimeD);
    }

    public void setRuntimeD(BRelTime v) {
        this.set(runtimeD, (BValue)v, null);
    }

    public BRelTime getRuntimeE() {
        return (BRelTime)this.get(runtimeE);
    }

    public void setRuntimeE(BRelTime v) {
        this.set(runtimeE, (BValue)v, null);
    }

    public BRelTime getRuntimeF() {
        return (BRelTime)this.get(runtimeF);
    }

    public void setRuntimeF(BRelTime v) {
        this.set(runtimeF, (BValue)v, null);
    }

    public BRelTime getRuntimeG() {
        return (BRelTime)this.get(runtimeG);
    }

    public void setRuntimeG(BRelTime v) {
        this.set(runtimeG, (BValue)v, null);
    }

    public BRelTime getRuntimeH() {
        return (BRelTime)this.get(runtimeH);
    }

    public void setRuntimeH(BRelTime v) {
        this.set(runtimeH, (BValue)v, null);
    }

    public BRelTime getRuntimeI() {
        return (BRelTime)this.get(runtimeI);
    }

    public void setRuntimeI(BRelTime v) {
        this.set(runtimeI, (BValue)v, null);
    }

    public BRelTime getRuntimeJ() {
        return (BRelTime)this.get(runtimeJ);
    }

    public void setRuntimeJ(BRelTime v) {
        this.set(runtimeJ, (BValue)v, null);
    }

    public BDisabledLoadsBitString getDisabledLoads() {
        return (BDisabledLoadsBitString)this.get(disabledLoads);
    }

    public void setDisabledLoads(BDisabledLoadsBitString v) {
        this.set(disabledLoads, (BValue)v, null);
    }

    public void startupTimerExpired() {
        this.invoke(startupTimerExpired, null, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    public void countdownTimerExpired() {
        this.invoke(countdownTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void disableOutput(BEnum output) {
        this.invoke(disableOutput, (BValue)output, null);
    }

    public void enableOutput(BEnum output) {
        this.invoke(enableOutput, (BValue)output, null);
    }

    public void manualCmd(BManualBalancerCmd manCmd) {
        this.invoke(manualCmd, (BValue)manCmd, null);
    }

    public void manualRotate() {
        this.invoke(manualRotate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initNumberOutputs();
        this.checkNextLoad();
        this.startupTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)startupTimerExpired, null);
    }

    public void stopped() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (p == numberOutputs) {
            this.initNumberOutputs();
        } else if (p == schedule) {
            this.calculate();
        } else if (p == requiredLoads) {
            if (this.getSchedule().getValue()) {
                this.updateRequiredLoads();
            }
        } else if (p == feedbackA || p == feedbackB || p == feedbackC || p == feedbackD || p == feedbackE || p == feedbackF || p == feedbackG || p == feedbackH || p == feedbackI || p == feedbackJ) {
            if (!this.currentIn) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.checkRunningStatus();
        } else if (p == rotateMode) {
            if (this.getRotateMode()) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
            } else {
                this.startRotateTimer();
            }
        } else if (p == rotateInterval && !this.getRotateMode()) {
            this.startRotateTimer();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        this.rt = new BRuntimeItem[this.numOutputs];
        for (int i = 0; i < 10; ++i) {
            int setFlags = i >= this.numOutputs ? 6 : 10;
            switch (i) {
                case 0: {
                    this.initSlot("outA", setFlags | 1);
                    this.initSlot("runtimeA", setFlags);
                    this.initSlot("feedbackA", setFlags);
                    break;
                }
                case 1: {
                    this.initSlot("outB", setFlags | 1);
                    this.initSlot("runtimeB", setFlags);
                    this.initSlot("feedbackB", setFlags);
                    break;
                }
                case 2: {
                    this.initSlot("outC", setFlags | 1);
                    this.initSlot("runtimeC", setFlags);
                    this.initSlot("feedbackC", setFlags);
                    break;
                }
                case 3: {
                    this.initSlot("outD", setFlags | 1);
                    this.initSlot("runtimeD", setFlags);
                    this.initSlot("feedbackD", setFlags);
                    break;
                }
                case 4: {
                    this.initSlot("outE", setFlags | 1);
                    this.initSlot("runtimeE", setFlags);
                    this.initSlot("feedbackE", setFlags);
                    break;
                }
                case 5: {
                    this.initSlot("outF", setFlags | 1);
                    this.initSlot("runtimeF", setFlags);
                    this.initSlot("feedbackF", setFlags);
                    break;
                }
                case 6: {
                    this.initSlot("outG", setFlags | 1);
                    this.initSlot("runtimeG", setFlags);
                    this.initSlot("feedbackG", setFlags);
                    break;
                }
                case 7: {
                    this.initSlot("outH", setFlags | 1);
                    this.initSlot("runtimeH", setFlags);
                    this.initSlot("feedbackH", setFlags);
                    break;
                }
                case 8: {
                    this.initSlot("outI", setFlags | 1);
                    this.initSlot("runtimeI", setFlags);
                    this.initSlot("feedbackI", setFlags);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", setFlags | 1);
                    this.initSlot("runtimeJ", setFlags);
                    this.initSlot("feedbackJ", setFlags);
                }
            }
            int[] disabledLoads = this.getDisabledLoads().getOrdinals();
            for (int k = 0; k < disabledLoads.length; ++k) {
                if (!this.getDisabledLoads().getBit(disabledLoads[k])) continue;
                String loadName = this.getDisabledLoads().getTag(disabledLoads[k]);
                ((BStatusBoolean)this.get(loadName)).setStatusDisabled(true);
            }
        }
    }

    void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStartupTimerExpired() {
        this.calculate();
    }

    public void doRotateTimerExpired() {
        if (!this.currentIn) {
            return;
        }
        this.getRuntimes();
        this.startOutput();
        this.startRotateTimer();
    }

    public void doCountdownTimerExpired() {
        BAbsTime nextTime;
        BAbsTime currentTime = Clock.time();
        BRelTime timeLeft = currentTime.delta(nextTime = this.getLastRotateTime().add(this.getRotateInterval()));
        if (timeLeft.getMillis() > 1000L) {
            this.setRuntimeRemainingUntilShift(timeLeft);
        } else {
            this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
        }
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doManualRotate() {
        if (!this.currentIn) {
            return;
        }
        this.getRuntimes();
        this.startOutput();
    }

    void calculate() {
        this.lastRequiredLoads = this.getRequiredLoads();
        this.currentIn = this.getSchedule().getValue();
        this.getRuntimes();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                if (!this.getRotateMode()) {
                    this.startRotateTimer();
                } else {
                    this.startCountdownTimer();
                }
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                if (this.countdownTicket != null) {
                    this.countdownTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    void getRuntimes() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.rt[i] = this.isRuntimeLinked(i) && !this.getStatusOutput(i).getStatus().isDisabled() ? new BRuntimeItem(i, this.getRuntime(i)) : new BRuntimeItem(i, Long.MAX_VALUE);
        }
    }

    void getOnRuntimes() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.rt[i] = this.isRuntimeLinked(i) && this.getOutValue(i) && !this.getStatusOutput(i).getStatus().isAlarm() ? new BRuntimeItem(i, this.getRuntime(i)) : new BRuntimeItem(i, Long.MIN_VALUE);
        }
    }

    void getOffRuntimes() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.rt[i] = this.isRuntimeLinked(i) && !this.getOutValue(i) && !this.getStatusOutput(i).getStatus().isDisabled() ? new BRuntimeItem(i, this.getRuntime(i)) : new BRuntimeItem(i, Long.MAX_VALUE);
        }
    }

    long getRuntime(int index) {
        switch (index) {
            case 0: {
                return this.getRuntimeA().getMillis();
            }
            case 1: {
                return this.getRuntimeB().getMillis();
            }
            case 2: {
                return this.getRuntimeC().getMillis();
            }
            case 3: {
                return this.getRuntimeD().getMillis();
            }
            case 4: {
                return this.getRuntimeE().getMillis();
            }
            case 5: {
                return this.getRuntimeF().getMillis();
            }
            case 6: {
                return this.getRuntimeG().getMillis();
            }
            case 7: {
                return this.getRuntimeH().getMillis();
            }
            case 8: {
                return this.getRuntimeI().getMillis();
            }
            case 9: {
                return this.getRuntimeJ().getMillis();
            }
        }
        return Long.MAX_VALUE;
    }

    boolean getOutValue(int index) {
        switch (index) {
            case 0: {
                return this.getOutA().getValue();
            }
            case 1: {
                return this.getOutB().getValue();
            }
            case 2: {
                return this.getOutC().getValue();
            }
            case 3: {
                return this.getOutD().getValue();
            }
            case 4: {
                return this.getOutE().getValue();
            }
            case 5: {
                return this.getOutF().getValue();
            }
            case 6: {
                return this.getOutG().getValue();
            }
            case 7: {
                return this.getOutH().getValue();
            }
            case 8: {
                return this.getOutI().getValue();
            }
            case 9: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean getFeedbackValue(int index) {
        switch (index) {
            case 0: {
                return this.getFeedbackA().getValue();
            }
            case 1: {
                return this.getFeedbackB().getValue();
            }
            case 2: {
                return this.getFeedbackC().getValue();
            }
            case 3: {
                return this.getFeedbackD().getValue();
            }
            case 4: {
                return this.getFeedbackE().getValue();
            }
            case 5: {
                return this.getFeedbackF().getValue();
            }
            case 6: {
                return this.getFeedbackG().getValue();
            }
            case 7: {
                return this.getFeedbackH().getValue();
            }
            case 8: {
                return this.getFeedbackI().getValue();
            }
            case 9: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    boolean isRuntimeLinked(int index) {
        BLink[] links = null;
        switch (index) {
            case 0: {
                links = this.getLinks((Slot)runtimeA);
                break;
            }
            case 1: {
                links = this.getLinks((Slot)runtimeB);
                break;
            }
            case 2: {
                links = this.getLinks((Slot)runtimeC);
                break;
            }
            case 3: {
                links = this.getLinks((Slot)runtimeD);
                break;
            }
            case 4: {
                links = this.getLinks((Slot)runtimeE);
                break;
            }
            case 5: {
                links = this.getLinks((Slot)runtimeF);
                break;
            }
            case 6: {
                links = this.getLinks((Slot)runtimeG);
                break;
            }
            case 7: {
                links = this.getLinks((Slot)runtimeH);
                break;
            }
            case 8: {
                links = this.getLinks((Slot)runtimeI);
                break;
            }
            case 9: {
                links = this.getLinks((Slot)runtimeJ);
            }
        }
        if (links == null) {
            return false;
        }
        return links.length != 0;
    }

    void startOutput() {
        Arrays.sort(this.rt, new RuntimeItemComparator());
        boolean first = false;
        for (int i = 0; i < this.numOutputs; ++i) {
            int j = this.rt[i].getOutSlot();
            if (i < this.getRequiredLoads()) {
                this.getStatusOutput(j).setValue(true);
                if (first) continue;
                this.getLeadLoad().setValue(BDynamicEnum.make((int)j, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)));
                first = true;
                this.setLastRotateTime(BAbsTime.now());
                this.setRuntimeRemainingUntilShift(this.getRotateInterval());
                this.setLeadRuntimeAtStart(BRelTime.make((long)this.getRuntime(j)));
                this.startCountdownTimer();
                continue;
            }
            this.getStatusOutput(j).setValue(false);
        }
        this.startFeedbackTimer();
        this.checkNextLoad();
    }

    void startLag(int loads) {
        Arrays.sort(this.rt, new RuntimeItemComparator());
        for (int i = 0; i < loads; ++i) {
            int j = this.rt[i].getOutSlot();
            this.getStatusOutput(j).setValue(true);
        }
        this.startFeedbackTimer();
        this.checkNextLoad();
    }

    void stopLag(int loads) {
        Arrays.sort(this.rt, new RuntimeItemComparatorDesc());
        for (int i = 0; i < loads; ++i) {
            int j = this.rt[i].getOutSlot();
            this.getStatusOutput(j).setValue(false);
        }
        this.checkNextLoad();
    }

    void updateRequiredLoads() {
        if (this.getRequiredLoads() > this.lastRequiredLoads) {
            this.getOffRuntimes();
            this.startLag(this.getRequiredLoads() - this.lastRequiredLoads);
        } else if (this.getRequiredLoads() < this.lastRequiredLoads) {
            this.getOnRuntimes();
            this.stopLag(this.lastRequiredLoads - this.getRequiredLoads());
        }
        this.lastRequiredLoads = this.getRequiredLoads();
    }

    BStatusBoolean getStatusOutput(int index) {
        switch (index) {
            case 0: {
                return this.getOutA();
            }
            case 1: {
                return this.getOutB();
            }
            case 2: {
                return this.getOutC();
            }
            case 3: {
                return this.getOutD();
            }
            case 4: {
                return this.getOutE();
            }
            case 5: {
                return this.getOutF();
            }
            case 6: {
                return this.getOutG();
            }
            case 7: {
                return this.getOutH();
            }
            case 8: {
                return this.getOutI();
            }
            case 9: {
                return this.getOutJ();
            }
        }
        if (index < 0) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void stopOutput() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(false);
        }
        this.checkNextLoad();
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
        this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
    }

    void checkNextLoad() {
        block2: {
            long calcRuntime;
            this.getOffRuntimes();
            Arrays.sort(this.rt, new RuntimeItemComparator());
            int next = this.rt[0].getOutSlot();
            this.setNextLoad(this.getStatusOutput(next).getDisplayName(null));
            this.getRuntimes();
            Arrays.sort(this.rt, new RuntimeItemComparator());
            int i = 0;
            if (i >= this.rt.length) break block2;
            int outputNum = this.rt[i].getOutSlot();
            if (outputNum == this.getLeadLoad().getEnum().getOrdinal() && (calcRuntime = this.getRuntime(outputNum) + this.getRuntimeRemainingUntilShift().getMillis()) < this.getRuntime(this.rt[i + 1].getOutSlot())) {
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)outputNum, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)));
            } else {
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)next, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)));
            }
        }
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRotateInterval(), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    void startCountdownTimer() {
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
        this.countdownTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)countdownTimerExpired, null);
    }

    void checkRunningStatus() {
        this.startedLoads = 0;
        this.runningLoads = 0;
        boolean isFailed = false;
        for (int i = 0; i < this.numOutputs; ++i) {
            BStatusBoolean out = this.getStatusOutput(i);
            boolean feedback = this.getFeedbackValue(i);
            if (out.getValue() && !feedback) {
                out.setStatusInAlarm(true);
                isFailed = true;
                ++this.startedLoads;
                continue;
            }
            if (out.getValue() && feedback) {
                out.setStatusInAlarm(false);
                ++this.startedLoads;
                ++this.runningLoads;
                continue;
            }
            out.setStatusInAlarm(false);
        }
        if (isFailed) {
            this.getLoadFailed().setValue(true);
        } else {
            this.getLoadFailed().setValue(false);
        }
        if (this.runningLoads < this.getRequiredLoads()) {
            this.getOffRuntimes();
            this.startLag(this.getRequiredLoads() - this.runningLoads);
        } else if (this.runningLoads > this.getRequiredLoads()) {
            this.getOnRuntimes();
            this.stopLag(this.runningLoads - this.getRequiredLoads());
        }
    }

    public void doDisableOutput(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        BStatusBoolean currentOut = this.getStatusOutput(outNmbr);
        currentOut.setStatusDisabled(true);
        int loadBit = this.getLoadBit(outNmbr);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | loadBit));
    }

    public void doEnableOutput(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        BStatusBoolean currentOut = this.getStatusOutput(outNmbr);
        currentOut.setStatusDisabled(false);
        int loadBit = this.getLoadBit(outNmbr);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~loadBit));
    }

    public void doManualCmd(BManualBalancerCmd manCmd) {
        int outNmbr = manCmd.getOutput().getOrdinal();
        BStatusBoolean currentOut = this.getStatusOutput(outNmbr);
        if (manCmd.getCommand()) {
            currentOut.setStatusDisabled(true);
            int loadBit = this.getLoadBit(outNmbr);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | loadBit));
        } else {
            currentOut.setStatusDisabled(false);
            int loadBit = this.getLoadBit(outNmbr);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~loadBit));
        }
    }

    private int getLoadBit(int ordinal) {
        int loadBit = -1;
        switch (ordinal) {
            case 0: {
                loadBit = 1;
                break;
            }
            case 1: {
                loadBit = 2;
                break;
            }
            case 2: {
                loadBit = 4;
                break;
            }
            case 3: {
                loadBit = 8;
                break;
            }
            case 4: {
                loadBit = 16;
                break;
            }
            case 5: {
                loadBit = 32;
                break;
            }
            case 6: {
                loadBit = 48;
                break;
            }
            case 7: {
                loadBit = 64;
                break;
            }
            case 8: {
                loadBit = 128;
                break;
            }
            case 9: {
                loadBit = 512;
            }
        }
        return loadBit;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        if (slot.getName() == "enableOutput" || slot.getName() == "disableOutput") {
            return this.getActionFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

