/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg.libavcodec;

import java.util.Hashtable;
import javax.baja.gx.Size;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.Type;
import org.baja.ffmpeg.Ffmpeg;
import org.baja.ffmpeg.FfmpegNativeStruct;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.enums.BFfmpegLogLevel;
import org.baja.ffmpeg.enums.BPixelFormatEnum;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodec;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodecContext;
import org.baja.ffmpeg.libavcodec.FfmpegAVFrame;
import org.baja.ffmpeg.libavcodec.FfmpegAVPacket;

public class FfmpegAvCodecUtil
extends Ffmpeg {
    private static Hashtable<BFrozenEnum, BInteger> bajaEnumToNativeEnumTable = new Hashtable();

    public static void setLogLevel(BFfmpegLogLevel level) {
        FfmpegAvCodecUtil.av_log_set_level(level.getOrdinal());
    }

    public static native void av_log_set_level(int var0);

    public static native void av_register_all();

    public static FfmpegAVCodecContext avcodec_alloc_context(FfmpegAVCodec ffmpegCodec) {
        if (ffmpegCodec == null) {
            throw new NullPointerException("The given ffmpegCodec cannot be null");
        }
        if (ffmpegCodec.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given ffmpegCodec.isNull() = true. Please pass a fully allocated value for the ffmpegCodec.");
        }
        long nativeHandle = FfmpegAvCodecUtil.avcodec_alloc_context0(ffmpegCodec.getNativeHandle());
        return new FfmpegAVCodecContext(nativeHandle);
    }

    public static FfmpegAVFrame avcodec_alloc_frame() {
        long nativeHandle = FfmpegAvCodecUtil.avcodec_alloc_frame0();
        return new FfmpegAVFrame(nativeHandle);
    }

    public static FfmpegAVPacket av_packet_alloc() {
        long nativeHandle = FfmpegAvCodecUtil.av_packet_alloc0();
        return new FfmpegAVPacket(nativeHandle);
    }

    public static int avcodec_decode_video(FfmpegAVCodecContext avCodecContext, FfmpegAVFrame avFrame, FfmpegAVPacket avPacket, boolean[] frameFinished, byte[] packetData, int packetSize) {
        if (avCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (avCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext");
        }
        if (avFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (avFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        if (avPacket == null) {
            throw new NullPointerException("The given avPacket cannot be null");
        }
        if (avPacket.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avPacket.isNull() = true. Please pass a fully allocated value for the avPacket");
        }
        if (packetData == null) {
            throw new NullPointerException("The given packetData cannot be null.");
        }
        if (packetData.length < packetSize) {
            throw new IllegalArgumentException("Unsafe: The length of the given packetData(" + packetData.length + ") is less than the given packetSize(" + packetSize + ").");
        }
        if (frameFinished == null) {
            throw new NullPointerException("The given frameFinished cannot be null.");
        }
        if (frameFinished.length < 1) {
            throw new IllegalArgumentException("Unsafe: The length of the given frameFinished(" + frameFinished.length + ") is less than 1.");
        }
        return FfmpegAvCodecUtil.avcodec_decode_video(avCodecContext.getNativeHandle(), avFrame.getNativeHandle(), avPacket.getNativeHandle(), frameFinished, packetData, packetSize);
    }

    public static int avcodec_encode_video(FfmpegAVCodecContext avCodecContext, byte[] bitBuffer, int bitBufferSize, FfmpegAVFrame avFrame) {
        if (avCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (avCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext");
        }
        if (bitBuffer == null) {
            throw new NullPointerException("The given bitBuffer cannot be null.");
        }
        if (bitBuffer.length < bitBufferSize) {
            throw new IllegalArgumentException("Unsafe: The length of the given bitBuffer(" + bitBuffer.length + ") is less than the given bitBufferSize(" + bitBufferSize + ").");
        }
        if (avFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (avFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        return FfmpegAvCodecUtil.avcodec_encode_video(avCodecContext.getNativeHandle(), bitBuffer, bitBufferSize, avFrame.getNativeHandle());
    }

    public static FfmpegAVCodec avcodec_find_decoder(BCodecIdEnum codecId) {
        if (codecId == null) {
            throw new NullPointerException("The given codecId cannot be null.");
        }
        int iCodecId = FfmpegAvCodecUtil.getFfmpegNativeID(codecId);
        long nativeHandle = FfmpegAvCodecUtil.avcodec_find_decoder(iCodecId);
        return new FfmpegAVCodec(nativeHandle);
    }

    public static void avcodec_close(FfmpegAVCodecContext context) {
        FfmpegAvCodecUtil.avcodec_close(context.getNativeHandle());
    }

    public static FfmpegAVCodec avcodec_find_encoder(BCodecIdEnum codecId) {
        if (codecId == null) {
            throw new NullPointerException("The given codecId cannot be null.");
        }
        int iCodecId = FfmpegAvCodecUtil.getFfmpegNativeID(codecId);
        long nativeHandle = FfmpegAvCodecUtil.avcodec_find_encoder(iCodecId);
        return new FfmpegAVCodec(nativeHandle);
    }

    public static Size avcodec_get_dimensions(FfmpegAVCodecContext codecContext) {
        if (codecContext == null) {
            throw new NullPointerException("The given codecContext cannot be null");
        }
        if (codecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given codecContext.isNull() = true. Please pass a fully allocated value for the codecContext");
        }
        int[] dimensions = new int[2];
        FfmpegAvCodecUtil.avcodec_get_dimensions(codecContext.getNativeHandle(), dimensions);
        return new Size((double)dimensions[0], (double)dimensions[1]);
    }

    public static int avcodec_open(FfmpegAVCodecContext ffmpegContext, FfmpegAVCodec ffmpegCodec) {
        if (ffmpegContext == null) {
            throw new NullPointerException("The given ffmpegContext cannot be null");
        }
        if (ffmpegContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given ffmpegContext.isNull() = true. Please pass a fully allocated value for the ffmpegContext.");
        }
        if (ffmpegCodec == null) {
            throw new NullPointerException("The given ffmpegCodec cannot be null");
        }
        if (ffmpegCodec.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given ffmpegCodec.isNull() = true. Please pass a fully allocated value for the ffmpegCodec.");
        }
        return FfmpegAvCodecUtil.avcodec_open(ffmpegContext.getNativeHandle(), ffmpegCodec.getNativeHandle());
    }

    public static void avcodec_set_dimensions(FfmpegAVCodecContext avCodecContext, int width, int height) {
        if (avCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (avCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext.");
        }
        FfmpegAvCodecUtil.avcodec_set_dimensions(avCodecContext.getNativeHandle(), width, height);
    }

    public static void av_free(FfmpegNativeStruct ffmpegStructObj) {
        if (ffmpegStructObj != null && !ffmpegStructObj.isNull()) {
            FfmpegAvCodecUtil.av_free(ffmpegStructObj.getNativeHandle());
            ffmpegStructObj.setNativeHandle(0L);
        }
    }

    public static int avpicture_get_size(BPixelFormatEnum pixelFormat, int width, int height) {
        int iFmtId = FfmpegAvCodecUtil.getFfmpegNativeID(pixelFormat);
        return FfmpegAvCodecUtil.avpicture_get_size(iFmtId, width, height);
    }

    public static int computePpmLength(int width, int height) {
        String ppmHeader = "P6\n" + width + " " + height + "\n255\n";
        int ppmHeaderLen = ppmHeader.length();
        int ppmBodyLen = width * 3 * height;
        int ppmLen = ppmBodyLen + ppmHeaderLen;
        return ppmLen;
    }

    public static int[] getPixels(FfmpegAVFrame avFrame, int width, int height, int[] pixelBuffer) {
        if (avFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (avFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        if (pixelBuffer == null) {
            pixelBuffer = new int[width * height];
        }
        FfmpegAvCodecUtil.getPixels(avFrame.getNativeHandle(), width, height, pixelBuffer);
        return pixelBuffer;
    }

    private static native void getPixels(long var0, int var2, int var3, int[] var4);

    public static byte[] convertRgbFrameToPpm(FfmpegAVFrame avRgbFrame, int width, int height, byte[] ppmBytes) {
        if (avRgbFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (avRgbFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        if (ppmBytes == null) {
            int ppmLen = FfmpegAvCodecUtil.computePpmLength(width, height);
            ppmBytes = new byte[ppmLen];
        }
        FfmpegAvCodecUtil.convertRgbFrameToPpm(avRgbFrame.getNativeHandle(), width, height, ppmBytes);
        return ppmBytes;
    }

    public static FfmpegAVFrame allocateAndInitFormattedFrame(int width, int height, BPixelFormatEnum pixFmt) {
        return new FfmpegAVFrame(FfmpegAvCodecUtil.allocateAndInitFormattedFrame(width, height, FfmpegAvCodecUtil.getFfmpegNativeID(pixFmt)));
    }

    private static native long allocateAndInitFormattedFrame(int var0, int var1, int var2);

    private static native void convertRgbFrameToPpm(long var0, int var2, int var3, byte[] var4);

    public static int getFfmpegNativeID(BCodecIdEnum codecId) {
        if (codecId == null) {
            throw new NullPointerException("The given codecId cannot be null.");
        }
        return FfmpegAvCodecUtil.getFfmpegNativeID0((BFrozenEnum)codecId);
    }

    public static int getFfmpegNativeID(BPixelFormatEnum pixelFormatEnum) {
        if (pixelFormatEnum == null) {
            throw new NullPointerException("The given pixelFormatEnum cannot be null.");
        }
        return FfmpegAvCodecUtil.getFfmpegNativeID0((BFrozenEnum)pixelFormatEnum);
    }

    private static int getFfmpegNativeID0(BFrozenEnum frozenEnum) {
        BInteger biNativeId = bajaEnumToNativeEnumTable.get(frozenEnum);
        if (biNativeId == null) {
            throw new IllegalArgumentException("Native enum id not found for Baja Ffmpeg Enum: " + frozenEnum);
        }
        return biNativeId.getInt();
    }

    public static void ffmpegSetEndodeOptions(FfmpegAVCodecContext avCodecContext, BPixelFormatEnum pixFmt, int timeBaseNum, int timeBaseDen) {
        if (avCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (avCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext.");
        }
        FfmpegAvCodecUtil.ffmpegSetEndodeOptions(avCodecContext.getNativeHandle(), FfmpegAvCodecUtil.getFfmpegNativeID(pixFmt), timeBaseNum, timeBaseDen);
    }

    private static native void ffmpegSetEndodeOptions(long var0, int var2, int var3, int var4);

    private static native void avcodec_get_dimensions(long var0, int[] var2);

    private static native int avpicture_get_size(int var0, int var1, int var2);

    private static native int getFfmpegCodecID0(String var0);

    private static native int getFfmpegPixelFormat0(String var0);

    private static native void avcodec_set_dimensions(long var0, int var2, int var3);

    private static synchronized native long avcodec_alloc_context0(long var0);

    public static synchronized native long avcodec_alloc_frame0();

    public static synchronized native long av_packet_alloc0();

    private static native long avcodec_find_decoder(int var0);

    private static native long avcodec_find_encoder(int var0);

    private static synchronized native int avcodec_open(long var0, long var2);

    private static synchronized native int avcodec_close(long var0);

    private static native void av_free(long var0);

    public static native void av_packet_free(long var0);

    private static native int avcodec_decode_video(long var0, long var2, long var4, boolean[] var6, byte[] var7, int var8);

    private static native int avcodec_encode_video(long var0, byte[] var2, int var3, long var4);

    private static void loadNativeIds(Type typeFromOrgBajaFfmpegEnums) {
        BFrozenEnum fromOrgBajaFfmpegEnums = (BFrozenEnum)typeFromOrgBajaFfmpegEnums.getInstance();
        BEnumRange orgBajaFfmpegEnumRage = fromOrgBajaFfmpegEnums.getRange();
        int[] ordinals = orgBajaFfmpegEnumRage.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ffmpegNativeId;
            int ordinal = ordinals[i];
            String tag = orgBajaFfmpegEnumRage.getTag(ordinal);
            String nativeTag = tag.substring(7);
            if (typeFromOrgBajaFfmpegEnums == BCodecIdEnum.TYPE) {
                ffmpegNativeId = FfmpegAvCodecUtil.getFfmpegCodecID0(nativeTag);
            } else if (typeFromOrgBajaFfmpegEnums == BPixelFormatEnum.TYPE) {
                ffmpegNativeId = FfmpegAvCodecUtil.getFfmpegPixelFormat0(nativeTag);
            } else {
                throw new IllegalArgumentException("Unrecognized org.baja.ffmpeg.enums TYPE: " + typeFromOrgBajaFfmpegEnums.getDisplayName(null));
            }
            BFrozenEnum orgBajaFfmpegEnum = (BFrozenEnum)orgBajaFfmpegEnumRage.get(tag);
            bajaEnumToNativeEnumTable.put(orgBajaFfmpegEnum, BInteger.make((int)ffmpegNativeId));
        }
    }

    static {
        FfmpegAvCodecUtil.loadNativeIds(BCodecIdEnum.TYPE);
        FfmpegAvCodecUtil.loadNativeIds(BPixelFormatEnum.TYPE);
    }
}

