/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg;

import com.tridium.nre.platform.OperatingSystemEnum;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Sys;
import org.baja.ffmpeg.DynamicLoadException;

public class ClientSideNativeLibraryLoader {
    protected static Logger log = Logger.getLogger("ffmpeg.load");
    protected static String bajaBinDirStr;
    protected static File bajaBinDir;
    static boolean nativesLoaded;
    private static final String AVUTIL_VERSION = "58";
    private static final String SWRESAMPLE_VERSION = "4";
    private static final String AVCODEC_VERSION = "60";
    private static final String AVFORMAT_VERSION = "60";
    private static final String SWSCALE_VERSION = "7";
    public static final long NULL = 0L;

    protected static void findNreBin() {
        File bajaHome = Sys.getNiagaraHome();
        bajaBinDir = new File(bajaHome, "bin");
        bajaBinDir.mkdir();
        bajaBinDirStr = bajaBinDir.getAbsolutePath();
    }

    protected static Boolean loadLibraryFromThisModule(final String libName) {
        if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
            log.warning("Unsupported OS, skipping library load");
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Extracting:> " + libName);
                }
                String absLibPath = ClientSideNativeLibraryLoader.extractLibraryFromThisModule(libName);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("JNI Loading:> " + libName);
                }
                try {
                    System.loadLibrary(libName.substring(0, libName.indexOf(".dll")));
                    nativesLoaded = true;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Could not load the third party dlls... : " + libName + " to client.", e);
                }
                return nativesLoaded;
            }
        });
    }

    protected static String extractLibraryFromThisModule(String libName) {
        return ClientSideNativeLibraryLoader.extractLibraryFromThisModule(bajaBinDir, libName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String extractLibraryFromThisModule(File destDir, String libName) {
        String string;
        String nativeLibPath = "module://ffmpeg/nativeLib/x86_64/" + libName;
        BOrd libraryOrdInNiagaraModule = BOrd.make((String)nativeLibPath);
        BIFile libraryFileInJar = (BIFile)libraryOrdInNiagaraModule.get();
        File libraryDest = new File(destDir, libName);
        if (libraryDest.exists()) {
            try {
                FileUtil.delete((File)libraryDest);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not delete the existing third party libraries " + libName + " to client.", e);
            }
        }
        InputStream libraryBytesInJar = libraryFileInJar.getInputStream();
        FileOutputStream libraryDestOut = new FileOutputStream(libraryDest);
        byte[] buf = new byte[40960];
        try {
            while (true) {
                int n = libraryBytesInJar.read(buf);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("40K.");
                }
                if (n == -1) break;
                libraryDestOut.write(buf, 0, n);
            }
            string = libraryDest.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                libraryDestOut.flush();
                libraryDestOut.close();
                libraryBytesInJar.close();
                throw throwable;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "IO exception occurred while transferring " + libName + " to client.", e);
                throw new DynamicLoadException("IO exception occurred while transferring " + libName + " to client.", e);
            }
        }
        libraryDestOut.flush();
        libraryDestOut.close();
        libraryBytesInJar.close();
        return string;
    }

    static {
        nativesLoaded = false;
        ClientSideNativeLibraryLoader.findNreBin();
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avutil-58.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("swresample-4.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avcodec-60.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avformat-60.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("swscale-7.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("ffmpeg-wrapper.dll");
    }
}

