/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.BOnCallRecipient;
import com.tridium.oncall.BOnCallSchedule;
import com.tridium.oncall.util.BOnCallWorker;
import com.tridium.oncall.util.ReportUtil;
import java.util.ListIterator;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserService;
import javax.baja.util.BIRestrictedComponent;

public final class BOnCallService
extends BAbstractService
implements BIRestrictedComponent {
    public static final Property worker = BOnCallService.newProperty((int)4, (BValue)new BOnCallWorker(), null);
    public static final Property auditAlarmEscalation = BOnCallService.newProperty((int)0, (boolean)false, null);
    public static final Property onCallListOrdinalCount = BOnCallService.newProperty((int)69, (int)0, null);
    public static final Action userEvent = BOnCallService.newAction((int)4, (BValue)new BUserEvent(), null);
    public static final Action createUserReport = BOnCallService.newAction((int)2308, (BValue)new BComponent(), null);
    public static final Type TYPE = Sys.loadType(BOnCallService.class);
    private static final BIcon icon = BIcon.make((String)"module://onCall/res/onCallService.png");
    private static BOnCallService INSTANCE = null;
    private Object newOrdinalMonitor = new Object();
    private Array<BOnCallRecipient> recipients = new Array(BOnCallRecipient.class);
    private Array<UserListener> userListenerArray = new Array(UserListener.class);

    public BOnCallWorker getWorker() {
        return (BOnCallWorker)this.get(worker);
    }

    public void setWorker(BOnCallWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public boolean getAuditAlarmEscalation() {
        return this.getBoolean(auditAlarmEscalation);
    }

    public void setAuditAlarmEscalation(boolean v) {
        this.setBoolean(auditAlarmEscalation, v, null);
    }

    public int getOnCallListOrdinalCount() {
        return this.getInt(onCallListOrdinalCount);
    }

    public void setOnCallListOrdinalCount(int v) {
        this.setInt(onCallListOrdinalCount, v, null);
    }

    public void userEvent(BUserEvent event) {
        this.invoke(userEvent, (BValue)event, null);
    }

    public BComponent createUserReport(BComponent info) {
        return (BComponent)this.invoke(createUserReport, (BValue)info, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOnCallService() {
        this.setFlags((Slot)enabled, 4);
    }

    public void serviceStarted() throws Exception {
        INSTANCE = this;
        BUserService userSrv = (BUserService)Sys.getService((Type)BUserService.TYPE);
        this.linkTo((BComponent)userSrv, (Slot)BUserService.userEvent, (Slot)userEvent);
    }

    public void serviceStopped() throws Exception {
        INSTANCE = null;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public BIcon getIcon() {
        return icon;
    }

    public void renamed(Property property, String oldName, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallList.TYPE)) {
            this.callListUpdateFacetsOnAllSchedules(this.getCallListEnumRangeFacets());
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning() && oldValue instanceof BOnCallList) {
            BOnCallList tempList = (BOnCallList)oldValue;
            this.callListRemovedOnAllSchedules(BInteger.make((int)tempList.getOrdinal()));
        }
    }

    public static BOnCallService getInstance() {
        return INSTANCE;
    }

    public BOnCallList[] getLists() {
        return (BOnCallList[])this.getChildren(BOnCallList.class);
    }

    public BOnCallList lookupList(int ordinal) {
        BOnCallList[] lists = (BOnCallList[])this.getChildren(BOnCallList.class);
        for (int i = 0; i < lists.length; ++i) {
            if (lists[i].getOrdinal() != ordinal) continue;
            return lists[i];
        }
        return null;
    }

    public BFacets getCallListEnumRangeFacets() {
        BOnCallList[] lists = this.getLists();
        int[] ordinals = new int[lists.length];
        String[] tags = new String[lists.length];
        for (int i = 0; i < lists.length; ++i) {
            ordinals[i] = lists[i].getOrdinal();
            tags[i] = lists[i].getName();
        }
        return BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])ordinals, (String[])tags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getNewOrdinalNumber() {
        int num = 0;
        Object object = this.newOrdinalMonitor;
        synchronized (object) {
            num = this.getOnCallListOrdinalCount();
            this.setOnCallListOrdinalCount(++num);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUserEvent(final BUserEvent event) {
        if (event.getId() == 1) {
            this.getWorker().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String userName = event.getUserName();
                    Array array = BOnCallService.this.userListenerArray;
                    synchronized (array) {
                        ListIterator it = BOnCallService.this.userListenerArray.iterator();
                        while (it.hasNext()) {
                            ((UserListener)it.next()).userRemoved(userName);
                        }
                    }
                }
            });
        } else if (event.getId() == 2) {
            String userName = event.getUserName();
            Array<UserListener> array = this.userListenerArray;
            synchronized (array) {
                ListIterator it = this.userListenerArray.iterator();
                while (it.hasNext()) {
                    ((UserListener)it.next()).userEnabledChanged(userName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUserListener(UserListener listener) {
        Array<UserListener> array = this.userListenerArray;
        synchronized (array) {
            this.userListenerArray.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUserListener(UserListener listener) {
        Array<UserListener> array = this.userListenerArray;
        synchronized (array) {
            this.userListenerArray.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOnCallRecipient[] getOnCallRecipients() {
        Array<BOnCallRecipient> array = this.recipients;
        synchronized (array) {
            return (BOnCallRecipient[])this.recipients.copy().array();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOnCallRecipient(BOnCallRecipient r) {
        Array<BOnCallRecipient> array = this.recipients;
        synchronized (array) {
            this.recipients.add((Object)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOnCallRecipient(BOnCallRecipient r) {
        Array<BOnCallRecipient> array = this.recipients;
        synchronized (array) {
            this.recipients.remove((Object)r);
        }
    }

    void callListUpdateFacetsOnAllSchedules(BFacets f) {
        BOnCallRecipient[] recs = this.getOnCallRecipients();
        for (int i = 0; i < recs.length; ++i) {
            recs[i].getOnCallListSchedule().setFacets(f);
        }
    }

    void callListRemovedOnAllSchedules(BInteger ordinal) {
        BOnCallRecipient[] recs = this.getOnCallRecipients();
        for (int i = 0; i < recs.length; ++i) {
            recs[i].getOnCallListSchedule().callListRemoved(ordinal);
        }
    }

    void callListMatchClearAndEscalate(BString onCallListName) {
        BOnCallRecipient[] recs = this.getOnCallRecipients();
        for (int i = 0; i < recs.length; ++i) {
            recs[i].getOnCallListSchedule().matchClearAndEscalate(onCallListName);
        }
    }

    boolean isScheduleActiveElseWhere(BOnCallSchedule currentSch, BStatusEnum lastOut) {
        boolean active = false;
        BOnCallRecipient[] recs = this.getOnCallRecipients();
        int ordi = lastOut.getEnum().getOrdinal();
        for (int i = 0; i < recs.length; ++i) {
            BOnCallSchedule sch = recs[i].getOnCallListSchedule();
            if (sch.equals((Object)currentSch) || sch.getOut().getValue().getOrdinal() != ordi) continue;
            active = true;
            break;
        }
        return active;
    }

    public BComponent doCreateUserReport(BComponent info, Context cx) throws Exception {
        return ReportUtil.createUserReport(info, cx);
    }

    static interface UserListener {
        public void userRemoved(String var1);

        public void userEnabledChanged(String var1);
    }
}

