/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth.ui;

import com.tridium.gauth.BGoogleAuthCredentials;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.shell.BGeneralOptions;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.util.Lexicon;
import javax.baja.workbench.authn.BCredInputPane;

@NiagaraType
@NiagaraAction(name="changeUser", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public class BWbLoginGoogleAuthCredentialsPane
extends BCredInputPane {
    public static final Action changeUser = BWbLoginGoogleAuthCredentialsPane.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BWbLoginGoogleAuthCredentialsPane.class);
    private static Lexicon lex = Lexicon.make((String)"gauth");
    private BTextField usernameFE = new BTextField();
    private BHyperlinkLabel changeUserHyperlink = new BHyperlinkLabel();
    private BPasswordFE passwordFE = new BPasswordFE();
    BTextField tokenFE = new BTextField();
    private BCheckBox saveCredBox;
    boolean newUser;

    public void changeUser(BMouseEvent parameter) {
        this.invoke(changeUser, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWbLoginGoogleAuthCredentialsPane(BGoogleAuthCredentials credentials, AuthenticationRealm realm, String realmPrefix) {
        this.newUser = credentials.isNewUser();
        UiLexicon uiLex = UiLexicon.bajaui();
        BGridPane credPane = new BGridPane(2);
        credPane.setHalign(BHalign.left);
        credPane.setColumnGap(20.0);
        credPane.add(null, (BValue)new BLabel(uiLex.getText("auth.username")));
        credPane.add(null, (BValue)this.usernameFE);
        this.usernameFE.setText(credentials.getUsername());
        this.usernameFE.setEnabled(false);
        credPane.add(null, (BValue)new BLabel());
        credPane.add(null, (BValue)this.changeUserHyperlink);
        this.initChangeUserHyperlink();
        credPane.add(null, (BValue)new BLabel(uiLex.getText("auth.password")));
        credPane.add(null, (BValue)this.passwordFE);
        this.passwordFE.loadValue((BObject)credentials.getPassword());
        credPane.add(null, (BValue)new BLabel(lex.getText("auth.token")));
        credPane.add(null, (BValue)this.tokenFE);
        this.add(null, (BValue)credPane);
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        this.saveCredBox = new BCheckBox(uiLex.getText("auth.saveCredentials"), allowCaching && AuthUtil.hasSavedCredentials((String)(realmPrefix + realm.getAuthenticationRealmName())));
        this.saveCredBox.setEnabled(allowCaching);
        this.add(null, (BValue)this.saveCredBox);
    }

    private void initChangeUserHyperlink() {
        BFont font = this.changeUserHyperlink.getFont();
        font = font.isNull() ? BFont.make((BFont)Theme.label().getTextFont((IStylable)this.changeUserHyperlink), (int)4) : BFont.make((BFont)font, (int)4);
        this.changeUserHyperlink.setForeground(BBrush.makeSolid((BColor)BColor.blue));
        this.changeUserHyperlink.setFont(font);
        this.changeUserHyperlink.setText(lex.getText("auth.changeUser"));
        this.changeUserHyperlink.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)3.0));
        this.linkTo((BComponent)this.changeUserHyperlink, (Slot)BWidget.mouseEvent, (Slot)changeUser);
    }

    public void doChangeUser(BMouseEvent event) {
        if (event.getId() == 502) {
            BWbLoginGoogleAuthCredentialsPane parent = this;
            while (!((parent = parent.getParentWidget()) instanceof BOptionDialog) && !(parent instanceof BWizard) && parent != null) {
            }
            if (parent instanceof BOptionDialog) {
                ((BOptionDialog)parent).close(1000);
            } else if (parent instanceof BWizard) {
                ((BWizard)parent).getModel().back();
            }
        }
    }

    protected BICredentials doGetCredentials() throws Exception {
        String username = this.usernameFE.getText();
        BPassword password = (BPassword)this.passwordFE.saveValue();
        String token = this.tokenFE.getText();
        BGoogleAuthCredentials credentials = new BGoogleAuthCredentials(username, password);
        credentials.setToken(token);
        return credentials;
    }

    protected void doCleanCredentials() {
        this.usernameFE.setText("");
        this.passwordFE.loadValue((BObject)BPassword.make((String)""));
        this.tokenFE.setText("");
        this.usernameFE = null;
        this.passwordFE = null;
        this.tokenFE = null;
    }

    public boolean shouldSaveCredentials() {
        return this.saveCredBox.isSelected();
    }

    public boolean shouldDeleteCredentials() {
        return !this.saveCredBox.isSelected();
    }
}

