/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.util;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;

public final class WebProperty {
    public static final int webPropertySlotFlag = 0x40000000;
    private static final Logger log = Logger.getLogger("bajaui");
    public static final String nameAttr = "name";
    public static final String hiddenAttr = "hidden";
    public static final String readonlyAttr = "readonly";
    public static final String transientAttr = "transient";
    public static final String typeSpecAttr = "typeSpec";
    public static final String valueAttr = "value";
    public static final String metadataAttr = "metadata";
    private final String name;
    private final String typeSpec;
    private final String encValue;
    private final boolean hidden;
    private final boolean readonly;
    private final boolean trans;
    private final Object metadata;
    private BValue value;
    private TypeInfo info;

    public WebProperty(String name, boolean hidden, boolean readonly, boolean trans, String typeSpec, String encValue, Object metadata) {
        this.name = name;
        this.hidden = hidden;
        this.readonly = readonly;
        this.trans = trans;
        this.typeSpec = typeSpec.length() == 0 ? "baja:String" : typeSpec;
        this.encValue = encValue;
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getTypeInfo() {
        if (this.info == null) {
            this.info = Sys.getRegistry().getType(this.typeSpec);
        }
        return this.info;
    }

    public BValue getValue() throws IOException {
        if (this.value == null) {
            this.value = WebProperty.decodeValue(this.encValue, this.getTypeInfo());
        }
        return this.value;
    }

    public int getFlags() {
        int flags = 0x40000000;
        if (this.isHidden()) {
            flags |= 4;
        }
        if (this.isReadonly()) {
            flags |= 1;
        }
        if (this.isTransient()) {
            flags |= 2;
        }
        return flags;
    }

    public BFacets getFacets() {
        return WebProperty.decodeMetadata(this.metadata);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isTransient() {
        return this.trans;
    }

    public static Map<String, Object> sync(BWidget widget, Iterable<WebProperty> webProps) {
        return WebProperty.sync(widget, webProps, false);
    }

    public static Map<String, Object> sync(BWidget widget, Iterable<WebProperty> webProps, boolean legacyJSONStructure) {
        Property[] nprops;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Property p : nprops = widget.getPropertiesArray()) {
            if (!p.isDynamic() || !WebProperty.isWebProperty((BComplex)widget, p) || widget.isOverriddenByBinding(p)) continue;
            toRemove.add(p.getName());
        }
        Map<String, Object> resp = null;
        for (WebProperty wp : webProps) {
            try {
                String name = SlotPath.escape((String)wp.getName());
                toRemove.remove(name);
                int flags = wp.getFlags();
                BFacets facets = wp.getFacets();
                Property p = widget.getProperty(name);
                if (p == null) {
                    p = widget.add(SlotPath.escape((String)name), wp.getValue(), flags, facets, null);
                    resp = WebProperty.addToResp(resp, widget, p, legacyJSONStructure);
                    continue;
                }
                if (!widget.get(p).isSimple()) continue;
                if (widget.getFlags((Slot)p) != flags) {
                    widget.setFlags((Slot)p, flags);
                }
                if (!widget.getSlotFacets((Slot)p).equals((Object)facets)) {
                    widget.setFacets((Slot)p, facets);
                }
                resp = WebProperty.addToResp(resp, widget, p, legacyJSONStructure);
            }
            catch (IOException ex) {
                Logger.getLogger("webWidget").log(Level.SEVERE, "Could not load Web Property", ex);
            }
        }
        toRemove.forEach(arg_0 -> ((BWidget)widget).remove(arg_0));
        return resp == null ? Collections.emptyMap() : resp;
    }

    private static Map<String, Object> addToResp(Map<String, Object> resp, BWidget widget, Property prop, boolean legacyJSONStructure) throws IOException {
        if (resp == null) {
            resp = new HashMap<String, Object>();
        }
        if (legacyJSONStructure) {
            resp.put(SlotPath.unescape((String)prop.getName()), WebProperty.encodeValue(widget.get(prop)));
        } else {
            resp.put(SlotPath.unescape((String)prop.getName()), WebProperty.encodeProperty(widget, prop));
        }
        return resp;
    }

    public static Property setProperty(BWidget widget, String name, String value) {
        Property prop = widget.getProperty(SlotPath.escape((String)name));
        if (prop == null) {
            return null;
        }
        if (!WebProperty.isWebProperty((BComplex)widget, prop)) {
            return null;
        }
        if (widget.isOverriddenByBinding(prop)) {
            return prop;
        }
        try {
            BValue val = WebProperty.decodeValue(value, widget.get(prop).getType().getTypeInfo());
            if (!widget.get(prop).equivalent((Object)val)) {
                widget.set(prop, val);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return prop;
    }

    public static Property setFacets(BWidget widget, String name, Object metadata) {
        Property prop = widget.getProperty(SlotPath.escape((String)name));
        if (prop == null) {
            return null;
        }
        if (!WebProperty.isWebProperty((BComplex)widget, prop)) {
            return null;
        }
        if (widget.isOverriddenByBinding(prop)) {
            return prop;
        }
        BFacets facets = WebProperty.decodeMetadata(metadata);
        if (!widget.getSlotFacets((Slot)prop).equals((Object)facets)) {
            widget.setFacets((Slot)prop, facets);
        }
        return prop;
    }

    public static Map<String, Object> getPropertyChanges(BWidget widget) throws IOException {
        return WebProperty.getPropertyChanges(widget, false);
    }

    public static Map<String, Object> getPropertyChanges(BWidget widget, boolean legacyJSONStructure) throws IOException {
        try {
            return Arrays.stream(widget.getPropertiesArray()).filter(prop -> WebProperty.isWebProperty((BComplex)widget, prop)).collect(Collectors.toMap(prop -> SlotPath.unescape((String)prop.getName()), prop -> {
                try {
                    if (legacyJSONStructure) {
                        return WebProperty.encodeValue(widget.get((Property)prop));
                    }
                    return WebProperty.encodeProperty(widget, prop);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof IOException) {
                throw (IOException)t;
            }
            throw e;
        }
    }

    public static BValue decodeValue(String encValue, TypeInfo typeInfo) throws IOException {
        if (typeInfo.is(BEnum.TYPE)) {
            BEnum enm = (BEnum)typeInfo.getInstance();
            return enm.getRange().get(encValue);
        }
        return (BValue)typeInfo.getInstance().asSimple().decodeFromString(encValue);
    }

    public static JSONObject encodeProperty(BWidget w, Property prop) throws IOException {
        JSONObject encoding = new JSONObject();
        BFacets facets = w.getSlotFacets((Slot)prop);
        encoding.put(valueAttr, WebProperty.encodeValue(w.get(prop)));
        if (!facets.isEmpty()) {
            encoding.put(metadataAttr, (Object)WebProperty.encodeFacets(facets));
        }
        return encoding;
    }

    public static Object encodeValue(BValue value) throws IOException {
        if (value instanceof BInteger) {
            return ((BNumber)value).getInt();
        }
        if (value instanceof BLong) {
            return ((BNumber)value).getLong();
        }
        if (value instanceof BFloat) {
            return Float.valueOf(((BNumber)value).getFloat());
        }
        if (value instanceof BDouble) {
            return ((BNumber)value).getDouble();
        }
        if (value instanceof BBoolean) {
            return ((BBoolean)value).getBoolean();
        }
        if (value instanceof BEnum) {
            return ((BEnum)value).getTag();
        }
        return value.asSimple().encodeToString();
    }

    public static JSONObject encodeFacets(BFacets facets) {
        JSONObject metadata = new JSONObject();
        Stream.of(facets.list()).forEach(key -> {
            try {
                BValue value = facets.get(key).asValue();
                String typeSpec = value.getType().getTypeSpec().encodeToString();
                JSONObject metaObj = new JSONObject();
                metaObj.put(typeSpecAttr, (Object)typeSpec).put(valueAttr, WebProperty.encodeValue(value));
                metadata.put(key, (Object)metaObj);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error encoding facets", e);
            }
        });
        return metadata;
    }

    public static BFacets decodeMetadata(Object metadata) {
        BFacets facets = BFacets.DEFAULT;
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        if (metadata instanceof JSONObject) {
            JSONObject md = (JSONObject)metadata;
            md.keys().forEachRemaining(key -> {
                String name = key.toString();
                JSONObject valueObj = md.getJSONObject(name);
                String typeSpec = JSONUtil.getString((JSONObject)valueObj, (String)typeSpecAttr);
                String encValue = JSONUtil.getString((JSONObject)valueObj, (String)valueAttr);
                try {
                    BValue value = WebProperty.decodeValue(encValue, Sys.getRegistry().getType(typeSpec));
                    if (value instanceof BIDataValue) {
                        keys.add(name);
                        values.add((BIDataValue)value);
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error decoding metadata", e);
                }
            });
            facets = BFacets.make((String[])keys.toArray(new String[0]), (BIDataValue[])values.toArray(new BIDataValue[0]));
        }
        return facets;
    }

    public static boolean isWebProperty(BComplex clx, Property prop) {
        return (clx.getFlags((Slot)prop) & 0x40000000) != 0 && clx.get(prop).isSimple();
    }
}

