/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.util;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.BAuxWidget;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
@NiagaraProperty(name="typeName", type="baja:String", defaultValue="BString.make(UiLexicon.bajaui().getText(\"titlePane.objects\"))")
@NiagaraActions(value={@NiagaraAction(name="expansionChanged"), @NiagaraAction(name="tableModified")})
public class BTitlePane
extends BEdgePane {
    public static final Property typeName = BTitlePane.newProperty((int)0, (BValue)BString.make((String)UiLexicon.bajaui().getText("titlePane.objects")), null);
    public static final Action expansionChanged = BTitlePane.newAction((int)0, null);
    public static final Action tableModified = BTitlePane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTitlePane.class);
    static final BInsets withIcon = BInsets.make((double)1.0, (double)4.0, (double)1.0, (double)2.0);
    static final BInsets withoutIcon = BInsets.make((double)2.0, (double)4.0, (double)2.0, (double)4.0);

    public String getTypeName() {
        return this.getString(typeName);
    }

    public void setTypeName(String v) {
        this.setString(typeName, v, null);
    }

    public void expansionChanged() {
        this.invoke(expansionChanged, null, null);
    }

    public void tableModified() {
        this.invoke(tableModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BTitlePane makePane(String title, BTable table) {
        BTitlePane pane = new BTitlePane(title, table);
        pane.setTable(table);
        return pane;
    }

    public static BTitlePane makePane(String title, BTable table, String typeName) {
        BTitlePane pane = new BTitlePane(title, table);
        pane.setTypeName(typeName);
        pane.setTable(table);
        return pane;
    }

    public BTitlePane(String title, BWidget content) {
        BLabel label = new BLabel(title);
        BEdgePane top = new BEdgePane();
        top.setLeft(label);
        BBorderPane topBorder = new BBorderPane((BWidget)top, BBorder.none, withoutIcon);
        topBorder.setStyleClasses("title");
        topBorder.setFill(Theme.titlePane().getControlBackground(topBorder));
        label.setFont(Theme.titlePane().getTextFont(topBorder));
        label.setForeground(Theme.titlePane().getTextBrush(topBorder));
        label.setBackground(Theme.titlePane().getControlBackground());
        label.setPadding(BInsets.make((double)3.0, (double)3.0, (double)3.0, (double)0.0));
        BEdgePane edge = new BEdgePane();
        edge.setTop(topBorder);
        edge.setCenter(content);
        this.setCenter(edge);
    }

    public BTitlePane() {
    }

    private boolean topIsEdge() {
        return this.getTopContent() instanceof BEdgePane;
    }

    private BEdgePane topAsEdge() {
        return (BEdgePane)this.getTopContent();
    }

    private boolean centerIsEdge() {
        return this.getCenter() instanceof BEdgePane;
    }

    private BEdgePane centerAsEdge() {
        return (BEdgePane)this.getCenter();
    }

    public BWidget getContent() {
        if (this.centerIsEdge()) {
            return this.centerAsEdge().getCenter();
        }
        return null;
    }

    public BWidget getInfo() {
        if (this.topIsEdge()) {
            return this.topAsEdge().getRight();
        }
        return null;
    }

    public void setInfo(BLabel newInfo) {
        if (this.topIsEdge()) {
            this.topAsEdge().setRight(newInfo);
        }
    }

    public BWidget getLabel() {
        if (this.topIsEdge()) {
            return this.topAsEdge().getLeft();
        }
        return null;
    }

    public BWidget getTopContent() {
        return this.getTopBorder().getContent();
    }

    public BBorderPane getTopBorder() {
        return (BBorderPane)((BEdgePane)this.getCenter()).getTop();
    }

    public BTable getTable() {
        if (this.centerIsEdge()) {
            return (BTable)this.centerAsEdge().getCenter();
        }
        return null;
    }

    public String getTitle() {
        if (this.getLabel() instanceof BLabel) {
            return ((BLabel)this.getLabel()).getText();
        }
        return "";
    }

    public void setTitle(String title) {
        if (this.getLabel() instanceof BLabel) {
            ((BLabel)this.getLabel()).setText(title);
        }
    }

    public void setCount(int count) {
        if (this.topIsEdge()) {
            BEdgePane edgePane = this.topAsEdge();
            if (this.getInfo() == null || this.getInfo() instanceof BNullWidget) {
                this.setInfo(new BLabel(""));
                BLabel info = (BLabel)this.getInfo();
                info.setFont(BFont.make((BFont)Theme.titlePane().getTextFont(this.getTopBorder()), (double)13.5));
                info.setForeground(Theme.titlePane().getTextBrush(this.getTopBorder()));
                edgePane.setRight(this.getInfo());
            }
            if (this.getInfo() instanceof BLabel) {
                ((BLabel)this.getInfo()).setText(count + " " + this.getTypeName());
            }
        }
    }

    public void setTable(BTable table) {
        if (this.centerIsEdge()) {
            this.centerAsEdge().setCenter(table);
            if (this.get("tableLink") != null) {
                this.remove("tableLink");
            }
            this.linkTo("tableLink", table, (Slot)BTable.tableModified, (Slot)tableModified);
            this.doTableModified();
        }
    }

    public void setExpandable(boolean expandable) {
        if (this.topIsEdge()) {
            BEdgePane top = this.topAsEdge();
            if (expandable) {
                top.setLeft(new BNullWidget());
                BGridPane grid = new BGridPane(2);
                grid.add(null, (BValue)new BAuxWidget(new AuxSupport()));
                grid.add(null, (BValue)this.getLabel());
                top.setLeft(grid);
                ((BBorderPane)top.getParent()).setPadding(withIcon);
            } else {
                BWidget p = this.getLabel().getParentWidget();
                if (p != null) {
                    p.remove(this.getLabel().getPropertyInParent());
                }
                top.setLeft(this.getLabel());
                ((BBorderPane)top.getParent()).setPadding(withoutIcon);
            }
        }
    }

    public boolean getExpanded() {
        return this.getContent().isVisible();
    }

    public void setExpanded(boolean b) {
        this.getContent().setVisible(b);
        this.relayout();
        this.expansionChanged();
    }

    public void doTableModified() {
        if (this.getContent() instanceof BTable) {
            int count = 0;
            try {
                count = this.getTable().getModel().getRowCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setCount(count);
            this.relayout();
        }
    }

    public void doExpansionChanged() {
    }

    class AuxSupport
    extends BAuxWidget.Support {
        final BSize size = BSize.make((double)10.0, (double)16.0);

        AuxSupport() {
        }

        @Override
        public BSize getPreferredSize() {
            return this.size;
        }

        @Override
        public void paint(Graphics g, double w, double h) {
            g.setBrush(BColor.white);
            double x = 2.0;
            double y = 5.0;
            if (BTitlePane.this.getContent().isVisible()) {
                g.strokeLine(x, y + 2.0, x + 2.0, y);
                g.strokeLine(x + 2.0, y, x + 4.0, y + 2.0);
                g.strokeLine(x + 1.0, y + 2.0, x + 2.0, y + 1.0);
                g.strokeLine(x + 2.0, y + 1.0, x + 3.0, y + 2.0);
                g.strokeLine(x, y + 6.0, x + 2.0, y + 4.0);
                g.strokeLine(x + 2.0, y + 4.0, x + 4.0, y + 6.0);
                g.strokeLine(x + 1.0, y + 6.0, x + 2.0, y + 5.0);
                g.strokeLine(x + 2.0, y + 5.0, x + 3.0, y + 6.0);
            } else {
                g.strokeLine(x, y, x + 2.0, y + 2.0);
                g.strokeLine(x + 2.0, y + 2.0, x + 4.0, y);
                g.strokeLine(x + 1.0, y, x + 2.0, y + 1.0);
                g.strokeLine(x + 2.0, y + 1.0, x + 3.0, y);
                g.strokeLine(x, y + 4.0, x + 2.0, y + 6.0);
                g.strokeLine(x + 2.0, y + 6.0, x + 4.0, y + 4.0);
                g.strokeLine(x + 1.0, y + 4.0, x + 2.0, y + 5.0);
                g.strokeLine(x + 2.0, y + 5.0, x + 3.0, y + 4.0);
            }
        }

        @Override
        public void mousePressed(BMouseEvent event) {
            BTitlePane.this.getContent().setVisible(!BTitlePane.this.getContent().getVisible());
            BTitlePane.this.relayout();
            BTitlePane.this.expansionChanged();
        }
    }
}

