/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableNode;

public abstract class TreeTableModel
extends TableModel {
    boolean needInit = true;
    TreeTableNode[] rows = new TreeTableNode[0];

    public final BTreeTable getTreeTable() {
        return (BTreeTable)this.getTable();
    }

    public abstract int getRootCount();

    public abstract TreeTableNode getRoot(int var1);

    public TreeTableNode rowToNode(int row) {
        if (row < 0) {
            return null;
        }
        return this.rows[row];
    }

    public int nodeToRow(TreeTableNode node) {
        if (!this.isNodeVisibleRow(node)) {
            return -1;
        }
        return node.index;
    }

    public boolean isNodeVisibleRow(TreeTableNode node) {
        for (TreeTableNode p = node.getParent(); p != null; p = p.getParent()) {
            if (p.isExpanded()) continue;
            return false;
        }
        return true;
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public void updateTreeTable(boolean resizeColumns) {
        ArrayList<TreeTableNode> temp = new ArrayList<TreeTableNode>(this.rows.length + 10);
        for (int i = 0; i < this.getRootCount(); ++i) {
            this.updateTreeTable(temp, this.getRoot(i));
        }
        this.rows = temp.toArray(new TreeTableNode[temp.size()]);
        this.updateTable(resizeColumns);
    }

    void updateTreeTable(ArrayList<TreeTableNode> temp, TreeTableNode node) {
        temp.add(node);
        node.index = temp.size() - 1;
        if (node.isExpanded()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.updateTreeTable(temp, node.getChild(i));
            }
        }
    }

    public boolean needsInitialization() {
        return this.needInit;
    }

    @Override
    public int getRowCount() {
        if (this.needInit) {
            this.needInit = false;
            this.updateTreeTable(true);
        }
        return this.rows.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TreeTableNode node = this.rowToNode(row);
        if (node.isGroup() && col > 0) {
            return "";
        }
        return node.getValueAt(col);
    }

    @Override
    public Object getSubject(int row) {
        return this.rowToNode(row).getSubject();
    }

    @Override
    public BImage getRowIcon(int row) {
        return this.rowToNode(row).getIcon();
    }
}

