/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;

public class TreeNodeRenderer
extends BTree.TreeSupport {
    private static final double ICON_WIDTH = 16.0;
    private static final double ICON_HEIGHT = 16.0;
    private static final double MARGIN = 4.0;
    private BImage defaultIcon;
    private RectGeom nodeBounds;
    private RectGeom textBounds;
    private RectGeom selectionBounds;
    public boolean isMouseOver;

    public BImage getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = BImage.make((String)"module://icons/x16/folder.png");
        }
        return this.defaultIcon;
    }

    public BImage getIcon(TreeNode node) {
        return node.getIcon();
    }

    public void setDefaultIcon(BImage def) {
        this.defaultIcon = def;
    }

    public BBrush getForeground(TreeNode node) {
        return Theme.tree().getForeground(this.getTree());
    }

    public BBrush getBackground(TreeNode node) {
        return null;
    }

    public BBrush getSelectionForeground(TreeNode node) {
        return Theme.tree().getSelectionForeground();
    }

    public BBrush getSelectionBackground(TreeNode node) {
        return Theme.tree().getSelectionBackground();
    }

    public double getWidth(TreeNode node) {
        return 20.0 + this.getTextFont().width(TreeNodeRenderer.getNodeText(node)) + 2.0;
    }

    public double getHeight() {
        BFont font = this.getTextFont();
        double textHeight = font.getAscent() + font.getDescent();
        double themeTreeHeight = Theme.tree().getExpanderHeight() + Theme.tree().getInsets().top + Theme.tree().getInsets().bottom + 2.0;
        return Math.max(Math.max(16.0, themeTreeHeight), textHeight - 1.0);
    }

    public double getIconWidth() {
        return 16.0;
    }

    public double getIconHeight() {
        return 16.0;
    }

    public static String getNodeText(TreeNode node) {
        String text = node.getText();
        if (text == null) {
            return "";
        }
        return text;
    }

    public BFont getTextFont() {
        return Theme.tree().getFont(this.getTree());
    }

    public void paintNode(Graphics g, TreeNode node, double x, double y) {
        BFont font = this.getTextFont();
        BBrush background = this.getBackground(node);
        String text = TreeNodeRenderer.getNodeText(node);
        double height = this.getHeight();
        double iconY = y + (height - 16.0) / 2.0;
        double baseline = y + (height - font.getAscent()) / 2.0 + font.getAscent() - 1.0;
        double textX = x + 16.0 + 4.0;
        boolean selected = node.isSelected();
        boolean hasFocus = node.hasFocus();
        boolean isMouseOver = node.isMouseOver();
        if (!selected && background != null) {
            if (this.nodeBounds == null) {
                this.nodeBounds = new RectGeom(x, y, this.getWidth(node), this.getHeight());
            } else {
                this.nodeBounds.set(x, y, this.getWidth(node), this.getHeight());
            }
            g.setBrush(background);
            g.fillRect(this.nodeBounds.x, this.nodeBounds.y, this.nodeBounds.width, this.nodeBounds.height);
        }
        if (this.selectionBounds == null) {
            this.selectionBounds = new RectGeom(0.0, node.getY(), this.tree.getWidth(), height);
        } else {
            this.selectionBounds.set(0.0, node.getY(), this.tree.getWidth(), height);
        }
        if (selected) {
            Theme.tree().paintFocus(g, this.selectionBounds);
        } else if (isMouseOver) {
            PaintUtil.paintGlassRect(g, (int)this.selectionBounds.x, (int)this.selectionBounds.y, (int)this.selectionBounds.width, (int)this.selectionBounds.height, true);
        }
        BImage icon = this.getIcon(node);
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        if (icon != null) {
            g.drawImage(icon, x, iconY);
        }
        g.setFont(font);
        g.setBrush(selected ? this.getSelectionForeground(node) : this.getForeground(node));
        g.drawString(text, textX, baseline);
    }
}

