/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.baja.gx.BFont;
import javax.baja.ui.text.Segment;

public class Line {
    public final char[] buffer;
    public final Segment[] segments;

    public Line(char[] buffer, Segment[] segments) {
        this.buffer = buffer;
        this.segments = segments;
    }

    public Line(char[] buffer, int offset, int length, List<Segment> segments) {
        this.buffer = new char[length];
        System.arraycopy(buffer, offset, this.buffer, 0, length);
        this.segments = segments.toArray(new Segment[segments.size()]);
    }

    public Line(Line line1, Line line2) {
        if (line1.segments[line1.segments.length - 1].type == 3) {
            throw new IllegalArgumentException();
        }
        this.buffer = new char[line1.buffer.length + line2.buffer.length];
        this.segments = new Segment[line1.segments.length + line2.segments.length];
        System.arraycopy(line1.buffer, 0, this.buffer, 0, line1.buffer.length);
        System.arraycopy(line2.buffer, 0, this.buffer, line1.buffer.length, line2.buffer.length);
        System.arraycopy(line1.segments, 0, this.segments, 0, line1.segments.length);
        System.arraycopy(line2.segments, 0, this.segments, line1.segments.length, line2.segments.length);
    }

    public int getColumnCount() {
        return this.buffer.length;
    }

    public Segment getSegmentAt(int col) {
        int index = this.getSegmentIndexAt(col);
        if (index < 0) {
            return null;
        }
        return this.segments[index];
    }

    public int getSegmentIndexAt(int col) {
        if (col < 0 || col > this.buffer.length) {
            return -1;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (col >= this.segments[i].offset + this.segments[i].length) continue;
            return i;
        }
        return -1;
    }

    public boolean endsWithNewline() {
        int len = this.buffer.length;
        if (len == 0) {
            return false;
        }
        return this.buffer[len - 1] == '\n';
    }

    public int getColumnCountWithoutNewline() {
        int len = this.buffer.length;
        if (len == 0) {
            return 0;
        }
        return this.buffer[len - 1] == '\n' ? len - 1 : len;
    }

    public double getWidth(BFont font) {
        return font.width(this.buffer, 0, this.buffer.length);
    }

    public double getWidth(BFont font, int startChar, int endChar) {
        if (endChar > this.buffer.length - 1) {
            endChar = this.buffer.length == 0 ? 0 : this.buffer.length - 1;
        }
        return font.width(this.buffer, startChar, endChar);
    }

    public String toString() {
        return "Line: " + new String(this.buffer);
    }

    Line stripNewline() {
        if (!this.endsWithNewline()) {
            return this;
        }
        char[] newBuf = new char[this.buffer.length - 1];
        System.arraycopy(this.buffer, 0, newBuf, 0, newBuf.length);
        Segment[] newSeg = new Segment[this.segments.length - 1];
        System.arraycopy(this.segments, 0, newSeg, 0, newSeg.length);
        return new Line(newBuf, newSeg);
    }

    void write(Writer out) throws IOException {
        if (this.buffer.length == 0) {
            return;
        }
        Segment last = this.segments[this.segments.length - 1];
        if (last.type == 3) {
            out.write(this.buffer, 0, this.buffer.length - 1);
            if (last.isNewlineR()) {
                out.write(13);
            } else if (last.isNewlineRN()) {
                out.write("\r\n");
            } else {
                out.write(10);
            }
        } else {
            out.write(this.buffer, 0, this.buffer.length);
        }
    }

    char[] toCharArrayGrowAsNeeded(int col) {
        char[] buf = this.buffer;
        if (col < this.getColumnCountWithoutNewline()) {
            return buf;
        }
        if (this.endsWithNewline()) {
            char[] grow = new char[col + 1];
            System.arraycopy(buf, 0, grow, 0, buf.length - 1);
            for (int i = buf.length - 1; i < col; ++i) {
                grow[i] = 32;
            }
            grow[col] = 10;
            return grow;
        }
        char[] grow = new char[col];
        System.arraycopy(buf, 0, grow, 0, buf.length);
        for (int i = buf.length; i < col; ++i) {
            grow[i] = 32;
        }
        return grow;
    }
}

