/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.BFindPane;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.util.UiLexicon;

public class FindPattern {
    static BImage icon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static FindPattern current = new FindPattern("", false, false, false);
    static final int FORWARD = 0;
    static final int BACKWARD = 1;
    public final String string;
    public final boolean matchCase;
    public final boolean matchWord;
    public final boolean fromTop;
    private char[] buffer;

    public static FindPattern getCurrent() {
        return current;
    }

    public static void setCurrent(FindPattern pattern) {
        current = pattern;
    }

    public static FindPattern query(BWidget owner) {
        BFindPane pane;
        UiLexicon lex = UiLexicon.bajaui();
        String title = lex.getText("commands.find.label");
        if (BDialog.open(owner, title, pane = new BFindPane(owner), 3, icon) == 2) {
            return null;
        }
        current = pane.save();
        if (FindPattern.current.fromTop && owner instanceof BTextEditor) {
            ((BTextEditor)owner).moveCaretPosition(new Position(0, 0));
        }
        return current;
    }

    public FindPattern(String string, boolean matchCase, boolean matchWord) {
        this(string, matchCase, matchWord, false);
    }

    public FindPattern(String string, boolean matchCase, boolean matchWord, boolean fromTop) {
        this.string = string;
        this.matchCase = matchCase;
        this.matchWord = matchWord;
        this.fromTop = fromTop;
    }

    public int findNext(String text, int start) {
        return this.find(text, start, 0);
    }

    public int findPrev(String text, int start) {
        return this.find(text, start, 1);
    }

    public int findNext(char[] buf, int start, int len) {
        return this.find(buf, start, len, 0);
    }

    public int findPrev(char[] buf, int start, int len) {
        return this.find(buf, start, len, 1);
    }

    private int find(String text, int start, int dir) {
        if (this.buffer == null) {
            this.buffer = new char[Math.max(64, text.length())];
        }
        if (text.length() > this.buffer.length) {
            this.buffer = new char[text.length()];
        }
        text.getChars(0, text.length(), this.buffer, 0);
        return this.find(this.buffer, start, text.length() - start, dir);
    }

    private int find(char[] buf, int start, int len, int dir) {
        int end = start + len - this.string.length();
        if (end < 0 || end >= buf.length) {
            return -1;
        }
        if (dir == 0) {
            for (int i = start; i <= end; ++i) {
                if (!this.isMatch(buf, i)) continue;
                return i;
            }
            return -1;
        }
        for (int i = start; i >= 0; --i) {
            if (!this.isMatch(buf, i)) continue;
            return i;
        }
        return -1;
    }

    private boolean isMatch(char[] buf, int index) {
        String string = this.string;
        boolean matchCase = this.matchCase;
        int strlen = string.length();
        if (this.matchWord) {
            if (index > 0 && this.isWord(buf[index - 1])) {
                return false;
            }
            if (index + strlen < buf.length && this.isWord(buf[index + strlen])) {
                return false;
            }
        }
        for (int i = 0; i < strlen; ++i) {
            if (!(matchCase ? buf[index + i] != string.charAt(i) : Character.toLowerCase(buf[index + i]) != Character.toLowerCase(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean isWord(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '$';
    }

    public String toString() {
        return this.string;
    }

    public String replace(String text, String replaceWith) {
        char[] buf = text.toCharArray();
        return this.replace(buf, 0, buf.length, replaceWith);
    }

    public String replace(char[] buf, int start, int len, String replaceWith) {
        int x;
        StringBuffer result = new StringBuffer(len - start);
        while ((x = this.findNext(buf, start, len - start)) >= 0) {
            if (start < x) {
                result.append(buf, start, x - start);
            }
            result.append(replaceWith);
            start = x + this.string.length();
        }
        if (start < len) {
            result.append(buf, start, len - start);
        }
        return result.toString();
    }
}

