/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.util.List;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.ui.table.TableModel;

public class DefaultTableModel
extends TableModel {
    private String[] columnNames;
    private int count;
    private Row[] rows;

    public DefaultTableModel() {
        this.columnNames = new String[0];
        this.rows = new Row[16];
    }

    public DefaultTableModel(String[] columnNames) {
        this.columnNames = columnNames;
        this.rows = new Row[16];
    }

    @Override
    public synchronized int getRowCount() {
        return this.count;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public synchronized String getColumnName(int index) {
        return this.columnNames[index];
    }

    @Override
    public synchronized BImage getRowIcon(int row) {
        return this.rows[row].icon;
    }

    @Override
    public synchronized Object getValueAt(int row, int col) {
        return this.rows[row].columns[col];
    }

    @Override
    public synchronized Object getSubject(int row) {
        return this.getRowValues(row);
    }

    @Override
    public boolean isColumnSortable(int col) {
        return true;
    }

    @Override
    public synchronized void sortByColumn(int col, boolean ascending) {
        Object[] keys = this.getColumnValues(col);
        Object[] temp = new Row[keys.length];
        System.arraycopy(this.rows, 0, temp, 0, keys.length);
        SortUtil.sort((Object[])keys, (Object[])temp, (boolean)ascending);
        this.rows = temp;
    }

    public synchronized void set(int row, int col, Object value) {
        this.rows[row].columns[col] = value;
        this.updateTable();
    }

    public void addRow(Object[] rowValues) {
        this.addRow(new Row(null, rowValues));
    }

    public void addRow(BImage icon, Object[] rowValues) {
        this.addRow(new Row(icon, rowValues));
    }

    public void addRow(List<Object> rowData) {
        this.addRow(new Row(null, rowData.toArray()));
    }

    public void addRow(BImage icon, List<Object> rowData) {
        this.addRow(new Row(icon, rowData.toArray()));
    }

    private synchronized void addRow(Row row) {
        if (row.columns.length != this.columnNames.length) {
            throw new IllegalArgumentException("invalid number of columns");
        }
        if (this.count >= this.rows.length) {
            Row[] temp = new Row[this.count * 2 + 1];
            System.arraycopy(this.rows, 0, temp, 0, this.count);
            this.rows = temp;
        }
        this.rows[this.count++] = row;
        this.updateTable();
    }

    public synchronized void removeRow(int row) {
        System.arraycopy(this.rows, row + 1, this.rows, row, this.count - row - 1);
        this.rows[this.count - 1] = null;
        --this.count;
        this.updateTable();
    }

    public synchronized void removeAllRows() {
        this.count = 0;
        this.updateTable();
    }

    static class Row {
        BImage icon;
        Object[] columns;

        Row(BImage i, Object[] c) {
            this.icon = i;
            this.columns = c;
        }
    }
}

