/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;

public class BTable
extends BTransferWidget {
    public static final Property multipleSelection = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property headerVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property optionsButtonVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property hgridVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property vgridVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property extendedResize = BTable.newProperty((int)0, (boolean)false, null);
    public static final Property hscrollBarVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property vscrollBarVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property gridBrush = BTable.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property colorRows = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property evenRowColor = BTable.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property oddRowColor = BTable.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property hscrollBar = BTable.newProperty((int)7, (BValue)new BScrollBar(BOrientation.horizontal), null);
    public static final Property vscrollBar = BTable.newProperty((int)7, (BValue)new BScrollBar(BOrientation.vertical), null);
    public static final Property optionsButton = BTable.newProperty((int)3, (BValue)new BButton(), null);
    public static final Action vscroll = BTable.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Action hscroll = BTable.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Topic actionPerformed = BTable.newTopic((int)0, null);
    public static final Topic cancelled = BTable.newTopic((int)0, null);
    public static final Topic tableModified = BTable.newTopic((int)0, null);
    public static final Topic selectionModified = BTable.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTable.class);
    private static final BIcon icon = BIcon.std((String)"widgets/table.png");
    private BScrollBar vsb;
    private BScrollBar hsb;
    private BButton optButton;
    private TableModel model;
    private TableController controller;
    private TableHeaderRenderer headerRenderer;
    private TableCellRenderer cellRenderer;
    private TableSelection selection;
    private double[] columnPositions = new double[0];
    private double[] columnWidths = new double[0];
    private double preferredWidth;
    private double cellHeight;
    private double headerHeight;
    private boolean needsColumnLayout = true;
    private TableHeaderRenderer.Header header = new TableHeaderRenderer.Header();
    private TableCellRenderer.Cell cell = new TableCellRenderer.Cell();
    private int sortColumn = -1;
    private boolean sortAscending = true;

    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    public void setMultipleSelection(boolean v) {
        this.setBoolean(multipleSelection, v, null);
    }

    public boolean getHeaderVisible() {
        return this.getBoolean(headerVisible);
    }

    public void setHeaderVisible(boolean v) {
        this.setBoolean(headerVisible, v, null);
    }

    public boolean getOptionsButtonVisible() {
        return this.getBoolean(optionsButtonVisible);
    }

    public void setOptionsButtonVisible(boolean v) {
        this.setBoolean(optionsButtonVisible, v, null);
    }

    public boolean getHgridVisible() {
        return this.getBoolean(hgridVisible);
    }

    public void setHgridVisible(boolean v) {
        this.setBoolean(hgridVisible, v, null);
    }

    public boolean getVgridVisible() {
        return this.getBoolean(vgridVisible);
    }

    public void setVgridVisible(boolean v) {
        this.setBoolean(vgridVisible, v, null);
    }

    public boolean getExtendedResize() {
        return this.getBoolean(extendedResize);
    }

    public void setExtendedResize(boolean v) {
        this.setBoolean(extendedResize, v, null);
    }

    public boolean getHscrollBarVisible() {
        return this.getBoolean(hscrollBarVisible);
    }

    public void setHscrollBarVisible(boolean v) {
        this.setBoolean(hscrollBarVisible, v, null);
    }

    public boolean getVscrollBarVisible() {
        return this.getBoolean(vscrollBarVisible);
    }

    public void setVscrollBarVisible(boolean v) {
        this.setBoolean(vscrollBarVisible, v, null);
    }

    public BBrush getGridBrush() {
        return (BBrush)this.get(gridBrush);
    }

    public void setGridBrush(BBrush v) {
        this.set(gridBrush, (BValue)v, null);
    }

    public boolean getColorRows() {
        return this.getBoolean(colorRows);
    }

    public void setColorRows(boolean v) {
        this.setBoolean(colorRows, v, null);
    }

    public BBrush getEvenRowColor() {
        return (BBrush)this.get(evenRowColor);
    }

    public void setEvenRowColor(BBrush v) {
        this.set(evenRowColor, (BValue)v, null);
    }

    public BBrush getOddRowColor() {
        return (BBrush)this.get(oddRowColor);
    }

    public void setOddRowColor(BBrush v) {
        this.set(oddRowColor, (BValue)v, null);
    }

    public BScrollBar getHscrollBar() {
        return (BScrollBar)this.get(hscrollBar);
    }

    public void setHscrollBar(BScrollBar v) {
        this.set(hscrollBar, (BValue)v, null);
    }

    public BScrollBar getVscrollBar() {
        return (BScrollBar)this.get(vscrollBar);
    }

    public void setVscrollBar(BScrollBar v) {
        this.set(vscrollBar, (BValue)v, null);
    }

    public BButton getOptionsButton() {
        return (BButton)this.get(optionsButton);
    }

    public void setOptionsButton(BButton v) {
        this.set(optionsButton, (BValue)v, null);
    }

    public void vscroll(BScrollEvent event) {
        this.invoke(vscroll, (BValue)event, null);
    }

    public void hscroll(BScrollEvent event) {
        this.invoke(hscroll, (BValue)event, null);
    }

    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    public void fireCancelled(BWidgetEvent event) {
        this.fire(cancelled, (BValue)event, null);
    }

    public void fireTableModified(BWidgetEvent event) {
        this.fire(tableModified, (BValue)event, null);
    }

    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTable() {
        this(new DefaultTableModel(), new TableController(), new TableSelection());
    }

    public BTable(TableModel model) {
        this(model, new TableController(), new TableSelection(), new TableHeaderRenderer(), new TableCellRenderer());
    }

    public BTable(TableModel model, TableController controller) {
        this(model, controller, new TableSelection(), new TableHeaderRenderer(), new TableCellRenderer());
    }

    public BTable(TableModel model, TableController controller, TableSelection selection) {
        this(model, controller, selection, new TableHeaderRenderer(), new TableCellRenderer());
    }

    public BTable(TableModel model, TableController controller, TableSelection selection, TableHeaderRenderer headerRenderer, TableCellRenderer cellRenderer) {
        this.setModel(model);
        this.setController(controller);
        this.setSelection(selection);
        this.setHeaderRenderer(headerRenderer);
        this.setCellRenderer(cellRenderer);
        this.initUIComponents();
    }

    protected void initUIComponents() {
        this.vsb = this.getVscrollBar();
        this.hsb = this.getHscrollBar();
        this.optButton = this.getOptionsButton();
        this.optButton.setStyleId("tableOptionsButton");
        this.optButton.setFocusTraversable(false);
        this.optButton.setCommand(new OptionsCommand(this), false, true);
        this.linkTo(this.vsb, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
        this.linkTo(this.hsb, (Slot)BScrollBar.positionChanged, (Slot)hscroll);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.installSupport(this.model, model);
        this.model = model;
        this.fireTableModified(new BWidgetEvent(1, this));
    }

    public TableController getController() {
        return this.controller;
    }

    public void setController(TableController controller) {
        this.installSupport(this.controller, controller);
        this.controller = controller;
    }

    public TableSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TableSelection selection) {
        this.installSupport(this.selection, selection);
        this.selection = selection;
    }

    public TableHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setHeaderRenderer(TableHeaderRenderer renderer) {
        this.installSupport(this.headerRenderer, renderer);
        this.headerRenderer = renderer;
        this.headerHeight = this.getHeaderVisible() ? renderer.getHeaderHeight() : 1.0;
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TableCellRenderer renderer) {
        this.installSupport(this.cellRenderer, renderer);
        this.cellRenderer = renderer;
        this.cellHeight = renderer.getCellHeight();
    }

    private void installSupport(TableSupport old, TableSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.table != null) {
            throw new IllegalArgumentException("Already installed on another table");
        }
        if (old != null) {
            old.setTable(null);
        }
        support.setTable(this);
    }

    @Override
    public void changed(Property prop, Context context) {
        this.relayout();
    }

    @Override
    public void computePreferredSize() {
        int w = 0;
        int h = 0;
        int colCount = this.model.getColumnCount();
        if (this.needsColumnLayout || colCount != this.columnPositions.length) {
            this.layoutColumns();
        }
        w = (int)((double)w + this.preferredWidth);
        if (this.getHeaderVisible()) {
            h = (int)((double)h + this.headerRenderer.getHeaderHeight());
        }
        h = (int)((double)h + (double)this.model.getRowCount() * this.cellHeight);
        w = Math.max(w, 10);
        h = Math.max(h, 10);
        this.setPreferredSize(w, h);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        int colCount = this.model.getColumnCount();
        double scrollWidth = Theme.scrollBar().getFixedWidth();
        this.headerHeight = this.getHeaderVisible() ? this.headerRenderer.getHeaderHeight() : 1.0;
        this.layoutVertScrollBar();
        if (this.getOptionsButtonVisible() && this.getHeaderVisible()) {
            this.optButton.setBounds(w - scrollWidth, 0.0, scrollWidth, this.headerHeight);
        } else {
            this.optButton.setVisible(false);
        }
        if (this.needsColumnLayout || colCount != this.columnPositions.length) {
            this.layoutColumns();
        }
        this.layoutHorizScrollBar();
    }

    private void layoutVertScrollBar() {
        double dh;
        double w = this.getWidth();
        double h = this.getHeight();
        int rowCount = this.model.getRowCount();
        int colCount = this.model.getColumnCount();
        double scrollWidth = Theme.scrollBar().getFixedWidth();
        int visibleRows = this.getVisibleRowCount();
        double d = dh = this.hsb.isVisible() ? scrollWidth - 1.0 : 0.0;
        if (visibleRows < rowCount && this.getVscrollBarVisible()) {
            this.vsb.setVisible(true);
            this.vsb.setMin(0);
            this.vsb.setMax(rowCount);
            this.vsb.setExtent(visibleRows);
            this.vsb.setBlockIncrement(Math.max(3, visibleRows - 1));
            double y = this.getHeaderVisible() ? this.headerHeight - 1.0 : this.headerHeight;
            this.vsb.setBounds(w - scrollWidth, y, scrollWidth, h - y - dh);
        } else {
            this.vsb.setVisible(false);
            this.vsb.setBounds(0.0, 0.0, 0.0, 0.0);
            this.vsb.setPosition(0);
            this.vsb.setMin(0);
            this.vsb.setMax(visibleRows);
            this.vsb.setExtent(visibleRows);
        }
    }

    private void layoutHorizScrollBar() {
        double w = this.getWidth();
        double h = this.getHeight();
        int rowCount = this.model.getRowCount();
        double scrollWidth = Theme.scrollBar().getFixedWidth();
        double total = 0.0;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            total += this.columnWidths[i];
        }
        boolean v = this.hsb.isVisible();
        if (total > w && this.getHscrollBarVisible()) {
            this.hsb.setVisible(true);
            this.hsb.setMin(0);
            this.hsb.setMax((int)total);
            this.hsb.setExtent((int)(w - scrollWidth));
            double dw = this.getVisibleRowCount() < rowCount ? scrollWidth - 1.0 : 0.0;
            this.hsb.setBounds(0.0, h - scrollWidth, w - dw, scrollWidth);
            if (!v) {
                this.layoutVertScrollBar();
            }
        } else {
            this.hsb.setVisible(false);
            if (v) {
                this.layoutVertScrollBar();
            }
        }
    }

    private void layoutColumns() {
        TableHeaderRenderer headerRenderer = this.headerRenderer;
        TableCellRenderer cellRenderer = this.cellRenderer;
        TableModel model = this.model;
        int rowCount = model.getRowCount();
        int colCount = model.getColumnCount();
        double[] widths = new double[colCount];
        if (this.getHeaderVisible()) {
            for (int c = 0; c < colCount; ++c) {
                String name = model.getColumnName(c);
                if (name == null) {
                    name = "";
                }
                this.header.column = c;
                this.header.name = name;
                widths[c] = headerRenderer.getPreferredHeaderWidth(this.header);
            }
        }
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                this.cell.row = r;
                this.cell.column = c;
                try {
                    this.cell.value = model.getValueAt(r, c);
                    double colWidth = cellRenderer.getPreferredCellWidth(this.cell);
                    widths[c] = Math.max(widths[c], colWidth);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        double total = 0.0;
        if (colCount > 0) {
            total = widths[0];
        }
        double[] positions = new double[colCount];
        for (int c = 1; c < colCount; ++c) {
            total += widths[c];
            positions[c] = positions[c - 1] + widths[c - 1];
        }
        this.columnPositions = positions;
        this.preferredWidth = total;
        this.needsColumnLayout = false;
        this.columnWidths = widths;
    }

    public void sizeColumnsToFit() {
        this.needsColumnLayout = true;
        this.relayout();
    }

    double translateXToTable(double x) {
        if (this.hsb.isVisible()) {
            return x + (double)this.hsb.getPosition();
        }
        return x;
    }

    public int getColumnAt(double x) {
        x = this.translateXToTable(x);
        double[] pos = this.columnPositions;
        for (int c = 1; c < pos.length; ++c) {
            if (!(x < pos[c])) continue;
            return c - 1;
        }
        return pos.length - 1;
    }

    public int getRowAt(double y) {
        if (y < 0.0 || y > this.getHeight()) {
            return -1;
        }
        if (y < this.headerHeight) {
            return Integer.MAX_VALUE;
        }
        int row = (int)((y - this.headerHeight) / this.cellHeight) + this.vsb.getPosition();
        if (row < this.model.getRowCount()) {
            return row;
        }
        return -1;
    }

    public double getHeaderWidth(int col) {
        double[] w = this.columnWidths;
        double[] pos = this.columnPositions;
        boolean gap = this.getOptionsButtonVisible();
        double vsw = Theme.scrollBar().getFixedWidth();
        return col < pos.length - 1 ? pos[col + 1] - pos[col] : (this.hsb.isVisible() ? (double)this.hsb.getMax() - pos[col] + (gap ? 0.0 : vsw - 1.0) : this.getWidth() - (gap ? vsw : 1.0) - pos[col]);
    }

    public double getCellWidth(int col) {
        double[] w = this.columnWidths;
        double[] pos = this.columnPositions;
        boolean gap = this.vsb.isVisible();
        double vsw = Theme.scrollBar().getFixedWidth();
        return col < pos.length - 1 ? pos[col + 1] - pos[col] : (this.hsb.isVisible() ? (double)this.hsb.getMax() - pos[col] + (gap ? 0.0 : vsw) : this.getWidth() - (gap ? vsw : 0.0) - pos[col]);
    }

    public RectGeom getHeaderBounds(int col) {
        double x = this.columnPositions[col];
        double w = this.getHeaderWidth(col);
        return new RectGeom(x, 0.0, w, this.headerHeight);
    }

    public RectGeom getCellBounds(int row, int col) {
        double x = this.columnPositions[col];
        double y = this.headerHeight + (double)row * this.cellHeight;
        double w = this.getCellWidth(col);
        return new RectGeom(x, y, w, this.cellHeight);
    }

    public void setColumnPosition(int col, double x) {
        double delta;
        double[] pos = this.columnPositions;
        double[] width = this.columnWidths;
        double min = 0.0;
        if (col > 0) {
            min = pos[col - 1] + 6.0;
        }
        if (this.hsb.isVisible()) {
            x += (double)this.hsb.getPosition();
        }
        if (x < min) {
            x = min;
        }
        if ((delta = x - pos[col]) != 0.0) {
            int c = col;
            while (c < pos.length) {
                int n = c++;
                pos[n] = pos[n] + delta;
            }
            int n = col;
            width[n] = width[n] + delta;
            this.layoutHorizScrollBar();
            this.repaint();
        }
    }

    public int getVisibleRowCount() {
        double x = this.getHeight() - this.headerHeight;
        if (this.hsb.isVisible()) {
            x -= Theme.scrollBar().getFixedWidth();
        }
        return (int)(x / this.cellHeight);
    }

    public void ensureRowIsVisible(int row) {
        int visible = this.getVisibleRowCount();
        int start = this.vsb.getPosition();
        int end = start + visible;
        int rowCount = this.model.getRowCount();
        this.vsb.setMax(Math.max(visible, rowCount));
        if (row < start) {
            this.vsb.setPosition(row);
        } else if (row >= end) {
            int pos = row - visible + 1;
            if (pos >= rowCount) {
                pos = rowCount - 1;
            }
            if (pos < 0) {
                pos = 0;
            }
            this.vsb.setPosition(pos);
        }
    }

    public void doVscroll(BScrollEvent event) {
        this.repaint();
    }

    public void doHscroll(BScrollEvent event) {
        this.repaint();
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void sortByColumn(int col, boolean ascending) {
        this.sortColumn = col;
        this.sortAscending = ascending;
        if (col >= 0) {
            this.getModel().sortByColumn(col, ascending);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        this.paintBackground(g);
        if (this.hsb.isVisible()) {
            g.translate((double)(-this.hsb.getPosition()), 0.0);
        }
        IGeom origClip = g.getClip();
        int rowCount = this.model.getRowCount();
        int visibleRows = this.getVisibleRowCount();
        double hh = this.headerHeight;
        double ch = this.cellHeight;
        double w = this.getWidth();
        double h = this.getHeight();
        double[] pos = this.columnPositions;
        int colCount = pos.length;
        if (this.getHeaderVisible()) {
            for (int c = 0; c < colCount; ++c) {
                g.push();
                try {
                    this.paintHeader(g, c);
                    continue;
                }
                finally {
                    g.pop();
                }
            }
        }
        int start = this.vsb.getPosition();
        int end = Math.min(start + visibleRows + 1, rowCount);
        double y = this.headerHeight;
        for (int r = start; r < end; ++r) {
            for (int c = 0; c < colCount; ++c) {
                g.push();
                try {
                    this.paintCell(g, r, c, y);
                    continue;
                }
                finally {
                    g.pop();
                }
            }
            y += this.cellHeight;
        }
        double tx = this.hsb.isVisible() ? (double)this.hsb.getPosition() : 0.0;
        BBrush grid = this.getGridBrush();
        if (!grid.isNull()) {
            g.setBrush(grid);
        } else {
            g.setBrush(Theme.table().getGridBrush());
        }
        g.strokeLine(tx, hh, tx + w, hh);
        if (this.paintHorizontalGrid()) {
            for (int r = 1; r <= end - start; ++r) {
                g.strokeLine(tx + 1.0, (double)r * ch + hh - 1.0, tx + w - 2.0, (double)r * ch + hh - 1.0);
            }
        }
        if (this.paintVerticalGrid()) {
            for (int c = 1; c < colCount; ++c) {
                g.strokeLine(pos[c], hh, pos[c], y - 1.0);
            }
        }
        if (this.hsb.isVisible()) {
            g.translate((double)this.hsb.getPosition(), 0.0);
        }
        g.setBrush(Theme.table().getControlForeground(this));
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        this.paintChildren(g);
        if (this.hsb.isVisible() && this.vsb.isVisible()) {
            g.setBrush(Theme.widget().getControlBackground());
            g.fillRect(this.vsb.getX() + 1.0, this.hsb.getY() + 1.0, this.vsb.getWidth() - 2.0, Theme.scrollBar().getFixedWidth() - 2.0);
        }
    }

    protected void paintBackground(Graphics g) {
        Theme.table().paintBackground(g, this);
    }

    private void paintHeader(Graphics g, int c) {
        TableHeaderRenderer.Header header = this.header;
        double x = this.columnPositions[c];
        double y = 0.0;
        header.column = c;
        header.name = this.model.getColumnName(c);
        header.height = this.headerHeight;
        header.width = this.getHeaderWidth(c);
        double wClip = Math.min(header.width, this.translateXToTable(this.getWidth()) - x);
        double hClip = Math.min(header.height, this.getHeight());
        if (wClip < 0.0) {
            wClip = 0.0;
        }
        g.clip(x, 0.0, wClip, hClip);
        g.translate(x, 0.0);
        this.headerRenderer.paintHeader(g, header);
    }

    private void paintCell(Graphics g, int r, int c, double y) {
        TableCellRenderer.Cell cell = this.cell;
        double x = this.columnPositions[c] + 1.0;
        Object value = "?";
        try {
            value = this.model.getValueAt(r, c);
        }
        catch (Exception e) {
            System.out.println("ERROR:  BTable.paintCell: " + r + "," + c);
            System.out.println("  " + e);
        }
        cell.row = r;
        cell.column = c;
        cell.value = value;
        cell.width = this.getCellWidth(c);
        cell.height = this.cellHeight;
        cell.selected = this.selection.isSelected(r, c);
        double wClip = this.translateXToTable(this.getWidth()) - x;
        double hClip = this.getHeight() - y;
        if (wClip < 0.0) {
            wClip = 0.0;
        }
        g.clip(x, y, wClip, hClip);
        g.translate(x, y);
        g.clip(this.cellRenderer.getClip(cell));
        this.cellRenderer.paintCell(g, cell);
    }

    protected boolean paintHorizontalGrid() {
        return this.getHgridVisible();
    }

    protected boolean paintVerticalGrid() {
        return this.getVgridVisible();
    }

    @Override
    public String getStyleSelector() {
        return "table";
    }

    @Override
    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    @Override
    public void focusGained(BFocusEvent event) {
        this.controller.focusGained(event);
    }

    @Override
    public void focusLost(BFocusEvent event) {
        this.controller.focusLost(event);
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        this.controller.keyPressed(event);
    }

    @Override
    public void keyReleased(BKeyEvent event) {
        this.controller.keyReleased(event);
    }

    @Override
    public void keyTyped(BKeyEvent event) {
        this.controller.keyTyped(event);
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.controller.mousePressed(event);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.controller.mouseReleased(event);
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.controller.mouseEntered(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.controller.mouseExited(event);
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        this.resetHover();
        this.controller.mouseMoved(event);
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        this.controller.mouseDragged(event);
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        this.controller.mousePulsed(event);
    }

    @Override
    public void mouseWheel(BMouseWheelEvent event) {
        this.controller.mouseWheel(event);
    }

    @Override
    public void mouseHover(BMouseEvent event) {
        this.controller.mouseHover(event);
    }

    @Override
    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public static abstract class TableSupport {
        BTable table;

        public final BTable getTable() {
            return this.table;
        }

        public TableModel getModel() {
            return this.table.model;
        }

        public TableController getController() {
            return this.table.controller;
        }

        public TableHeaderRenderer getHeaderRenderer() {
            return this.table.headerRenderer;
        }

        public TableCellRenderer getCellRenderer() {
            return this.table.cellRenderer;
        }

        public TableSelection getSelection() {
            return this.table.selection;
        }

        public BWidgetShell getShell() {
            return this.table.getShell();
        }

        public void setTable(BTable table) {
            this.table = table;
        }
    }

    class OptionsCommand
    extends Command {
        OptionsCommand(BTable owner) {
            super(owner, "Options");
            this.icon = BImage.make((String)"module://bajaui/com/tridium/ui/images/tableColumns.png");
        }

        @Override
        public CommandArtifact doInvoke() {
            BTable.this.getController().doOptions();
            return null;
        }
    }
}

