/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.ui.theme.JavaFxTheme;
import com.tridium.ui.theme.Theme;
import java.awt.Graphics2D;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BLabelPaneContainer;

public class BToolPane
extends BLabelPaneContainer {
    public static final Type TYPE = Sys.loadType(BToolPane.class);
    private static final BBrush textBrush = BColor.white.toBrush();
    private static final BImage restoreIcon = BImage.make((String)"module://icons/x16/restoreWhite.png");
    private static final BImage maximizeIcon = BImage.make((String)"module://icons/x16/maximizeWhite.png");
    private static final int MAX = 10000;
    private MenuController menuController;
    private int[] sizes = new int[0];
    private int[] restore = new int[0];
    private BLabel armed;
    private MouseCursor origCursor;
    private boolean maximized;
    private boolean resizing;
    private int anchor;
    private int resize;
    private int resizeIndex;
    private double maxLabelWidth;

    @Override
    public Type getType() {
        return TYPE;
    }

    public MenuController getMenuController() {
        return this.menuController;
    }

    public void setMenuController(MenuController menuController) {
        this.menuController = menuController;
    }

    @Override
    public void computePreferredSize() {
        this.setPreferredSize(150.0, 200.0);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        if (kids.length == 0) {
            return;
        }
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        if (this.sizes.length != kids.length) {
            this.sizes = new int[kids.length];
            int ds = 10000 / this.sizes.length;
            for (int i = 0; i < this.sizes.length; ++i) {
                this.sizes[i] = ds;
            }
            this.maximized = false;
        }
        int ph = 0;
        int dh = 0;
        int dy = 0;
        int sum = 0;
        for (int i = 0; i < kids.length; ++i) {
            BLabelPane pane = (BLabelPane)kids[i];
            BLabel label = pane.getLabel();
            this.configureLabel(label);
            BWidget content = pane.getContent();
            if (i == 0) {
                label.computePreferredSize();
                ph = (int)label.getPreferredHeight() + 4;
                dh = h - ph * kids.length;
                dh = dh > 0 ? dh : 0;
            }
            int sz = (int)((float)dh * ((float)this.sizes[i] / 10000.0f));
            if (i == kids.length - 2 && sz > 0 && this.sizes[kids.length - 1] == 0) {
                sz = dh - sum;
            }
            int lx = this.menuController == null ? 5 : 20;
            int lw = w - lx - 20;
            label.setBounds(lx, dy, lw, ph);
            label.layout();
            content.setBounds(0.0, dy + ph, w, i == kids.length - 1 ? (double)(h - (dy + ph)) : (double)sz);
            content.layout();
            dy += ph + sz;
            sum += sz;
        }
    }

    private void configureLabel(BLabel label) {
        label.setFont(Theme.toolPane().getHeaderFont(this, label == this.armed));
        label.setForeground(Theme.toolPane().getForeground(this, label == this.armed));
        label.setPadding(Theme.toolPane().getLabelInsets(this));
    }

    @Override
    public void paint(Graphics g) {
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        g.setBrush(Theme.toolPane().getWindowBackground(this));
        g.fillRect(0.0, 0.0, (double)w, (double)h);
        BWidget[] kids = this.getChildWidgets();
        for (int i = kids.length - 1; i >= 0; --i) {
            BLabelPane kid = (BLabelPane)kids[i];
            this.paintLabel(g, kid.getLabel(), this.sizes[i] == 10000 && this.maximized, w, kids.length > 1);
            this.paintChild(g, kid.getContent());
            if (i >= kids.length - 1 || !Theme.javaFx().isEnabled()) continue;
            BWidget content = kid.getContent();
            this.paintDropShadow(g, content);
        }
        g.setBrush(Theme.toolPane().getControlForeground(this));
        g.strokeRect(0.0, 0.0, (double)(w - 1), (double)(h - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintHeaderBackground(Graphics g, BLabel label) {
        g.push();
        try {
            BBrush background = Theme.toolPane().getBackground(this, label == this.armed);
            g.setBrush(background);
            g.clip(0.0, label.getY(), this.getWidth(), label.getHeight());
            g.translate(0.0, label.getY());
            g.fillRect(0.0, 0.0, this.getWidth(), label.getHeight());
            BFont font = !label.getFont().isNull() ? label.getFont() : Theme.label().getTextFont(label);
            BImage labelImage = label.getImage();
            double labelWidth = font.width(label.getText()) + 2.0 * (labelImage.getWidth() + label.getX());
            double d = this.maxLabelWidth = labelWidth > this.maxLabelWidth ? labelWidth : this.maxLabelWidth;
            if (Theme.javaFx().isEnabled()) {
                int cornerRadius = (int)Theme.javaFx().getBorderRadius(this);
                if (cornerRadius > 0 && g instanceof AwtGraphics) {
                    g.setBrush(Theme.toolPane().getControlBackground(this));
                    Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
                    g2d.fillArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
                    g.fillRect(0.0, (double)cornerRadius, (double)cornerRadius, label.getHeight() - (double)cornerRadius);
                    g.fillRect((double)cornerRadius, 0.0, this.maxLabelWidth - (double)cornerRadius, label.getHeight());
                    g.setPen(BPen.make((double)2.0));
                    g.setBrush(Theme.toolPane().getControlHighlight(this));
                    g.strokeLine(0.0, label.getHeight(), this.maxLabelWidth, label.getHeight());
                    g.setBrush(Theme.toolPane().getControlShadow(this));
                    g.strokeLine(this.maxLabelWidth, label.getHeight(), this.getWidth(), label.getHeight());
                    g.setPen(BPen.make((double)1.0));
                    g.strokeLine(this.maxLabelWidth, 0.0, this.maxLabelWidth, label.getHeight());
                }
            } else {
                g.fillRect(0.0, 0.0, this.maxLabelWidth, label.getHeight());
            }
        }
        finally {
            g.pop();
        }
    }

    void paintLabel(Graphics g, BLabel label, boolean max, int w, boolean drawIcon) {
        this.paintHeaderBackground(g, label);
        this.paintChild(g, label);
        if (drawIcon) {
            int ix = w - 18;
            int iy = (int)label.getY() + ((int)label.getHeight() - 16) / 2;
            g.drawImage(max ? restoreIcon : maximizeIcon, (double)ix, (double)iy);
        }
        if (this.menuController != null) {
            int ay = (int)label.getY() + ((int)label.getHeight() - 5) / 2 - 1;
            g.setBrush(Theme.toolPane().getForeground(this, label == this.armed));
            this.paintMenuArrow(g, 10, ay);
        }
    }

    void paintMenuArrow(Graphics g, int x, int y) {
        int arrowWidth = 3;
        int mid = x + 10 - arrowWidth - 4;
        int bottom = y + arrowWidth + 2;
        for (int i = 0; i < arrowWidth; ++i) {
            g.strokeLine((double)(mid - i), (double)(bottom - i), (double)(mid + i), (double)(bottom - i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDropShadow(Graphics g, BWidget content) {
        JavaFxTheme theme = Theme.javaFx();
        double spread = theme.getDropShadowWidth(this);
        BBrush shadowBrush = theme.getDropShadow(this);
        int borderRadius = (int)theme.getBorderRadius(this);
        if (spread == 0.0 || shadowBrush == BBrush.DEFAULT) {
            return;
        }
        g.push();
        try {
            Graphics2D g2d = g instanceof AwtGraphics ? ((AwtGraphics)g).getAwtGraphics() : null;
            double x = content.getX();
            double y = content.getY();
            double cw = content.getWidth();
            double ch = content.getHeight();
            double currY = y + ch;
            BColor shadowColor = ((BBrush.Solid)shadowBrush.getPaint()).getColor();
            int red = shadowColor.getRed();
            int green = shadowColor.getGreen();
            int blue = shadowColor.getBlue();
            double alpha = shadowColor.getAlpha();
            double alphaIncrement = alpha / spread;
            int i = 0;
            while ((double)i < spread) {
                g.setBrush(BColor.make((int)red, (int)green, (int)blue, (int)((int)alpha)));
                if (borderRadius > 0 && g2d != null) {
                    int diameter = 2 * (borderRadius + i);
                    int cx = (int)x - i - 1;
                    int cy = (int)currY;
                    g.strokeLine((double)borderRadius, currY, (double)borderRadius + cw, currY);
                    g2d.drawArc(cx, cy, diameter, diameter, 90, 90);
                } else {
                    g.strokeLine(0.0, currY, cw, currY);
                }
                ++i;
                alpha -= alphaIncrement;
                currY -= 1.0;
            }
        }
        finally {
            g.pop();
        }
    }

    public void added(Property prop, Context context) {
        super.added(prop, context);
        BValue value = this.get(prop);
        if (value instanceof BLabelPane) {
            BLabel label = ((BLabelPane)value).getLabel();
            label.setForeground(textBrush);
            label.setFont(Theme.toolPane().getTextFont(this));
            label.setHalign(BHalign.left);
        }
    }

    @Override
    public BWidget childAt(Point pt) {
        BWidget[] kids = this.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            BLabelPane kid = (BLabelPane)kids[i];
            BWidget w = kid.getContent();
            int dx = (int)pt.x - (int)w.getX();
            int dy = (int)pt.y - (int)w.getY();
            if (!w.isVisible() || !w.contains(dx, dy)) continue;
            return w;
        }
        return null;
    }

    @Override
    public String getStyleSelector() {
        return "pane tool-pane";
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        if (this.resizing && event.getKeyCode() == 27) {
            System.arraycopy(this.restore, 0, this.sizes, 0, this.sizes.length);
            this.resizing = false;
            this.relayout();
            this.restoreCursor();
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.requestFocus();
        int mx = (int)event.getX();
        int my = (int)event.getY();
        int index = this.getLabelPaneAt(mx, my);
        if (index < 0) {
            return;
        }
        if ((double)mx > this.getWidth() - 20.0) {
            if (!this.maximized) {
                this.restore = new int[this.sizes.length];
                System.arraycopy(this.sizes, 0, this.restore, 0, this.sizes.length);
                this.maximized = true;
            }
            if (this.maximized && this.sizes[index] == 10000) {
                System.arraycopy(this.restore, 0, this.sizes, 0, this.sizes.length);
                this.maximized = false;
            } else {
                for (int i = 0; i < this.sizes.length; ++i) {
                    this.sizes[i] = i == index ? 10000 : 0;
                }
            }
            this.relayout();
        } else if (this.menuController != null && mx < 20) {
            BMenu menu = this.menuController.getMenu(this, this.getLabelPane(index).getContent());
            if (menu != null) {
                menu.open(this.armed, -this.armed.getX(), this.armed.getHeight());
            }
        } else if (!this.maximized && index > 0) {
            this.restore = new int[this.sizes.length];
            System.arraycopy(this.sizes, 0, this.restore, 0, this.sizes.length);
            this.resizing = true;
            this.anchor = this.resize = (int)event.getY();
            this.resizeIndex = index - 1;
        } else if (this.maximized) {
            System.arraycopy(this.restore, 0, this.sizes, 0, this.sizes.length);
            this.maximized = false;
            this.relayout();
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        if (this.resizing) {
            this.resizing = false;
            this.restoreCursor();
            this.relayout();
        }
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        if (this.resizing) {
            return;
        }
        int mx = (int)event.getX();
        int my = (int)event.getY();
        BLabel old = this.armed;
        int index = this.getLabelPaneAt(mx, my);
        BLabel bLabel = this.armed = index < 0 ? null : this.getLabelPane(index).getLabel();
        if (old != this.armed && index >= 0) {
            this.armed = this.getLabelPane(index).getLabel();
            this.repaint();
        }
        if (!this.maximized && index > 0 && this.armed != null && BToolPane.inResizeZone(this.armed, mx, my)) {
            this.setCursor();
        } else {
            this.restoreCursor();
        }
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.mouseMoved(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        if (this.resizing) {
            return;
        }
        this.restoreCursor();
        this.armed = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        if (this.resizing) {
            this.resize = (int)event.getY();
            this.resize();
            this.relayout();
        }
    }

    private BLabelPane getLabelPane(int index) {
        return (BLabelPane)this.getChildWidgets()[index];
    }

    private int getLabelPaneAt(int x, int y) {
        BWidget[] kids = this.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            int dy;
            int dx;
            BLabelPane kid = (BLabelPane)kids[i];
            BLabel label = kid.getLabel();
            if (!label.contains(dx = (int)label.getX(), dy = y - (int)label.getY())) continue;
            return i;
        }
        return -1;
    }

    private static boolean inResizeZone(BLabel label, int x, int y) {
        return label.contains((double)x - label.getX(), (double)y - label.getY());
    }

    private BLabelPane getPrevious(BLabelPane pane) {
        BWidget[] kids = this.getChildWidgets();
        for (int i = 0; i < kids.length - 1; ++i) {
            if (kids[i + 1] != pane) continue;
            return (BLabelPane)kids[i];
        }
        return null;
    }

    private void setCursor() {
        if (this.origCursor == null) {
            this.origCursor = this.getMouseCursor();
            this.setMouseCursor(MouseCursor.nResize);
        }
    }

    private void restoreCursor() {
        if (this.origCursor != null) {
            this.setMouseCursor(this.origCursor);
            this.origCursor = null;
        }
    }

    private void resize() {
        int i;
        float delta = (float)(this.resize - this.anchor) / (float)this.getHeight();
        int r = this.resizeIndex;
        int temp = 0;
        for (i = 0; i < r; ++i) {
            temp += this.sizes[i];
        }
        this.sizes[r] = this.restore[r] + (int)(delta * 10000.0f);
        if (this.sizes[r] < 0) {
            this.sizes[r] = 0;
        }
        if (this.sizes[r] + temp > 10000) {
            int n = r;
            this.sizes[n] = this.sizes[n] - (this.sizes[r] + temp - 10000);
        }
        temp += this.sizes[r];
        for (i = r + 1; i < this.sizes.length - 1; ++i) {
            if (this.sizes[r] > 0) {
                this.sizes[i] = this.restore[i] + (int)((float)this.restore[i] * -delta);
            }
            if (this.sizes[i] < 0) {
                this.sizes[i] = 0;
            }
            if (temp + this.sizes[i] > 10000) {
                int n = i;
                this.sizes[n] = this.sizes[n] - (this.sizes[i] + temp - 10000);
            }
            temp += this.sizes[i];
        }
        this.sizes[this.sizes.length - 1] = 10000 - temp;
    }

    public String pickle() {
        StringBuilder buf = new StringBuilder("toolpane=");
        BWidget[] kids = this.getChildWidgets();
        if (kids.length != this.sizes.length) {
            return buf.toString();
        }
        for (int i = 0; i < kids.length; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append(this.sizes[i]);
        }
        return buf.toString();
    }

    public void unpickle(String str) {
        BWidget[] kids;
        String[] sub = TextUtil.split((String)(str = str.substring("toolpane=".length())), (char)';');
        if (sub.length != (kids = this.getChildWidgets()).length) {
            return;
        }
        int[] old = this.sizes;
        try {
            this.sizes = new int[sub.length];
            for (int i = 0; i < sub.length; ++i) {
                this.sizes[i] = Integer.parseInt(sub[i]);
                if (this.sizes[i] != 10000 || this.sizes.length <= 1) continue;
                this.restore = new int[this.sizes.length];
                int ds = 10000 / this.sizes.length;
                for (int j = 0; j < this.restore.length; ++j) {
                    this.restore[j] = ds;
                }
                this.maximized = true;
            }
        }
        catch (Exception e) {
            this.sizes = old;
        }
    }

    public static interface MenuController {
        public BMenu getMenu(BToolPane var1, BWidget var2);
    }
}

