/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.ShellManager;
import com.tridium.ui.util.LayoutUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLayoutDimension;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BResponsivePane;
import javax.baja.ui.pane.BScrollPane;

public class BFlowPane
extends BPane {
    public static final Property align = BFlowPane.newProperty((int)0, (BValue)BHalign.left, null);
    public static final Property rowAlign = BFlowPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property hgap = BFlowPane.newProperty((int)0, (int)4, null);
    public static final Property vgap = BFlowPane.newProperty((int)0, (int)4, null);
    public static final Property background = BFlowPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Type TYPE = Sys.loadType(BFlowPane.class);
    protected double lastMaxHeight = 0.0;
    private static final BIcon icon = BIcon.std((String)"widgets/flowPane.png");

    public BHalign getAlign() {
        return (BHalign)this.get(align);
    }

    public void setAlign(BHalign v) {
        this.set(align, (BValue)v, null);
    }

    public BValign getRowAlign() {
        return (BValign)this.get(rowAlign);
    }

    public void setRowAlign(BValign v) {
        this.set(rowAlign, (BValue)v, null);
    }

    public int getHgap() {
        return this.getInt(hgap);
    }

    public void setHgap(int v) {
        this.setInt(hgap, v, null);
    }

    public int getVgap() {
        return this.getInt(vgap);
    }

    public void setVgap(int v) {
        this.setInt(vgap, v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFlowPane() {
    }

    public BFlowPane(BHalign alignment) {
        this.setAlign(alignment);
    }

    public BFlowPane(BHalign alignment, int hgap, int vgap) {
        this.setAlign(alignment);
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    @Override
    public void computePreferredSize() {
        double w = 0.0;
        double h = 0.0;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        BWidget[] kids = this.getChildWidgets();
        double hgap = this.getHgap();
        for (int i = 0; i < kids.length; ++i) {
            BWidget k = kids[i];
            if (!k.isVisible()) continue;
            k.computePreferredSize();
            if (i > 0) {
                w += hgap;
            }
            w += k.getPreferredWidth();
            h = Math.max(h, k.getPreferredHeight());
            maxWidth = Math.max(maxWidth, this.getMinWidth(k, true));
            maxHeight = Math.max(maxHeight, k.getY() + k.getPreferredHeight());
        }
        BScrollPane scrollPane = LayoutUtil.getParentScrollPane(this);
        if (scrollPane != null) {
            BInsets border = LayoutUtil.getAccumulatedBorderAndScrollSize(this);
            BSize targetSize = BSize.make((double)(scrollPane.getWidth() - border.left - border.right), (double)(scrollPane.getHeight() - border.top - border.bottom));
            this.setPreferredSize(Math.max(targetSize.width(), maxWidth), Math.max(targetSize.height(), maxHeight));
        } else {
            this.setPreferredSize(w, h);
        }
    }

    @Override
    public void paint(Graphics g) {
        BBrush brush = this.getBackground();
        if (!brush.isNull()) {
            g.setBrush(brush);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    @Override
    public void doLayout(BWidget[] children) {
        this.doLayout(children, true);
    }

    protected void doLayout(BWidget[] children, boolean firstFixHeight) {
        double currentMaxHeight = 0.0;
        double rowTop = 0.0;
        BHalign alignment = this.getAlign();
        BValign valignment = this.getRowAlign();
        double w = this.getWidth();
        double hgap = this.getHgap();
        double vgap = this.getVgap();
        int rowStart = 0;
        int rowEnd = -1;
        double rowEndResponsiveWidth = -1.0;
        int rowEndResponsiveId = -1;
        while (rowStart < children.length) {
            double rowWidth = 0.0;
            double rowHeight = 0.0;
            boolean firstItem = true;
            double[] preferredWidths = new double[children.length];
            double rowWidthUsedByPercent = 0.0;
            double rowWidthUsedByAbs = 0.0;
            for (int i = rowStart; i < children.length; ++i) {
                BWidget child = children[i];
                if (!child.isVisible()) continue;
                preferredWidths[i] = this.getPreferredWidth(child);
                double moreWidth = preferredWidths[i] + (firstItem ? 0.0 : hgap);
                double moreWidthLeast = this.getMinWidth(child, true) + (firstItem ? 0.0 : hgap);
                if (!firstItem && BFlowPane.isForceNewRow(child)) break;
                if (moreWidth + rowWidth <= w) {
                    rowWidth += moreWidth;
                    rowHeight = Math.max(rowHeight, child.getPreferredHeight());
                    rowEnd = i;
                    firstItem = false;
                    continue;
                }
                if (!(moreWidthLeast + rowWidth <= w)) break;
                rowEndResponsiveWidth = w - rowWidth - (firstItem ? 0.0 : hgap);
                rowEndResponsiveId = i;
                rowWidth = w;
                rowHeight = Math.max(rowHeight, child.getPreferredHeight());
                rowEnd = i;
                firstItem = false;
            }
            if (rowEnd < rowStart) {
                this.fixLastHeight(currentMaxHeight, firstFixHeight);
                return;
            }
            double x = alignment == BHalign.left ? 0.0 : (alignment == BHalign.right ? w - rowWidth : (alignment == BHalign.center ? (w - rowWidth) / 2.0 : 0.0));
            boolean usedByFirstItem = true;
            for (int i = rowStart; i <= rowEnd; ++i) {
                double y;
                BWidget child = children[i];
                if (!child.isVisible()) continue;
                double childHeight = child.getPreferredHeight();
                if (valignment == BValign.top) {
                    y = rowTop;
                } else if (valignment == BValign.center) {
                    y = rowTop + (rowHeight - childHeight) / 2.0;
                } else if (valignment == BValign.fill) {
                    y = rowTop;
                    childHeight = rowHeight;
                } else {
                    y = rowTop + rowHeight - childHeight;
                }
                double boundWidth = preferredWidths[i];
                if (rowEndResponsiveId == i) {
                    boundWidth = rowEndResponsiveWidth;
                }
                child.setBounds(x, y, boundWidth, childHeight);
                child.computePreferredSize();
                x += boundWidth + hgap;
                if (alignment == BHalign.fill) {
                    if (BFlowPane.isPercentMaxWidth(child)) {
                        rowWidthUsedByPercent += boundWidth;
                    } else {
                        rowWidthUsedByAbs += boundWidth;
                    }
                    if (!usedByFirstItem) {
                        rowWidthUsedByAbs += hgap;
                    }
                }
                currentMaxHeight = Math.max(currentMaxHeight, y + childHeight);
                usedByFirstItem = false;
            }
            if (alignment == BHalign.fill && rowWidthUsedByPercent > 0.0) {
                double specificRatio = w == 0.0 || rowWidthUsedByPercent == 0.0 ? 1.0 : (w - rowWidthUsedByAbs) / rowWidthUsedByPercent;
                double newX = 0.0;
                for (int i = rowStart; i <= rowEnd; ++i) {
                    double oldWidth;
                    BWidget child = children[i];
                    if (!child.isVisible()) continue;
                    double newWidth = oldWidth = child.getWidth();
                    if (BFlowPane.isPercentMaxWidth(child)) {
                        newWidth *= specificRatio;
                    }
                    child.setBounds(newX, child.getY(), newWidth, child.getHeight());
                    if (oldWidth != newWidth) {
                        child.computePreferredSize();
                    }
                    newX += newWidth + hgap;
                }
            }
            rowTop += rowHeight + vgap;
            rowStart = rowEnd + 1;
        }
        this.fixLastHeight(currentMaxHeight, firstFixHeight);
    }

    private static boolean isPercentMaxWidth(BWidget widget) {
        if (widget instanceof BResponsivePane) {
            BResponsivePane responsivePane = (BResponsivePane)widget;
            return responsivePane.getMaxWidth().getUnit() == 1;
        }
        return false;
    }

    private static boolean isForceNewRow(BWidget widget) {
        if (widget instanceof BResponsivePane) {
            BResponsivePane responsivePane = (BResponsivePane)widget;
            return responsivePane.getForceNewRow();
        }
        return false;
    }

    public double getPreferredWidth(BWidget widget) {
        if (widget instanceof BResponsivePane) {
            BResponsivePane responsivePane = (BResponsivePane)widget;
            BLayoutDimension maxWidth = responsivePane.getMaxWidth();
            double preferredWidth = maxWidth.getUnit() == 2 ? responsivePane.getPreferredWidth() : (maxWidth.getUnit() == 0 ? maxWidth.getValue() : this.getWidthFromPercentage(maxWidth.getValue()));
            double min = this.getMinWidth(widget, false);
            return Math.max(preferredWidth, min);
        }
        return widget.getPreferredWidth();
    }

    public double getWidthFromPercentage(double percent) {
        double parentWidth = LayoutUtil.getParentScrollPane(this) != null ? this.getPreferredWidth() : this.getWidth();
        double gapWith = percent == 0.0 ? 0.0 : 100.0 / percent - 1.0;
        return percent / 100.0 * (parentWidth -= gapWith * (double)this.getHgap());
    }

    private double getMinWidth(BWidget widget, boolean requiresComputePreferred) {
        if (widget instanceof BResponsivePane) {
            double min;
            BResponsivePane responsivePane = (BResponsivePane)widget;
            BLayoutDimension minWidth = responsivePane.getMinWidth();
            if (minWidth.getUnit() == 2) {
                if (requiresComputePreferred) {
                    responsivePane.computePreferredSize();
                }
                min = responsivePane.getPreferredWidth();
            } else {
                min = minWidth.getUnit() == 0 ? minWidth.getValue() : this.getWidthFromPercentage(minWidth.getValue());
            }
            min = Math.max(min, 0.0);
            return min;
        }
        if (requiresComputePreferred) {
            widget.computePreferredSize();
        }
        return widget.getPreferredWidth();
    }

    private void fixLastHeight(double currentMaxHeight, boolean firstFixHeight) {
        if (this.lastMaxHeight != currentMaxHeight) {
            BWidget parent = LayoutUtil.getParentScrollPane(this);
            while (parent instanceof BScrollPane || parent instanceof BBorderPane || parent instanceof BFlowPane) {
                ShellManager manager = this.getShellManager();
                if (parent.getWidth() > 0.0 && parent.getHeight() > 0.0) {
                    if (manager == null || manager.forceFreshLayout()) {
                        if (parent instanceof BFlowPane) {
                            if (firstFixHeight) {
                                ((BFlowPane)parent).doLayout(parent.getChildWidgets(), false);
                            }
                        } else {
                            parent.doLayout(parent.getChildWidgets());
                        }
                    } else {
                        parent.relayoutSync();
                    }
                }
                if (!((parent = (BWidget)parent.get("content")) instanceof BFlowPane)) continue;
                this.lastMaxHeight = currentMaxHeight;
            }
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

