/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.naming;

import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.naming.BRootContainer;

public class BWidgetScheme
extends BOrdScheme {
    public static final BWidgetScheme INSTANCE = new BWidgetScheme();
    public static final Type TYPE = Sys.loadType(BWidgetScheme.class);

    public BWidgetScheme() {
        super("widget");
    }

    public OrdQuery parse(String queryBody) {
        return new SlotPath("widget", queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        try {
            int i;
            BComplex from = this.ensureResolvable((BComplex)base.get());
            SlotPath path = (SlotPath)query;
            BComplex cur = path.isAbsolute() ? this.getRoot(from) : from;
            for (i = 0; i < path.getBackupDepth(); ++i) {
                cur = this.ensureResolvable(cur.getParent());
            }
            for (i = 0; i < path.depth(); ++i) {
                cur = this.ensureResolvable((BComplex)cur.get(path.nameAt(i)));
            }
            return new OrdTarget(base, (BObject)cur);
        }
        catch (Exception e) {
            throw new UnresolvedException("Could not resolve " + base + ", " + query, (Throwable)e);
        }
    }

    BComplex getRoot(BComplex child) {
        BComplex parent;
        while ((parent = child.getParent()) != null && !(parent instanceof BRootContainer)) {
            child = parent;
        }
        return child;
    }

    BComplex ensureResolvable(BComplex w) {
        if (w == null) {
            throw new NullPointerException();
        }
        if (w instanceof BRootContainer) {
            throw new IllegalStateException("Widgets of type " + w.getType() + " cannot be resolved.");
        }
        return w;
    }

    public static BOrd makeWidgetOrd(BWidget widget) {
        BWidget parent;
        Array arr = new Array(String.class);
        while ((parent = widget.getParentWidget()) != null && !(parent instanceof BRootContainer) && !(parent instanceof BWidgetShell)) {
            arr.add((Object)widget.getName());
            widget = parent;
        }
        String path = TextUtil.join((String[])((String[])arr.reverse().trim()), (char)'/');
        return BOrd.make((String)("widget:/" + path));
    }

    public Type getType() {
        return TYPE;
    }
}

