/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import javax.baja.sys.Clock;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.list.ListSubject;

public class ListController
extends BList.ListSupport {
    private String searchText = "";
    private long lastSearchTime = 0L;
    private int overItem = -1;
    private boolean overBackground;
    private boolean checkSelectionOnRelease;
    private double lastx;
    private double lasty;

    public void focusGained(BFocusEvent event) {
        BList list = this.getList();
        ListSelection sel = list.getSelection();
        if (sel.getItemCount() > 0) {
            if (sel.getItem() == -1) {
                sel.select(0);
            }
            this.getList().ensureItemIsVisible(sel.getItem());
        }
    }

    public void focusLost(BFocusEvent event) {
        this.getList().repaint();
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getModifiers() != 0 && event.getModifiers() != 1) {
            return;
        }
        int key = event.getKeyCode();
        BList list = this.getList();
        ListSelection sel = list.getSelection();
        int lead = sel.getLead();
        int visible = list.getVisibleRowCount();
        int top = list.getVscrollBar().getPosition();
        switch (key) {
            case 36: {
                event.consume();
                sel.select(0, true);
                list.ensureItemIsVisible(0);
                this.searchText = "";
                break;
            }
            case 35: {
                event.consume();
                int item = list.getModel().getItemCount() - 1;
                sel.select(item, true);
                list.ensureItemIsVisible(item);
                this.searchText = "";
                break;
            }
            case 38: {
                event.consume();
                lead = Math.max(lead - 1, 0);
                sel.select(lead, true);
                list.ensureItemIsVisible(lead);
                this.searchText = "";
                break;
            }
            case 40: {
                event.consume();
                lead = Math.min(lead + 1, list.getModel().getItemCount() - 1);
                sel.select(lead, true);
                list.ensureItemIsVisible(lead);
                this.searchText = "";
                break;
            }
            case 33: {
                event.consume();
                lead = lead > top && lead <= top + visible ? Math.max(top, 0) : Math.max(lead - visible + 1, 0);
                sel.select(lead, true);
                list.ensureItemIsVisible(lead);
                this.searchText = "";
                break;
            }
            case 34: {
                event.consume();
                lead = lead > top && lead < top + visible - 1 ? Math.min(top + visible - 1, list.getModel().getItemCount() - 1) : Math.min(lead + visible - 1, list.getModel().getItemCount() - 1);
                sel.select(lead, true);
                list.ensureItemIsVisible(lead);
                this.searchText = "";
                break;
            }
            default: {
                char ch = event.getKeyChar();
                if ((32 > key || key > 57) && (65 > key || key > 90)) break;
                this.searchText = Clock.ticks() - 750L < this.lastSearchTime ? this.searchText + ch : "" + ch;
                if (!this.search(this.searchText)) {
                    // empty if block
                }
                this.lastSearchTime = Clock.ticks();
                event.consume();
            }
        }
    }

    public void keyReleased(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        if (event.getKeyCode() == 10 || event.getKeyCode() == 9) {
            this.handleEnter(event);
        } else if (event.getKeyCode() == 27) {
            this.handleEscape(event);
        }
    }

    public void keyTyped(BKeyEvent event) {
    }

    protected void handleEnter(BKeyEvent event) {
        event.consume();
        this.getList().fireActionPerformed(new BWidgetEvent(2, this.getList()));
    }

    protected void handleEscape(BKeyEvent event) {
        event.consume();
        this.getList().fireCancelled(new BWidgetEvent(2, this.getList()));
    }

    private boolean search(String searchText) {
        ListModel model = this.getModel();
        ListSelection sel = this.getSelection();
        ListRenderer renderer = this.getRenderer();
        ListRenderer.Item item = new ListRenderer.Item();
        int index = -1;
        for (int i = 0; i < model.getItemCount(); ++i) {
            item.value = model.getItem(i);
            String text = renderer.getItemText(item);
            if (text == null || text.length() <= 0 || !text.toLowerCase().startsWith(searchText.toLowerCase())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            sel.select(index, true);
            this.list.ensureItemIsVisible(index);
            return true;
        }
        return false;
    }

    public void mousePressed(BMouseEvent event) {
        if (this.overItem != -1) {
            this.itemPressed(event, this.overItem);
        } else if (this.overBackground) {
            this.backgroundPressed(event);
        }
        this.getList().requestFocus();
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.overItem != -1) {
            this.itemReleased(event, this.overItem);
        } else if (this.overBackground) {
            this.backgroundReleased(event);
        }
        this.checkMouseOver(event);
    }

    public void mouseEntered(BMouseEvent event) {
        this.lastx = -1.0;
        this.lasty = -1.0;
        this.mouseMoved(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.fireExit(event);
    }

    public void mouseMoved(BMouseEvent event) {
        if (event.getX() == this.lastx && event.getY() == this.lasty) {
            return;
        }
        if (this.lastx == -1.0 && this.lasty == -1.0) {
            this.lastx = event.getX();
            this.lasty = event.getY();
            return;
        }
        this.lastx = event.getX();
        this.lasty = event.getY();
        if (this.checkMouseOver(event)) {
            return;
        }
        if (this.overItem != -1) {
            this.itemMoved(event, this.overItem);
        } else if (this.overBackground) {
            this.backgroundMoved(event);
        }
    }

    public void mouseDragged(BMouseEvent event) {
        if (this.overItem != -1) {
            this.itemDragged(event, this.overItem);
        } else if (this.overBackground) {
            this.backgroundDragged(event);
        }
    }

    public void mousePulsed(BMouseEvent event) {
        if (this.overItem != -1) {
            this.itemPulsed(event, this.overItem);
        } else if (this.overBackground) {
            this.backgroundPulsed(event);
        }
    }

    public void mouseWheel(BMouseWheelEvent event) {
        BScrollBar sb = this.getList().getVscrollBar();
        sb.scrollByUnits(event.getPreciseWheelRotation());
    }

    private boolean checkMouseOver(BMouseEvent event) {
        double my;
        double mx;
        BList list = this.getList();
        int index = list.getItemIndexAt(mx = event.getX(), my = event.getY());
        if (index == -1) {
            if (!this.overBackground) {
                this.fireExit(event);
                this.overBackground = true;
                this.backgroundEntered(event);
                return true;
            }
        } else if (this.overItem != index) {
            this.fireExit(event);
            this.overItem = index;
            this.itemEntered(event, this.overItem);
            return true;
        }
        return false;
    }

    private void fireExit(BMouseEvent event) {
        if (this.overItem != -1) {
            this.itemExited(event, this.overItem);
            this.overItem = -1;
        } else if (this.overBackground) {
            this.backgroundExited(event);
            this.overBackground = false;
        }
    }

    public int getMouseOverItem() {
        return this.overItem;
    }

    protected void itemEntered(BMouseEvent event, int index) {
    }

    protected void itemExited(BMouseEvent event, int index) {
    }

    protected void itemPressed(BMouseEvent event, int index) {
        if (this.getSelection().isSelected(index)) {
            this.checkSelectionOnRelease = true;
        } else {
            this.checkSelectionOnRelease = false;
            this.checkSelection(event, index);
        }
        if (event.isPopupTrigger()) {
            this.itemPopup(event, index);
        }
        if (event.getClickCount() == 2) {
            this.checkSelectionOnRelease = false;
            this.itemDoubleClicked(event, index);
        }
    }

    protected void itemReleased(BMouseEvent event, int index) {
        if (this.checkSelectionOnRelease) {
            this.checkSelectionOnRelease = false;
            if (!event.isPopupTrigger()) {
                this.checkSelection(event, index);
            }
        }
        if (event.isPopupTrigger()) {
            this.itemPopup(event, index);
        }
    }

    protected void itemMoved(BMouseEvent event, int index) {
    }

    protected void itemDragged(BMouseEvent event, int index) {
    }

    protected void itemPulsed(BMouseEvent event, int index) {
    }

    protected void itemDoubleClicked(BMouseEvent event, int index) {
    }

    protected void backgroundEntered(BMouseEvent event) {
    }

    protected void backgroundExited(BMouseEvent event) {
    }

    protected void backgroundPressed(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.backgroundPopup(event);
        } else if (!event.isButton3Down()) {
            this.getSelection().deselectAll();
        }
    }

    protected void backgroundReleased(BMouseEvent event) {
        if (event.isPopupTrigger()) {
            this.backgroundPopup(event);
        }
    }

    protected void backgroundMoved(BMouseEvent event) {
    }

    protected void backgroundDragged(BMouseEvent event) {
    }

    protected void backgroundPulsed(BMouseEvent event) {
    }

    protected void itemPopup(BMouseEvent event, int index) {
        this.popup(event, index);
    }

    protected void backgroundPopup(BMouseEvent event) {
        this.popup(event, -1);
    }

    protected void popup(BMouseEvent event, int index) {
        ListSubject subject = this.getSelection().getSubject(index);
        BMenu menu = this.makePopup(subject);
        if (menu != null) {
            menu.removeConsecutiveSeparators();
            menu.open(event);
        }
    }

    protected BMenu makePopup(ListSubject subject) {
        return null;
    }

    protected void checkSelection(BMouseEvent event, int item) {
        BList list = this.getList();
        ListSelection sel = list.getSelection();
        if (list.getMultipleSelection()) {
            if (event.isShiftDown()) {
                sel.select(sel.getAnchor(), item, !event.isControlDown());
            } else if (event.isControlDown()) {
                if (sel.isSelected(item)) {
                    sel.deselect(item);
                } else {
                    sel.select(item);
                }
            } else {
                sel.select(item, true);
                list.fireActionPerformed(new BWidgetEvent(2, this.getList()));
            }
        } else {
            sel.select(item, true);
            list.fireActionPerformed(new BWidgetEvent(2, this.getList()));
        }
    }
}

