/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.event;

import javax.baja.sys.BDouble;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BInputEvent;

public class BMouseEvent
extends BInputEvent {
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int MOUSE_PULSED = 510;
    public static final int MOUSE_DRAG_STARTED = 511;
    public static final int MOUSE_HOVER = 512;
    public static final Type TYPE = Sys.loadType(BMouseEvent.class);
    private double x;
    private double y;
    private int clickCount;
    private boolean isPopupTrigger;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BMouseEvent(int id, BWidget source, int modifiers, double x, double y, int clickCount, boolean isPopupTrigger) {
        super(id, source, modifiers);
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.isPopupTrigger = isPopupTrigger;
    }

    public BMouseEvent(int id, BWidget source, long when, int modifiers, double x, double y, int clickCount, boolean isPopupTrigger) {
        super(id, source, when, modifiers);
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.isPopupTrigger = isPopupTrigger;
    }

    public BMouseEvent() {
    }

    public boolean isButton1Down() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isButton2Down() {
        return (this.getModifiers() & 8) != 0;
    }

    public boolean isButton3Down() {
        return (this.getModifiers() & 4) != 0;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean isPopupTrigger() {
        return this.isPopupTrigger;
    }

    public String toString(Context cx) {
        if (this.getWidget() == null) {
            return "null";
        }
        String id = "?";
        switch (this.getId()) {
            case 501: {
                id = "MousePressed";
                break;
            }
            case 502: {
                id = "MouseReleased";
                break;
            }
            case 503: {
                id = "MouseMoved";
                break;
            }
            case 504: {
                id = "MouseEntered";
                break;
            }
            case 505: {
                id = "MouseExited";
                break;
            }
            case 506: {
                id = "MouseDragged";
                break;
            }
            case 507: {
                id = "MouseWheel";
                break;
            }
            case 510: {
                id = "MousePulsed";
                break;
            }
            case 511: {
                id = "MouseDragStarted";
                break;
            }
            case 512: {
                id = "MouseHover";
            }
        }
        return id + " src=" + this.getWidget().getType() + " pt=" + BDouble.toString((double)this.x, null) + "," + BDouble.toString((double)this.y, null) + " mods=" + this.modifiersToString();
    }
}

