/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.WindowPeer;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.event.BWindowEvent;

public class BWindow
extends BWidgetShell {
    public static final Topic windowEvent = BWindow.newTopic((int)0);
    public static final Type TYPE = Sys.loadType(BWindow.class);

    public BWindow(BWidget owner, BWidget content) {
        super(UiEnv.get().makeWindowPeer(owner));
        this.setContent(content);
    }

    public BWindow(BWidget owner) {
        super(UiEnv.get().makeWindowPeer(owner));
    }

    public BWindow() {
        super(UiEnv.get().makeWindowPeer(null));
    }

    BWindow(WindowPeer peer) {
        super(peer);
    }

    public IRectGeom getScreenBounds() {
        return this.getShellPeer().getScreenBounds();
    }

    public void setScreenBounds(double x, double y, double w, double h) {
        ((WindowPeer)this.getShellPeer()).setScreenBounds(x, y, w, h);
    }

    public void open(double x, double y, double w, double h) {
        this.setScreenBounds(x, y, w, h);
        this.open();
    }

    public void open() {
        ((WindowPeer)this.getShellPeer()).open();
    }

    public void close() {
        ((WindowPeer)this.getShellPeer()).close();
    }

    public boolean isShowing() {
        return ((WindowPeer)this.getShellPeer()).isShowing();
    }

    public void toFront() {
        ((WindowPeer)this.getShellPeer()).toFront();
    }

    public void toBack() {
        ((WindowPeer)this.getShellPeer()).toBack();
    }

    public void setBoundsCenteredOnScreen() {
        this.setBoundsCenteredOn(UiEnv.get().getScreenBounds(this));
    }

    public void setBoundsCenteredOn(IRectGeom rect) {
        Insets insets = UiEnv.get().getWindowInsets(this);
        this.computePreferredSize();
        double w = this.getPreferredWidth() + insets.left + insets.right;
        double h = this.getPreferredHeight() + insets.top + insets.bottom;
        double x = rect.x() + (rect.width() - w) / 2.0;
        double y = rect.y() + (rect.height() - h) / 2.0;
        IRectGeom screen = UiEnv.get().getScreenBounds(this);
        double sx = screen.x();
        double sy = screen.y();
        double sw = screen.width();
        double sh = screen.height();
        if (w > sw) {
            w = sw;
        }
        if (h > sh) {
            h = sh;
        }
        if (x + w > sx + sw) {
            x = sw - w;
        }
        if (y + h > sy + sh) {
            y = sh - h;
        }
        if (x < sx) {
            x = sx;
        }
        if (y < sy) {
            y = sy;
        }
        this.setScreenBounds(x, y, w, h);
    }

    public void setScreenSizeToPreferredSize() {
        Insets insets = UiEnv.get().getWindowInsets(this);
        this.computePreferredSize();
        double w = this.getPreferredWidth() + insets.left + insets.right;
        double h = this.getPreferredHeight() + insets.top + insets.bottom;
        IRectGeom cur = this.getScreenBounds();
        this.setScreenBounds(cur.x(), cur.y(), w, h);
    }

    public void fireWindowEvent(BWindowEvent event) {
        switch (event.getId()) {
            case 205: {
                this.windowActivated(event);
                break;
            }
            case 202: {
                this.windowClosed(event);
                break;
            }
            case 201: {
                this.windowClosing(event);
                break;
            }
            case 206: {
                this.windowDeactivated(event);
                break;
            }
            case 204: {
                this.windowDeiconified(event);
                break;
            }
            case 203: {
                this.windowIconified(event);
                break;
            }
            case 200: {
                this.windowOpened(event);
            }
        }
        this.fire(windowEvent, (BValue)event, null);
    }

    public void windowActivated(BWindowEvent event) {
    }

    public void windowClosed(BWindowEvent event) {
    }

    public void windowClosing(BWindowEvent event) {
    }

    public void windowDeactivated(BWindowEvent event) {
    }

    public void windowDeiconified(BWindowEvent event) {
    }

    public void windowIconified(BWindowEvent event) {
    }

    public void windowOpened(BWindowEvent event) {
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

