/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import java.lang.reflect.Method;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBinding;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.commands.HyperlinkCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BConverter;
import javax.baja.util.BFormat;

public class BValueBinding
extends BBinding {
    public static final Property hyperlink = BValueBinding.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property summary = BValueBinding.newProperty((int)0, (BValue)BFormat.make((String)"%displayName?typeDisplayName% = %.%"), null);
    public static final Property popupEnabled = BValueBinding.newProperty((int)0, (boolean)true, null);
    public static final Action updateStatus = BValueBinding.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BValueBinding.class);
    Clock.Ticket shellUpdateTicket;
    boolean isOver;
    MouseCursor restoreCursor;
    String toSummary = null;
    Exception lastGetOnWidgetException;

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    public BFormat getSummary() {
        return (BFormat)this.get(summary);
    }

    public void setSummary(BFormat v) {
        this.set(summary, (BValue)v, null);
    }

    public boolean getPopupEnabled() {
        return this.getBoolean(popupEnabled);
    }

    public void setPopupEnabled(boolean v) {
        this.setBoolean(popupEnabled, v, null);
    }

    public void updateStatus() {
        this.invoke(updateStatus, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void targetChanged() {
        super.targetChanged();
        this.toSummary = null;
    }

    @Override
    public BValue getOnWidget(Property prop) {
        block5: {
            BValue override = this.get(prop.getName());
            if (override instanceof BConverter) {
                BConverter converter = (BConverter)override;
                try {
                    BComponent component;
                    BObject from = this.get();
                    BValue to = prop.getDefaultValue().newCopy();
                    OrdTarget target = this.getTarget();
                    if (null != target && null != (component = target.getComponent())) {
                        BOrd navOrd = component.getNavOrd();
                        from.fw(205, (Object)navOrd, null, null, null);
                    }
                    if ((to = converter.convert(from, (BObject)to, this.getConverterContext())) instanceof BString) {
                        to = BString.make((String)TextUtil.replace((String)to.toString(), (String)"\\n", (String)"\n"));
                    }
                    return to;
                }
                catch (Exception e) {
                    if (this.lastGetOnWidgetException != null && this.lastGetOnWidgetException.getClass() == e.getClass()) break block5;
                    System.out.println("WARNING: " + converter.getType().getTypeName() + " cannot convert " + this.getWidget().getName() + "." + prop.getName());
                    System.out.println("  " + e);
                    this.lastGetOnWidgetException = e;
                }
            }
        }
        return null;
    }

    protected Context getConverterContext() {
        return this.getTarget();
    }

    @Override
    public void changedOnWidget(Property property, Context context) {
    }

    @Override
    public boolean invokedOnWidget(Action action, BValue value, Context context) {
        return super.invokedOnWidget(action, value, context);
    }

    @Override
    public boolean firedOnWidget(Topic topic, BValue event, Context context) {
        if (event instanceof BMouseEvent) {
            return this.handleMouseEvent((BMouseEvent)event);
        }
        return super.firedOnWidget(topic, event, context);
    }

    public void doUpdateStatus() {
        if (!this.isOver) {
            if (this.shellUpdateTicket != null && !this.shellUpdateTicket.isExpired()) {
                this.shellUpdateTicket.cancel();
            }
            return;
        }
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(this.toShowStatus());
        }
    }

    boolean handleMouseEvent(BMouseEvent event) {
        switch (event.getId()) {
            case 504: {
                return this.entered(event);
            }
            case 505: {
                return this.exited(event);
            }
            case 501: {
                return this.pressed(event);
            }
            case 502: {
                return this.released(event);
            }
        }
        return false;
    }

    boolean entered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = true;
        if (this.shellUpdateTicket == null || this.shellUpdateTicket.isExpired()) {
            this.shellUpdateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)1), (Action)updateStatus, null);
        }
        if (shell != null) {
            shell.showStatus(this.toShowStatus());
            this.restoreCursor = !this.getHyperlink().isNull() && UiEnv.get().hasMouse() ? this.getWidget().setMouseCursor(MouseCursor.hand) : null;
        }
        return true;
    }

    boolean exited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = false;
        if (this.shellUpdateTicket != null && !this.shellUpdateTicket.isExpired()) {
            this.shellUpdateTicket.cancel();
        }
        if (shell != null) {
            shell.showStatus("");
        }
        if (this.restoreCursor != null) {
            this.getWidget().setMouseCursor(this.restoreCursor);
        }
        return true;
    }

    boolean pressed(BMouseEvent event) {
        BMenu menu;
        if (this.isPopupTrigger(event) && (menu = this.getMenu()) != null) {
            return this.popup(event, menu);
        }
        return false;
    }

    boolean released(BMouseEvent event) {
        if (this.isPopupTrigger(event)) {
            BMenu menu = this.getMenu();
            if (menu != null) {
                return this.popup(event, menu);
            }
            if (UiEnv.get().hasMouse()) {
                return false;
            }
        }
        if (this.isOver && !this.getHyperlink().isNull()) {
            BOrd ord = this.getHyperlink();
            BWidgetShell shell = this.getShell();
            if (shell instanceof BIHyperlinkShell) {
                ((BIHyperlinkShell)((Object)shell)).hyperlink(new HyperlinkInfo(ord, event));
            }
            return true;
        }
        return false;
    }

    BMenu getMenu() {
        if (!this.getPopupEnabled()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        OrdTarget target = this.getTarget();
        BComponent component = target.getComponent();
        if (component == null) {
            return null;
        }
        try {
            Class cls = Sys.loadClass((String)"workbench", (String)"javax.baja.workbench.nav.menu.NavMenuUtil");
            Method method = cls.getMethod("makeActionsMenu", BWidget.class, BComponent.class);
            BMenu menu = (BMenu)method.invoke(null, this.getWidget(), component);
            return menu.isEnabled() ? menu : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    boolean popup(BMouseEvent event, BMenu menu) {
        if (this.addLinkCommand()) {
            menu.add("hyperlink", new HyperlinkCommand(this.getWidget(), UiLexicon.bajaui().getText("hyperlinkTo"), this.getHyperlink()));
            menu.add("hyperlinkSep", (BValue)new BSeparator());
            menu.reorderToTop(menu.getProperty("hyperlinkSep"));
            menu.reorderToTop(menu.getProperty("hyperlink"));
        }
        menu.open(this.getWidget(), event.getX(), event.getY());
        return true;
    }

    boolean isPopupTrigger(BMouseEvent event) {
        BWidget w = this.getWidget();
        boolean v = event.isPopupTrigger();
        if (w instanceof BAbstractButton) {
            return v;
        }
        return v || !UiEnv.get().hasMouse();
    }

    boolean addLinkCommand() {
        boolean v = true;
        v &= !UiEnv.get().hasMouse();
        v &= !this.getHyperlink().isNull();
        return v &= !(this.getWidget() instanceof BAbstractButton);
    }

    String toShowStatus() {
        String summary = this.toSummary();
        BOrd hyperlink = this.getHyperlink();
        if (hyperlink.isNull()) {
            return summary;
        }
        return "Link to " + hyperlink + " | " + summary;
    }

    String toSummary() {
        if (this.toSummary == null) {
            try {
                this.toSummary = this.isBound() ? this.getSummary().format((Object)this.get()) : "";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.toSummary = "";
            }
        }
        return this.toSummary;
    }
}

