/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractBar;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.toolbar.BIToolBar;

public class BToolBar
extends BAbstractBar
implements BIToolBar {
    public static final Property orientation = BToolBar.newProperty((int)0, (BValue)BOrientation.horizontal, null);
    public static final Type TYPE = Sys.loadType(BToolBar.class);
    private static final BIcon icon = BIcon.std((String)"widgets/toolbar.png");

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation v) {
        this.set(orientation, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public BAbstractButton add(String name, Command command) {
        BAbstractButton b = BAbstractButton.make(command, false, true);
        b.setFocusTraversable(false);
        this.add(name, (BValue)b, null);
        return b;
    }

    @Override
    public BAbstractButton addButton(String buttonName, Command command) {
        return this.add(buttonName, command);
    }

    @Override
    public BAbstractButton getButton(String buttonName) {
        return (BAbstractButton)this.get(buttonName);
    }

    @Override
    public BAbstractButton removeButton(String buttonName) {
        BAbstractButton btnToRemove = (BAbstractButton)this.get(buttonName);
        this.remove(buttonName);
        return btnToRemove;
    }

    @Override
    public void removeAllButtons() {
        this.removeAll();
    }

    @Override
    public void addSeparator() {
        this.add("sep?", (BValue)new BSeparator());
    }

    @Override
    public BWidget asWidget() {
        return this;
    }

    public void added(Property prop, Context context) {
        super.added(prop, context);
        BValue value = this.get(prop);
        if (value instanceof BAbstractButton) {
            ((BAbstractButton)value).setButtonStyle(BButtonStyle.toolBar);
        }
    }

    @Override
    public void computePreferredSize() {
        BInsets insets = Theme.toolBar().getInsets();
        double gap = Theme.toolBar().getGap();
        double w = 0.0;
        double h = 0.0;
        BOrientation orientation = this.getOrientation();
        BWidget[] items = this.getChildWidgets();
        for (int i = 0; i < items.length; ++i) {
            BWidget item = items[i];
            item.computePreferredSize();
            if (orientation == BOrientation.horizontal) {
                w += item.getPreferredWidth() + gap;
                h = Math.max(h, item.getPreferredHeight());
                continue;
            }
            w = Math.max(w, item.getPreferredWidth());
            h += item.getPreferredHeight() + gap;
        }
        this.setPreferredSize(w += insets.left + insets.right, h += insets.top + insets.bottom);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        BInsets insets = Theme.toolBar().getInsets();
        double gap = Theme.toolBar().getGap();
        double x = insets.left;
        double y = insets.top;
        double w = this.getWidth() - insets.left - insets.right;
        double h = this.getHeight() - insets.top - insets.bottom;
        BOrientation orientation = this.getOrientation();
        BWidget[] items = this.getChildWidgets();
        for (int i = 0; i < items.length; ++i) {
            BWidget item = items[i];
            if (item instanceof BSeparator) {
                if (orientation == BOrientation.horizontal) {
                    ((BSeparator)item).setOrientation(BOrientation.vertical);
                } else {
                    ((BSeparator)item).setOrientation(BOrientation.horizontal);
                }
            }
            if (orientation == BOrientation.horizontal) {
                item.setBounds(x, y, item.getPreferredWidth(), h);
                x += item.getPreferredWidth() + gap;
                continue;
            }
            item.setBounds(x, y, w, item.getPreferredHeight());
            y += item.getPreferredHeight() + gap;
        }
    }

    @Override
    public void paint(Graphics g) {
        Theme.toolBar().paintBackground(g, this);
        this.paintChildren(g);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

