/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.menu.BIToggleMenuItem;

public abstract class BToggleMenuItem
extends BActionMenuItem
implements BIToggleMenuItem {
    public static final Property selected = BToggleMenuItem.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BToggleMenuItem.class);

    public boolean getSelected() {
        return this.getBoolean(selected);
    }

    public void setSelected(boolean v) {
        this.setBoolean(selected, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BToggleMenuItem(String text, BAccelerator accelerator, boolean selected) {
        super(text, accelerator);
        this.setSelected(selected);
    }

    public BToggleMenuItem(String text, boolean selected) {
        super(text);
        this.setSelected(selected);
    }

    public BToggleMenuItem(String text) {
        super(text);
    }

    public BToggleMenuItem(ToggleCommand command) {
        super(command);
    }

    public BToggleMenuItem() {
    }

    @Override
    public boolean isSelected() {
        return this.getSelected();
    }

    @Override
    public boolean isCheckBoxItem() {
        return false;
    }

    @Override
    public boolean isRadioButtonItem() {
        return false;
    }

    @Override
    public ToggleCommandGroup getToggleGroup() {
        return ((ToggleCommand)this.getCommand()).getGroup();
    }

    @Override
    public void doInvokeAction(CommandEvent event) {
        this.setSelected(!this.getSelected());
        super.doInvokeAction(event);
    }

    @Override
    public void setCommand(Command command, boolean useLabel, boolean useIcon, boolean useAcc) {
        if (command != null) {
            if (!(command instanceof ToggleCommand)) {
                throw new IllegalArgumentException("Not ToggleCommand!");
            }
            this.setSelected(((ToggleCommand)command).isSelected());
        }
        super.setCommand(command, useLabel, useIcon, useAcc);
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == selected && this.command != null) {
            ((ToggleCommand)this.command).setSelected(this.getSelected());
        }
    }
}

