/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.AbstractButtonTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.ToggleCommand;

public class BToggleButton
extends BAbstractButton {
    public static final Property selected = BToggleButton.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BToggleButton.class);
    private static final BIcon icon = BIcon.std((String)"widgets/toggleButton.png");

    public boolean getSelected() {
        return this.getBoolean(selected);
    }

    public void setSelected(boolean v) {
        this.setBoolean(selected, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BToggleButton(String text) {
        this.setText(text);
    }

    public BToggleButton(BImage image, String text) {
        this.setText(text);
        this.setImage(image);
    }

    public BToggleButton(String text, boolean selected) {
        this.setText(text);
        this.setSelected(selected);
    }

    public BToggleButton(BImage image, String text, boolean selected) {
        this.setText(text);
        this.setImage(image);
        this.setSelected(selected);
    }

    public BToggleButton(ToggleCommand cmd, boolean useLabel, boolean useIcon) {
        this.setCommand(cmd, useLabel, useIcon);
    }

    public BToggleButton(Command cmd) {
        this.setCommand(cmd, true, true);
    }

    public BToggleButton() {
    }

    public boolean isSelected() {
        return this.getBoolean(selected);
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(Command command, boolean useLabel, boolean useIcon) {
        if (command != null) {
            if (!(command instanceof ToggleCommand)) {
                throw new IllegalArgumentException("Not ToggleCommand!");
            }
            this.setSelected(((ToggleCommand)command).isSelected());
        }
        super.setCommand(command, useLabel, useIcon);
    }

    @Override
    public void doInvokeAction(CommandEvent event) {
        this.setSelected(!this.getSelected());
        super.doInvokeAction(event);
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == selected) {
            boolean sel = this.getSelected();
            if (this.command != null && ((ToggleCommand)this.command).isSelected() != sel) {
                ((ToggleCommand)this.command).setSelected(sel);
                this.command.invoke();
            }
            StyleUtils.toggleStyleClass(this, "selected", this.isSelected());
        }
    }

    @Override
    AbstractButtonTheme buttonTheme() {
        return Theme.toggleButton();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

