/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.Theme;
import java.text.NumberFormat;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BSliderEvent;

public class BSlider
extends BWidget {
    public static final Property min = BSlider.newProperty((int)0, (int)0, null);
    public static final Property max = BSlider.newProperty((int)0, (int)100, null);
    public static final Property increment = BSlider.newProperty((int)0, (int)1, null);
    public static final Property value = BSlider.newProperty((int)0, (int)50, null);
    public static final Property orientation = BSlider.newProperty((int)0, (BValue)BOrientation.horizontal, null);
    public static final Property trackBrush = BSlider.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property thumbBrush = BSlider.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Topic valueModified = BSlider.newTopic((int)0, null);
    public static final Topic actionPerformed = BSlider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BSlider.class);
    private static final BIcon icon = BIcon.std((String)"widgets/slider.png");
    protected double thumbPoint;
    protected double viewSize;
    protected double realSize;
    protected RectGeom thumb = new RectGeom();
    protected RectGeom track = new RectGeom();

    public double getMin() {
        return this.getDouble(min);
    }

    public void setMin(double v) {
        this.setDouble(min, v, null);
    }

    public double getMax() {
        return this.getDouble(max);
    }

    public void setMax(double v) {
        this.setDouble(max, v, null);
    }

    public double getIncrement() {
        return this.getDouble(increment);
    }

    public void setIncrement(double v) {
        this.setDouble(increment, v, null);
    }

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation v) {
        this.set(orientation, (BValue)v, null);
    }

    public BBrush getTrackBrush() {
        return (BBrush)this.get(trackBrush);
    }

    public void setTrackBrush(BBrush v) {
        this.set(trackBrush, (BValue)v, null);
    }

    public BBrush getThumbBrush() {
        return (BBrush)this.get(thumbBrush);
    }

    public void setThumbBrush(BBrush v) {
        this.set(thumbBrush, (BValue)v, null);
    }

    public void fireValueModified(BSliderEvent event) {
        this.fire(valueModified, (BValue)event, null);
    }

    public void fireActionPerformed(BSliderEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSlider() {
    }

    public BSlider(double min, double max) {
        this.setMin(min);
        this.setMax(max);
        if (this.getValue() < min || this.getValue() > max) {
            this.setValue((max + min) / 2.0);
        }
    }

    public BSlider(double min, double max, double inc, double val) {
        this.setMin(min);
        this.setMax(max);
        this.setIncrement(inc);
        this.setValue(val);
        if (this.getValue() < min || this.getValue() > max) {
            this.setValue((max + min) / 2.0);
        }
    }

    public BSlider(BOrientation orient, double min, double max, double inc, double val) {
        this.setOrientation(orient);
        this.setMin(min);
        this.setMax(max);
        this.setIncrement(inc);
        this.setValue(val);
        if (this.getValue() < min || this.getValue() > max) {
            this.setValue((max + min) / 2.0);
        }
    }

    @Override
    public void computePreferredSize() {
        double size = Theme.slider().getFixedWidth(this);
        if (this.isHorizontal()) {
            this.setPreferredSize(100.0, size);
        } else {
            this.setPreferredSize(size, 100.0);
        }
    }

    @Override
    public void doLayout(BWidget[] kids) {
        if (this.isHorizontal()) {
            this.layoutHorizontally();
        } else {
            this.layoutVertically();
        }
    }

    public void layoutHorizontally() {
        this.thumb.set(0.0, 0.0, Theme.slider().getThumbWidth(this), this.getHeight() - 1.0);
        this.track.set(this.thumb.width / 2.0, 4.0, this.getWidth() - this.thumb.width, 6.0);
        this.thumbPoint = (int)(this.thumb.width / 2.0 + 0.5);
        this.viewSize = this.getWidth() - this.thumb.width;
        this.realSize = this.getMax() - this.getMin();
    }

    public void layoutVertically() {
        this.thumb.set(0.0, 0.0, this.getWidth() - 1.0, Theme.slider().getThumbWidth(this));
        this.track.set(4.0, this.thumb.height / 2.0, 6.0, this.getHeight() - this.thumb.height);
        this.thumbPoint = (int)(this.thumb.height / 2.0 + 0.5);
        this.viewSize = this.getHeight() - this.thumb.height;
        this.realSize = this.getMax() - this.getMin();
    }

    public boolean isHorizontal() {
        return this.getOrientation() == BOrientation.horizontal;
    }

    @Override
    public void paint(Graphics g) {
        double v = this.getValue();
        if (v < this.getMin()) {
            v = this.getMin();
        }
        if (v > this.getMax()) {
            v = this.getMax();
        }
        int pos = (int)((v - this.getMin()) / this.realSize * this.viewSize);
        if (!this.isHorizontal()) {
            pos = (int)(this.viewSize - (double)pos);
        }
        if (this.isHorizontal()) {
            this.thumb.set((double)pos, 0.0, this.thumb.width, this.thumb.height);
        } else {
            this.thumb.set(0.0, (double)pos, this.thumb.width, this.thumb.height);
        }
        SliderTheme theme = Theme.slider();
        theme.paintTrack(g, this, this.track);
        theme.paintThumb(g, this, this.thumb);
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        double v = this.getValue();
        if (v < this.getMin()) {
            v = this.getMin();
        }
        if (v > this.getMax()) {
            v = this.getMax();
        }
        String s = this.valueToString(v);
        UiEnv.get().openBubbleHelp(this, event.getX(), event.getY() + 24.0, s);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        UiEnv.get().closeBubbleHelp();
        this.fireActionPerformed(new BSliderEvent(602, this, this.getValue()));
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        double inc;
        double newValue;
        double temp;
        double viewPos;
        double d = viewPos = this.isHorizontal() ? event.getX() - this.thumbPoint : this.getHeight() - event.getY() - this.thumbPoint;
        if (viewPos < 0.0) {
            viewPos = 0.0;
        }
        if (viewPos > this.viewSize) {
            viewPos = this.viewSize;
        }
        newValue = (temp = (newValue = viewPos / this.viewSize * this.realSize + this.getMin()) % (inc = this.getIncrement())) > inc / 2.0 ? newValue - temp + inc : (newValue -= temp);
        this.setValue(newValue);
        this.fireValueModified(new BSliderEvent(602, this, this.getValue()));
        this.repaint();
        String s = this.valueToString(newValue);
        UiEnv.get().updateBubbleHelp(this, event.getX(), event.getY() + 24.0, s);
    }

    private String valueToString(double v) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(3);
        return format.format(v);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

