/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import java.util.Vector;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractBar;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.util.UiLexicon;

public class BMenu
extends BAbstractBar
implements BIMenu {
    public static final Property visible = BMenu.newProperty((int)0, (boolean)false);
    public static final Property text = BMenu.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BMenu.class);
    private static final BIcon icon = BIcon.std((String)"widgets/menu.png");
    static double acceleratorGap = 6.0;
    RectGeom menuBarRect = new RectGeom(0.0, 0.0, 0.0, 0.0);
    char shortcut = '\u0000';
    private BWidget owner;
    private double acceleratorX;
    private BMenuItem selected;
    private boolean fitToScreen = false;

    @Override
    public String getText() {
        return this.getString(text);
    }

    public void setText(String v) {
        this.setString(text, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BMenu(String text) {
        this.setText(text);
    }

    public BMenu() {
    }

    @Override
    public BWidget asWidget() {
        return this;
    }

    public BMenuItem add(String name, Command command) {
        ToggleCommand toggleCommmand;
        BActionMenuItem item = command instanceof ToggleCommand ? ((toggleCommmand = (ToggleCommand)command).getGroup() != null ? new BRadioButtonMenuItem(toggleCommmand) : new BCheckBoxMenuItem(toggleCommmand)) : new BActionMenuItem(command);
        this.add(name, (BValue)item, null);
        return item;
    }

    @Override
    public void computePreferredSize() {
        this.fitToScreen();
        double maxText = 0.0;
        double maxAcc = 0.0;
        double h = 0.0;
        BWidget[] items = this.getChildWidgets();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] instanceof BSeparator) {
                BSeparator sep = (BSeparator)items[i];
                sep.computePreferredSize();
                h += sep.getPreferredHeight();
                continue;
            }
            BMenuItem item = (BMenuItem)items[i];
            item.computePreferredSize();
            maxText = Math.max(maxText, item.textWidth);
            maxAcc = Math.max(maxAcc, item.acceleratorWidth);
            h += item.getPreferredHeight();
        }
        BInsets mi = Theme.menu().getInsets();
        BInsets ii = Theme.menuItem().getInsets();
        double w = maxText + maxAcc + acceleratorGap + mi.left + mi.right + ii.left + ii.right;
        this.setPreferredSize(w, h += mi.top + mi.bottom);
        this.acceleratorX = ii.left + maxText + acceleratorGap;
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.fitToScreen();
        BInsets insets = Theme.menu().getInsets();
        double x = insets.left;
        double y = insets.top;
        double w = this.getWidth() - insets.left - insets.right;
        for (int i = 0; i < kids.length; ++i) {
            BWidget kid = kids[i];
            kid.setBounds(x, y, w, kid.getPreferredHeight());
            y += kid.getHeight();
            if (kid instanceof BMenuItem) {
                ((BMenuItem)kid).acceleratorX = this.acceleratorX;
                continue;
            }
            ((BSeparator)kid).setOrientation(BOrientation.horizontal);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.fitToScreen();
        this.computeShortcutKeys();
        Theme.menu().paintBackground(g, this);
        this.paintChildren(g);
    }

    @Override
    public String getStyleSelector() {
        return "menu";
    }

    private void computeShortcutKeys() {
        if (this.hasFocus()) {
            int k;
            int letterIndex;
            int i;
            BMenuItem[] items = (BMenuItem[])this.getChildren(BMenuItem.class);
            boolean[] letters = new boolean[26];
            for (i = 0; i < items.length; ++i) {
                if (items[i].shortcut <= '\u0000') continue;
                letters[items[i].shortcut - 97] = true;
            }
            for (i = 0; i < items.length; ++i) {
                int character;
                if (items[i].getAccelerator().isNull()) continue;
                int keyCode = items[i].getAccelerator().getKeyCode();
                switch (keyCode) {
                    case 65: {
                        character = 97;
                        break;
                    }
                    case 66: {
                        character = 98;
                        break;
                    }
                    case 67: {
                        character = 99;
                        break;
                    }
                    case 68: {
                        character = 100;
                        break;
                    }
                    case 69: {
                        character = 101;
                        break;
                    }
                    case 70: {
                        character = 102;
                        break;
                    }
                    case 71: {
                        character = 103;
                        break;
                    }
                    case 72: {
                        character = 104;
                        break;
                    }
                    case 73: {
                        character = 105;
                        break;
                    }
                    case 74: {
                        character = 106;
                        break;
                    }
                    case 75: {
                        character = 107;
                        break;
                    }
                    case 76: {
                        character = 108;
                        break;
                    }
                    case 77: {
                        character = 109;
                        break;
                    }
                    case 78: {
                        character = 110;
                        break;
                    }
                    case 79: {
                        character = 111;
                        break;
                    }
                    case 80: {
                        character = 112;
                        break;
                    }
                    case 81: {
                        character = 113;
                        break;
                    }
                    case 82: {
                        character = 114;
                        break;
                    }
                    case 83: {
                        character = 115;
                        break;
                    }
                    case 84: {
                        character = 116;
                        break;
                    }
                    case 85: {
                        character = 117;
                        break;
                    }
                    case 86: {
                        character = 118;
                        break;
                    }
                    case 87: {
                        character = 119;
                        break;
                    }
                    case 88: {
                        character = 120;
                        break;
                    }
                    case 89: {
                        character = 121;
                        break;
                    }
                    case 90: {
                        character = 122;
                        break;
                    }
                    default: {
                        character = 0;
                    }
                }
                if (character == 0 || letters[letterIndex = character - 97] || items[i].getText().toLowerCase().indexOf(character) <= -1) continue;
                items[i].shortcut = (char)character;
                letters[letterIndex] = true;
            }
            block30: for (i = 0; i < items.length; ++i) {
                if (items[i].shortcut != '\u0000') continue;
                String[] words = TextUtil.split((String)items[i].getText().toLowerCase(), (char)' ');
                for (k = 0; k < words.length; ++k) {
                    if (words[k].length() <= 0 || words[k].charAt(0) < 'a' || words[k].charAt(0) > 'z' || letters[letterIndex = words[k].charAt(0) - 97]) continue;
                    items[i].shortcut = words[k].charAt(0);
                    letters[letterIndex] = true;
                    continue block30;
                }
            }
            block32: for (i = 0; i < items.length; ++i) {
                if (items[i].shortcut != '\u0000') continue;
                String text = items[i].getText().toLowerCase();
                for (k = 0; k < text.length(); ++k) {
                    if (text.charAt(k) < 'a' || text.charAt(k) > 'z' || letters[letterIndex = text.charAt(k) - 97]) continue;
                    items[i].shortcut = text.charAt(k);
                    letters[letterIndex] = true;
                    continue block32;
                }
            }
        } else {
            BMenuItem[] items = (BMenuItem[])this.getChildren(BMenuItem.class);
            for (int i = 0; i < items.length; ++i) {
                items[i].shortcut = '\u0000';
            }
        }
    }

    private void fitToScreen() {
        BWidget[] items;
        double insetHeight;
        if (this.fitToScreen) {
            return;
        }
        this.fitToScreen = true;
        double maxHeight = UiEnv.get().getScreenBounds(null).height();
        boolean adjustMaxHeight = true;
        BInsets mi = Theme.menu().getInsets();
        double h = insetHeight = mi.top + mi.bottom;
        BMenu moreMenu = null;
        for (BWidget item : items = this.getChildWidgets()) {
            item.computePreferredSize();
            double currentHeight = item.getPreferredHeight();
            if (adjustMaxHeight && item.getType().is(BMenuItem.TYPE)) {
                adjustMaxHeight = false;
                maxHeight -= currentHeight * 3.0;
            }
            if (currentHeight + h >= maxHeight) {
                BMenu newMoreMenu = (BMenu)this.getType().getInstance();
                newMoreMenu.setText(UiLexicon.bajaui().getText("menu.more.label"));
                newMoreMenu.fitToScreen = true;
                if (moreMenu == null) {
                    this.add("more?", (BValue)new BSubMenuItem(newMoreMenu));
                } else {
                    moreMenu.add("more?", (BValue)new BSubMenuItem(newMoreMenu));
                }
                moreMenu = newMoreMenu;
                h = insetHeight;
                if (item.getType().is(BSeparator.TYPE)) {
                    this.remove(item.getName());
                    continue;
                }
            }
            if (moreMenu != null) {
                String name = item.getName();
                this.remove(name);
                moreMenu.add(name, (BValue)item);
            }
            h += currentHeight;
        }
    }

    public BMenuItem[] getMenuItems() {
        Vector<BValue> v = new Vector<BValue>();
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            BValue obj = c.get();
            if (!(obj instanceof BMenuItem)) continue;
            v.addElement(obj);
        }
        Object[] items = new BMenuItem[v.size()];
        v.copyInto(items);
        return items;
    }

    @Override
    public int getItemCount() {
        return this.getMenuItems().length;
    }

    @Override
    public void addItem(String menuItemName, BIMenuItem menuItem) {
        this.add(menuItemName, (BValue)menuItem.asWidget());
    }

    @Override
    public void addItemToFront(String menuItemName, BIMenuItem menuItem) {
        this.reorderToTop(this.add(menuItemName, (BValue)menuItem.asWidget()));
    }

    @Override
    public BIMenuItem addItem(String menuItemName, Command menuItemCommand) {
        return this.add(menuItemName, menuItemCommand);
    }

    @Override
    public BMenu getSubMenu(String name) {
        return ((BSubMenuItem)this.get(name)).getMenu();
    }

    @Override
    public BMenu removeSubMenu(String name) {
        BSubMenuItem item = (BSubMenuItem)this.get(name);
        BMenu menu = item.getMenu();
        this.remove((BComplex)item);
        item.setMenu(new BMenu());
        return menu;
    }

    @Override
    public BIMenuItem removeItem(String name) {
        BIMenuItem item = this.getItem(name);
        if (item != null) {
            this.remove((BComplex)item.asWidget());
        }
        return item;
    }

    @Override
    public BIMenuItem getItem(String menuItemName) {
        return (BIMenuItem)this.get(menuItemName);
    }

    @Override
    public void retainItems(String[] menuItems) {
        this.keep(menuItems);
    }

    @Override
    public void addSeparator() {
        this.add("sep?", (BValue)new BSeparator());
    }

    @Override
    public void addSeparatorToFront() {
        this.reorderToTop(this.add("sep?", (BValue)new BSeparator()));
    }

    @Override
    public void update() {
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public boolean isOpen() {
        return UiEnv.get().isPopupOpen(this);
    }

    public void open(BWidget owner, double x, double y) {
        int i;
        this.update();
        boolean showAccelerators = false;
        for (BWidget p = owner; p != null; p = p.getParent()) {
            if (p.fw(305) == null) continue;
            showAccelerators = true;
            break;
        }
        UiEnv.get().openPopup(this, owner, x, y);
        UiEnv.get().setPopupOpacity(this, Theme.menu().getFrameOpacity());
        this.selected = null;
        BMenuItem[] items = this.getMenuItems();
        for (i = 0; i < items.length; ++i) {
            items[i].opening(this, showAccelerators);
        }
        for (i = 0; i < items.length; ++i) {
            if (!items[i].isEnabled()) continue;
            this.select(items[i]);
            break;
        }
        this.owner = owner;
    }

    public void open(BMouseEvent event) {
        this.open(event.getWidget(), event.getX(), event.getY());
    }

    void close() {
        UiEnv.get().closePopup(this);
        if (this.owner instanceof BMenuBar) {
            this.owner.requestFocus();
        }
    }

    void select(BMenuItem item) {
        if (this.selected != null) {
            this.selected.unselect();
        }
        item.select();
        this.selected = item;
        this.insureSubItemPathSelected();
    }

    void unselect(BMenuItem item) {
        item.unselect();
        this.selected = null;
    }

    void insureSubItemPathSelected() {
        BComplex parent = this.getParent();
        if (parent instanceof BSubMenuItem) {
            BSubMenuItem item = (BSubMenuItem)parent;
            BMenu menu = (BMenu)item.getParent();
            menu.select(item);
        }
    }

    void moveSelectionUp() {
        BMenuItem[] items = this.getMenuItems();
        int s = this.itemIndexOf(items, this.selected);
        for (int i = s - 1; i >= 0; --i) {
            if (!items[i].isEnabled()) continue;
            this.select(items[i]);
            return;
        }
        this.close();
    }

    void moveSelectionDown() {
        BMenuItem[] items = this.getMenuItems();
        int s = this.itemIndexOf(items, this.selected);
        for (int i = s + 1; i < items.length; ++i) {
            if (!items[i].isEnabled()) continue;
            this.select(items[i]);
            break;
        }
    }

    int itemIndexOf(BMenuItem[] items, BMenuItem item) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != item) continue;
            return i;
        }
        return -1;
    }

    void moveSelectionLeft() {
        BWidget parent = this.getParentWidget();
        if (parent instanceof BSubMenuItem) {
            ((BSubMenuItem)parent).closeMenu();
        } else if (parent instanceof BMenuBar) {
            ((BMenuBar)parent).openLeft();
        }
    }

    void moveSelectionRight() {
        BWidget parent = this.getParentWidget();
        if (this.selected instanceof BSubMenuItem) {
            ((BSubMenuItem)this.selected).openMenu();
        } else if (parent instanceof BMenuBar) {
            ((BMenuBar)parent).openRight();
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void keyReleased(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        block0 : switch (event.getKeyCode()) {
            case 27: {
                this.close();
                event.consume();
                break;
            }
            case 38: {
                this.moveSelectionUp();
                event.consume();
                break;
            }
            case 40: {
                this.moveSelectionDown();
                event.consume();
                break;
            }
            case 37: {
                this.moveSelectionLeft();
                event.consume();
                break;
            }
            case 39: {
                this.moveSelectionRight();
                event.consume();
                break;
            }
            case 10: {
                if (this.selected != null) {
                    this.selected.doClick(event);
                }
                event.consume();
                break;
            }
            default: {
                if (event.getKeyChar() < 'a' || event.getKeyChar() > 'z') break;
                BMenuItem[] items = (BMenuItem[])this.getChildren(BMenuItem.class);
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].shortcut != event.getKeyChar()) continue;
                    this.select(items[i]);
                    items[i].doClick(event);
                    event.consume();
                    break block0;
                }
            }
        }
    }

    @Override
    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public static interface MenuCloseListener {
        public void menuClosed(BMenu var1);
    }
}

