/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.BListDropDownDisplay;
import javax.baja.sys.Action;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;

public class BListDropDown
extends BDropDown {
    public static final Action listActionPerformed = BListDropDown.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BListDropDown.class);
    int index = -1;

    public void listActionPerformed() {
        this.invoke(listActionPerformed, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BListDropDown() {
        BListDropDownDisplay display = new BListDropDownDisplay();
        BList list = new BList();
        this.setDisplayWidget(display);
        this.setDropDownWidget(list);
        list.setVisible(false);
        list.setMultipleSelection(false);
        list.setController(new ListController(){

            @Override
            public void itemEntered(BMouseEvent event, int index) {
                this.getSelection().deselectAll();
                this.getSelection().select(index);
            }

            @Override
            public void mouseDragged(BMouseEvent event) {
                this.mouseMoved(event);
            }
        });
        this.linkTo(list, (Slot)BList.actionPerformed, (Slot)listActionPerformed);
        this.linkTo(list, (Slot)BList.cancelled, (Slot)closeDropDown);
    }

    public BList getList() {
        return (BList)this.getDropDownWidget();
    }

    public int getSelectedIndex() {
        return this.getList().getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.getList().getSelectedItem();
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.getList().getSelectedIndex();
        if (oldIndex != index) {
            this.getList().setSelectedIndex(index);
            this.fireValueModified(new BWidgetEvent(1, this));
        }
    }

    public void setSelectedItem(Object item) {
        Object oldItem = this.getList().getSelectedItem();
        if (oldItem != item) {
            this.getList().setSelectedItem(item);
            this.fireValueModified(new BWidgetEvent(1, this));
        }
    }

    @Override
    public void doOpenDropDown() {
        this.index = this.getList().getSelectedIndex();
        super.doOpenDropDown();
    }

    @Override
    public void doCloseDropDown() {
        super.doCloseDropDown();
        this.getList().setSelectedIndex(this.index);
        this.getDisplayWidget().requestFocus();
    }

    public void doListActionPerformed() {
        this.index = this.getList().getSelectedIndex();
        this.fireValueModified(new BWidgetEvent(1, this));
        this.closeDropDown();
        this.repaint();
    }
}

