/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.parser.Parser;
import com.tridium.ui.theme.Theme;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBorder
extends BSimple {
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int DOTTED = 2;
    public static final int DASHED = 3;
    public static final int GROOVE = 4;
    public static final int RIDGE = 5;
    public static final int INSET = 6;
    public static final int OUTSET = 7;
    public static final BBorder none = BBorder.make(0);
    public static final BBorder solid = BBorder.make(1);
    public static final BBorder dotted = BBorder.make(2);
    public static final BBorder dashed = BBorder.make(3);
    public static final BBorder groove = BBorder.make(4);
    public static final BBorder ridge = BBorder.make(5);
    public static final BBorder inset = BBorder.make(6);
    public static final BBorder outset = BBorder.make(7);
    public static final BBorder DEFAULT = BBorder.make(1.0, 1, BColor.black.toBrush());
    public static final BBorder NULL = BBorder.make(0.0, 0, BBrush.NULL);
    public static final Type TYPE = Sys.loadType(BBorder.class);
    private static final BBrush shadow = Theme.widget().getControlShadow();
    private static final BBrush hlight = Theme.widget().getControlHighlight();
    private static final int cap = 102;
    private static final int join = 203;
    private static final double[] _dotted = new double[]{2.0, 2.0};
    private static final double[] _dashed = new double[]{8.0, 2.0};
    private static final BPen solidPen = BPen.make((double)1.0, (int)102, (int)203, null);
    private static final BPen dottedPen = BPen.make((double)1.0, (int)102, (int)203, (double[])_dotted);
    private static final BPen dashedPen = BPen.make((double)1.0, (int)102, (int)203, (double[])_dashed);
    public final double topWidth;
    public final double leftWidth;
    public final double bottomWidth;
    public final double rightWidth;
    public final int topStyle;
    public final int leftStyle;
    public final int bottomStyle;
    public final int rightStyle;
    public final BBrush topBrush;
    public final BBrush leftBrush;
    public final BBrush bottomBrush;
    public final BBrush rightBrush;

    public static BBorder make(int style) {
        return BBorder.make(1.0, style, BColor.black.toBrush());
    }

    public static BBorder make(BBorder border, BBrush brush) {
        return BBorder.make(border.topWidth, border.topStyle, brush, border.rightWidth, border.rightStyle, brush, border.bottomWidth, border.bottomStyle, brush, border.leftWidth, border.leftStyle, brush);
    }

    public static BBorder make(double width, int style, BBrush brush) {
        return new BBorder(width, style, brush, width, style, brush, width, style, brush, width, style, brush);
    }

    public static BBorder make(double topWidth, int topStyle, BBrush topBrush, double rightWidth, int rightStyle, BBrush rightBrush, double bottomWidth, int bottomStyle, BBrush bottomBrush, double leftWidth, int leftStyle, BBrush leftBrush) {
        return new BBorder(topWidth, topStyle, topBrush, rightWidth, rightStyle, rightBrush, bottomWidth, bottomStyle, bottomBrush, leftWidth, leftStyle, leftBrush);
    }

    public static BBorder make(String s) {
        if (s.equals("null")) {
            return NULL;
        }
        Parser p = new Parser(s);
        Side top = new Side();
        Side right = new Side();
        Side bottom = new Side();
        Side left = new Side();
        boolean foundSide = false;
        for (int i = 0; i < 4 && p.cur.type == 18; ++i) {
            if (p.cur.str.equals("top")) {
                p.match(18);
                top = BBorder.parseSide(p);
                p.match(8);
                foundSide = true;
                continue;
            }
            if (p.cur.str.equals("right")) {
                p.match(18);
                right = BBorder.parseSide(p);
                p.match(8);
                foundSide = true;
                continue;
            }
            if (p.cur.str.equals("bottom")) {
                p.match(18);
                bottom = BBorder.parseSide(p);
                p.match(8);
                foundSide = true;
                continue;
            }
            if (!p.cur.str.equals("left")) continue;
            p.match(18);
            left = BBorder.parseSide(p);
            p.match(8);
            foundSide = true;
        }
        if (!foundSide) {
            Side side = BBorder.parseSide(p);
            return BBorder.make(side.width, side.style, side.brush);
        }
        return new BBorder(top.width, top.style, top.brush, right.width, right.style, right.brush, bottom.width, bottom.style, bottom.brush, left.width, left.style, left.brush);
    }

    private static Side parseSide(Parser p) {
        Side side = new Side();
        side.width = -1.0;
        side.style = -1;
        side.brush = null;
        for (int i = 0; i < 3; ++i) {
            if (side.width == -1.0) {
                side.width = BBorder.parseWidth(p);
            }
            if (side.style == -1) {
                side.style = BBorder.parseStyle(p);
            }
            if (side.brush != null) continue;
            side.brush = BBorder.parseBrush(p);
        }
        if (side.width == -1.0) {
            side.width = 1.0;
        }
        if (side.style == -1) {
            side.style = 1;
        }
        if (side.brush == null) {
            side.brush = BColor.black.toBrush();
        }
        return side;
    }

    private static double parseWidth(Parser p) {
        if (p.cur.type == 19) {
            return p.matchNum();
        }
        return -1.0;
    }

    private static int parseStyle(Parser p) {
        if (p.cur.type == 15) {
            String s = p.cur.str;
            if (s.equals("none")) {
                p.consume();
                return 0;
            }
            if (s.equals("solid")) {
                p.consume();
                return 1;
            }
            if (s.equals("dotted")) {
                p.consume();
                return 2;
            }
            if (s.equals("dashed")) {
                p.consume();
                return 3;
            }
            if (s.equals("groove")) {
                p.consume();
                return 4;
            }
            if (s.equals("ridge")) {
                p.consume();
                return 5;
            }
            if (s.equals("inset")) {
                p.consume();
                return 6;
            }
            if (s.equals("outset")) {
                p.consume();
                return 7;
            }
        }
        return -1;
    }

    private static BBrush parseBrush(Parser p) {
        if (p.cur.type == 15 || p.cur.type == 17 || p.cur.type == 18) {
            return p.parseBrush();
        }
        return null;
    }

    private BBorder(double topWidth, int topStyle, BBrush topBrush, double rightWidth, int rightStyle, BBrush rightBrush, double bottomWidth, int bottomStyle, BBrush bottomBrush, double leftWidth, int leftStyle, BBrush leftBrush) {
        this.topWidth = this.w(topStyle, topWidth);
        this.topStyle = topStyle;
        this.topBrush = topBrush;
        this.rightWidth = this.w(rightStyle, rightWidth);
        this.rightStyle = rightStyle;
        this.rightBrush = rightBrush;
        this.bottomWidth = this.w(bottomStyle, bottomWidth);
        this.bottomStyle = bottomStyle;
        this.bottomBrush = bottomBrush;
        this.leftWidth = this.w(leftStyle, leftWidth);
        this.leftStyle = leftStyle;
        this.leftBrush = leftBrush;
    }

    private double w(int style, double width) {
        if (style == 0) {
            return 0.0;
        }
        if (style == 6 || style == 7) {
            return 1.0;
        }
        if (style == 4 || style == 5) {
            return 2.0;
        }
        return width;
    }

    public void paint(Graphics g, double x, double y, double width, double height) {
        this.paint(g, x, y, width, height, -1.0, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, double x, double y, double width, double height, double gapX, double gapWidth) {
        g.push();
        try {
            double ax = x - 1.0;
            double ay = y - 1.0;
            double bx = x + width;
            double by = y + height;
            if (this.adjust(this.leftStyle, this.leftWidth)) {
                ax += this.leftWidth / 2.0;
            }
            if (this.adjust(this.topStyle, this.topWidth)) {
                ay += this.topWidth / 2.0;
            }
            if (this.adjust(this.rightStyle, this.rightWidth)) {
                bx -= this.rightWidth / 2.0 - 1.0;
            }
            if (this.adjust(this.bottomStyle, this.bottomWidth)) {
                by -= this.bottomWidth / 2.0 - 1.0;
            }
            if (this.leftStyle == 4 || this.leftStyle == 5) {
                ax += 1.0;
            }
            if (this.topStyle == 4 || this.topStyle == 5) {
                ay += 1.0;
            }
            if (this.rightStyle == 4 || this.rightStyle == 5) {
                bx -= 1.0;
            }
            if (this.bottomStyle == 4 || this.bottomStyle == 5) {
                by -= 1.0;
            }
            this.paintTop(g, ax, ay, bx, by, gapX, gapWidth);
            this.paintLeft(g, ax, ay, bx, by);
            this.paintBottom(g, ax, ay, bx, by);
            this.paintRight(g, ax, ay, bx, by);
        }
        finally {
            g.pop();
        }
    }

    private boolean adjust(int style, double w) {
        boolean a = style == 1 || style == 2 || style == 3;
        boolean b = w > 1.0;
        return a & b;
    }

    private void paintTop(Graphics g, double ax, double ay, double bx, double by, double gapX, double gapWidth) {
        if (gapX < 0.0) {
            this.helper(g, ax, ay, bx, by);
        } else {
            this.helper(g, ax, ay, gapX - 2.0, by);
            this.helper(g, gapX + gapWidth + 1.0, ay, bx, by);
        }
    }

    private void helper(Graphics g, double ax, double ay, double bx, double by) {
        int s = this.topStyle;
        if (s == 0) {
            return;
        }
        if (s == 4 || s == 5) {
            g.setPen(solidPen);
            g.setBrush(s == 4 ? shadow : hlight);
            g.strokeLine(ax, ay - 1.0, bx, ay - 1.0);
            g.setBrush(s == 4 ? hlight : shadow);
            g.strokeLine(ax + 1.0, ay, bx, ay);
        } else {
            if (s == 6) {
                g.setPen(solidPen);
                g.setBrush(shadow);
            } else if (s == 7) {
                g.setPen(solidPen);
                g.setBrush(hlight);
            } else {
                if (s == 1) {
                    g.setPen(this.makePen(this.topWidth, 1));
                }
                if (s == 2) {
                    g.setPen(this.makePen(this.topWidth, 2));
                }
                if (s == 3) {
                    g.setPen(this.makePen(this.topWidth, 3));
                }
                g.setBrush(this.topBrush);
            }
            g.strokeLine(ax, ay, bx, ay);
        }
    }

    private void paintLeft(Graphics g, double ax, double ay, double bx, double by) {
        int s = this.leftStyle;
        if (s == 0) {
            return;
        }
        if (s == 4 || s == 5) {
            g.setPen(solidPen);
            g.setBrush(s == 4 ? shadow : hlight);
            g.strokeLine(ax - 1.0, ay - 1.0, ax - 1.0, by);
            g.setBrush(s == 4 ? hlight : shadow);
            g.strokeLine(ax, ay, ax, by);
        } else {
            if (s == 6) {
                g.setPen(solidPen);
                g.setBrush(shadow);
            } else if (s == 7) {
                g.setPen(solidPen);
                g.setBrush(hlight);
            } else {
                if (s == 1) {
                    g.setPen(this.makePen(this.leftWidth, 1));
                }
                if (s == 2) {
                    g.setPen(this.makePen(this.leftWidth, 2));
                }
                if (s == 3) {
                    g.setPen(this.makePen(this.leftWidth, 3));
                }
                g.setBrush(this.leftBrush);
            }
            g.strokeLine(ax, ay, ax, by);
        }
    }

    private void paintBottom(Graphics g, double ax, double ay, double bx, double by) {
        int s = this.bottomStyle;
        if (s == 0) {
            return;
        }
        if (s == 4 || s == 5) {
            g.setPen(solidPen);
            g.setBrush(s == 4 ? shadow : hlight);
            g.strokeLine(ax, by, bx, by);
            g.setBrush(s == 4 ? hlight : shadow);
            g.strokeLine(ax, by + 1.0, bx, by + 1.0);
        } else {
            if (s == 6) {
                g.setPen(solidPen);
                g.setBrush(hlight);
                ax += 1.0;
            } else if (s == 7) {
                g.setPen(solidPen);
                g.setBrush(shadow);
            } else {
                if (s == 1) {
                    g.setPen(this.makePen(this.bottomWidth, 1));
                }
                if (s == 2) {
                    g.setPen(this.makePen(this.bottomWidth, 2));
                }
                if (s == 3) {
                    g.setPen(this.makePen(this.bottomWidth, 3));
                }
                g.setBrush(this.bottomBrush);
            }
            g.strokeLine(ax, by, bx, by);
        }
    }

    private void paintRight(Graphics g, double ax, double ay, double bx, double by) {
        int s = this.rightStyle;
        if (s == 0) {
            return;
        }
        if (s == 4 || s == 5) {
            g.setPen(solidPen);
            g.setBrush(s == 4 ? shadow : hlight);
            g.strokeLine(bx, ay, bx, by);
            g.setBrush(s == 4 ? hlight : shadow);
            g.strokeLine(bx + 1.0, ay - 1.0, bx + 1.0, by + 1.0);
        } else {
            if (s == 6) {
                g.setPen(solidPen);
                g.setBrush(hlight);
                ay += 1.0;
            } else if (s == 7) {
                g.setPen(solidPen);
                g.setBrush(shadow);
            } else {
                if (s == 1) {
                    g.setPen(this.makePen(this.rightWidth, 1));
                }
                if (s == 2) {
                    g.setPen(this.makePen(this.rightWidth, 2));
                }
                if (s == 3) {
                    g.setPen(this.makePen(this.rightWidth, 3));
                }
                g.setBrush(this.rightBrush);
            }
            g.strokeLine(bx, ay, bx, by);
        }
    }

    private BPen makePen(double width, int style) {
        int cap = 102;
        int join = 203;
        switch (style) {
            case 1: {
                if (width == 1.0) {
                    return solidPen;
                }
                return BPen.make((double)width, (int)102, (int)203, null);
            }
            case 2: {
                if (width == 1.0) {
                    return dottedPen;
                }
                return BPen.make((double)width, (int)102, (int)203, (double[])_dotted);
            }
            case 3: {
                if (width == 1.0) {
                    return dashedPen;
                }
                return BPen.make((double)width, (int)102, (int)203, (double[])_dashed);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isNull() {
        return this == NULL || this.equals((Object)NULL);
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.topWidth);
        hash = hash * 37L + (long)this.topStyle;
        hash = hash * 37L + (long)this.topBrush.hashCode();
        hash = hash * 37L + Double.doubleToRawLongBits(this.leftWidth);
        hash = hash * 37L + (long)this.leftStyle;
        hash = hash * 37L + (long)this.leftBrush.hashCode();
        hash = hash * 37L + Double.doubleToRawLongBits(this.bottomWidth);
        hash = hash * 37L + (long)this.bottomStyle;
        hash = hash * 37L + (long)this.bottomBrush.hashCode();
        hash = hash * 37L + Double.doubleToRawLongBits(this.rightWidth);
        hash = hash * 37L + (long)this.rightStyle;
        hash = hash * 37L + (long)this.rightBrush.hashCode();
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BBorder) {
            BBorder b = (BBorder)((Object)obj);
            return this.topWidth == b.topWidth && this.topStyle == b.topStyle && this.topBrush.equals((Object)b.topBrush) && this.leftWidth == b.leftWidth && this.leftStyle == b.leftStyle && this.leftBrush.equals((Object)b.leftBrush) && this.bottomWidth == b.bottomWidth && this.bottomStyle == b.bottomStyle && this.bottomBrush.equals((Object)b.bottomBrush) && this.rightWidth == b.rightWidth && this.rightStyle == b.rightStyle && this.rightBrush.equals((Object)b.rightBrush);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        if (this.topWidth == this.rightWidth && this.topWidth == this.bottomWidth && this.topWidth == this.leftWidth && this.topStyle == this.rightStyle && this.topStyle == this.bottomStyle && this.topStyle == this.leftStyle && this.topBrush.equals((Object)this.rightBrush) && this.topBrush.equals((Object)this.bottomBrush) && this.topBrush.equals((Object)this.leftBrush)) {
            return this.encodeSide(this.topWidth, this.topStyle, this.topBrush);
        }
        StringBuffer sb = new StringBuffer();
        if (this.topStyle != 0) {
            sb.append("top(");
            sb.append(this.encodeSide(this.topWidth, this.topStyle, this.topBrush));
            sb.append(") ");
        }
        if (this.rightStyle != 0) {
            sb.append("right(");
            sb.append(this.encodeSide(this.rightWidth, this.rightStyle, this.rightBrush));
            sb.append(") ");
        }
        if (this.bottomStyle != 0) {
            sb.append("bottom(");
            sb.append(this.encodeSide(this.bottomWidth, this.bottomStyle, this.bottomBrush));
            sb.append(") ");
        }
        if (this.leftStyle != 0) {
            sb.append("left(");
            sb.append(this.encodeSide(this.leftWidth, this.leftStyle, this.leftBrush));
            sb.append(") ");
        }
        return sb.toString().trim();
    }

    private String encodeSide(double width, int style, BBrush brush) throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(width).append(" ");
        switch (style) {
            case 0: {
                sb.append("none");
                break;
            }
            case 1: {
                sb.append("solid");
                break;
            }
            case 2: {
                sb.append("dotted");
                break;
            }
            case 3: {
                sb.append("dashed");
                break;
            }
            case 4: {
                sb.append("groove");
                break;
            }
            case 5: {
                sb.append("ridge");
                break;
            }
            case 6: {
                sb.append("inset");
                break;
            }
            case 7: {
                sb.append("outset");
            }
        }
        sb.append(" ").append(brush.encodeToString());
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BBorder.make(s);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 205: {
                this.setBaseOrd(a);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void setBaseOrd(Object baseOrd) {
        this.topBrush.fw(205, baseOrd, null, null, null);
        this.leftBrush.fw(205, baseOrd, null, null, null);
        this.bottomBrush.fw(205, baseOrd, null, null, null);
        this.rightBrush.fw(205, baseOrd, null, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private static class Side {
        double width = 0.0;
        int style = 0;
        BBrush brush = BBrush.NULL;

        private Side() {
        }
    }
}

