/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.Binder;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.UnboundException;
import javax.baja.ui.enums.BDegradeBehavior;

public abstract class BBinding
extends BComponent
implements BIAgent {
    public static final Property ord = BBinding.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property degradeBehavior = BBinding.newProperty((int)0, (BValue)BDegradeBehavior.none, null);
    public static final Topic targetChanged = BBinding.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BBinding.class);
    public static final Logger LOGGER = Logger.getLogger("niagara.binding");
    private OrdTarget target;

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BDegradeBehavior getDegradeBehavior() {
        return (BDegradeBehavior)this.get(degradeBehavior);
    }

    public void setDegradeBehavior(BDegradeBehavior v) {
        this.set(degradeBehavior, (BValue)v, null);
    }

    public void fireTargetChanged(BValue event) {
        this.fire(targetChanged, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BWidget getWidget() {
        return (BWidget)this.getParent();
    }

    public final BWidgetShell getShell() {
        BWidget widget = (BWidget)this.getParent();
        if (widget == null) {
            return null;
        }
        return widget.getShell();
    }

    public final boolean isBound() {
        return this.target != null;
    }

    public final OrdTarget getTarget() {
        if (this.target == null) {
            throw new UnboundException(this.getOrd().toString());
        }
        return this.target;
    }

    public final BObject get() {
        return this.getTarget().get();
    }

    public void started() {
        this.bind();
    }

    public void stopped() {
        this.unbind();
    }

    public void targetChanged() {
        this.applyDegradeBehavior();
        this.getWidget().relayout();
    }

    public boolean isDegraded() {
        return !this.isBound();
    }

    public void applyDegradeBehavior() {
        switch (this.getDegradeBehavior().getOrdinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.getWidget().setEnabled(!this.isDegraded());
                break;
            }
            case 2: {
                this.getWidget().setVisible(!this.isDegraded());
            }
        }
    }

    public void save(Context cx) throws Exception {
    }

    public BValue getOnWidget(Property prop) {
        return null;
    }

    public void changedOnWidget(Property property, Context context) {
    }

    public boolean invokedOnWidget(Action action, BValue value, Context context) {
        return false;
    }

    public boolean firedOnWidget(Topic topic, BValue event, Context context) {
        return false;
    }

    public boolean isParentLegal(BComponent c) {
        return c instanceof BWidget;
    }

    public String toString(Context cx) {
        String widget = "???";
        try {
            widget = this.getWidget().getType().getTypeName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Binding " + this.getOrd() + " -> " + widget;
    }

    void bind() {
        Binder binder = this.getBinder();
        if (binder != null) {
            binder.bind(this);
        }
    }

    void unbind() {
        Binder binder = this.getBinder();
        if (binder != null) {
            binder.unbind(this);
        }
    }

    void rebind() {
        this.unbind();
        this.bind();
    }

    Binder getBinder() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            Binder binder = (Binder)((Object)p.fw(302, null, null, null, null));
            if (binder == null) continue;
            return binder;
        }
        return null;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 2: {
                Property prop = (Property)a;
                if (prop != ord) break;
                this.rebind();
                break;
            }
            case 303: {
                this.target = (OrdTarget)a;
            }
        }
        return super.fw(x, a, b, c, d);
    }
}

