/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step;

import com.tridium.ui.wizard.step.BWizardButtonMode;
import com.tridium.ui.wizard.step.IWidgetWizardView;
import com.tridium.ui.wizard.step.StepModel;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.WizardModel;

public class StepWizardModel
extends WizardModel
implements IWidgetWizardView {
    private BWidget widget = new BNullWidget();
    private StepModel stepModel;
    private Size size;
    private BComponent base;
    private String title;

    public StepWizardModel(StepModel stepModel, String title) {
        this(stepModel, title, new Size(600.0, 400.0));
    }

    public StepWizardModel(StepModel stepModel, String title, Size size) {
        this.stepModel = stepModel;
        this.size = size;
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void init() {
        this.stepModel.init(this);
    }

    @Override
    public void back() {
        this.stepModel.back(this);
    }

    @Override
    public void next() {
        this.stepModel.next(this);
    }

    @Override
    public boolean finish() {
        boolean res = this.stepModel.finish(this);
        if (res) {
            this.stepModel.deactivated(this);
        }
        return res;
    }

    @Override
    public boolean cancel() {
        boolean res = this.stepModel.cancel(this);
        if (res) {
            this.stepModel.deactivated(this);
        }
        return res;
    }

    @Override
    public Size getPreferredSizeOfSteps() {
        return this.size;
    }

    @Override
    public BWidget getOwner() {
        return this.getWizard();
    }

    @Override
    public void setWizardContent(BWidget widget) {
        this.widget = widget;
        this.getWizard().setCurrentStep(widget);
    }

    @Override
    public BWidget getWizardContent() {
        return this.widget;
    }

    @Override
    public void setWizardHeader(BWidget widget) {
        BEdgePane pane = (BEdgePane)this.getWizard().getContent();
        pane.setTop(widget);
    }

    @Override
    public BWidget getWizardHeader() {
        return ((BEdgePane)this.getWizard().getContent()).getTop();
    }

    @Override
    public Context getWizardContext() {
        return null;
    }

    @Override
    public void update(BWizardButtonMode mode) {
        this.update(mode.getValue());
        this.getWizard().setCancelEnabled(mode.canCancel());
        if (this.stepModel.isFinished() && mode.canCancel()) {
            this.getWizard().getCancelButton().setText(UiLexicon.bajaui().get("commands.close.label"));
            this.getWizard().getCancelButton().setImage(BImage.make((String)UiLexicon.bajaui().get("commands.close.icon")));
            this.getWizard().relayout();
        }
    }

    @Override
    public BComponent getBase() {
        return this.base;
    }

    @Override
    public void handleError(Throwable throwable) {
        BDialog.error(this.getOwner(), throwable.getMessage());
    }

    public final StepModel getStepModel() {
        return this.stepModel;
    }

    public boolean isFinished() {
        return this.stepModel.isFinished();
    }

    public void setBase(BComponent base) {
        this.base = base;
    }
}

