/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.naming.BWidgetScheme;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.LexiconModule;

public final class ValidationUtil {
    private static final LexiconModule LEX = LexiconModule.make(ValidationUtil.class);

    private ValidationUtil() {
    }

    public static Map<String, String> getValidationWarnings(BPxMedia media, OrdTarget target, BAbstractPxView pxView, Context cx) throws Exception {
        HashMap<String, String> warnings = new HashMap<String, String>();
        ValidationUtil.findWidgetWarnings(media, ValidationUtil.loadPx(pxView, target, cx), warnings, true, cx);
        return warnings;
    }

    public static Map<String, String> getValidationWarnings(BPxMedia media, BWidget widget, Context cx) {
        return ValidationUtil.getValidationWarnings(media, new BWidget[]{widget}, true, cx);
    }

    public static Map<String, String> getValidationWarnings(BPxMedia media, BWidget[] roots, boolean validateChildren, Context cx) {
        HashMap<String, String> warnings = new HashMap<String, String>();
        for (BWidget root : roots) {
            ValidationUtil.findWidgetWarnings(media, root, warnings, validateChildren, cx);
        }
        return warnings;
    }

    private static void findWidgetWarnings(BPxMedia media, BWidget widget, Map<String, String> warnings, boolean validateChildren, Context cx) {
        TypeInfo info = widget.getType().getTypeInfo();
        String widgetOrd = BWidgetScheme.makeWidgetOrd(widget).toString();
        if (!media.isWidgetSupported(info)) {
            warnings.put(widgetOrd, LEX.getText("validateMedia.unsupportedType", cx, new Object[]{info}));
            return;
        }
        String warning = media.validateWidget(widget, cx);
        if (warning != null) {
            warnings.put(BWidgetScheme.makeWidgetOrd(widget).toString(), warning);
        }
        for (BBinding bBinding : widget.getBindings()) {
            String bindingWarning;
            if (!media.isBindingValidationRequired(widget, bBinding, cx)) continue;
            TypeInfo bindingInfo = bBinding.getType().getTypeInfo();
            String bindingOrd = widgetOrd + '/' + bBinding.getName();
            if (!media.isBindingSupported(bindingInfo)) {
                warnings.put(bindingOrd, LEX.getText("validateMedia.unsupportedType", cx, new Object[]{bindingInfo}));
            }
            if ((bindingWarning = media.validateBinding(bBinding, cx)) == null) continue;
            warnings.put(bindingOrd, bindingWarning);
        }
        if (validateChildren) {
            for (BComponent bComponent : media.getChildWidgetsToValidate(widget, cx)) {
                if (!media.isChildWidgetValidationRequired(widget, bComponent, cx)) continue;
                ValidationUtil.findWidgetWarnings(media, (BWidget)bComponent, warnings, validateChildren, cx);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BWidget loadPx(BAbstractPxView agent, OrdTarget target, Context cx) throws Exception {
        PxProperty[] pxProperties;
        PxDecoder decoder;
        BIFile pxFile;
        BWidget widget = null;
        if (agent != null) {
            if (agent instanceof BPxView) {
                BPxView view = (BPxView)agent;
                BOrd pxOrd = view.getPxFile();
                if (pxOrd.isNull()) {
                    throw new Exception();
                }
                pxFile = (BIFile)pxOrd.get(null, cx);
                decoder = new PxDecoder(pxFile, cx);
            } else {
                if (!(agent instanceof BDynamicPxView)) throw new IllegalStateException("Don't know how to load from agent " + agent.getType());
                String pxSource = ((BDynamicPxView)agent).generateXml((Object)target.get(), cx);
                ByteArrayInputStream in = new ByteArrayInputStream(pxSource.getBytes());
                decoder = new PxDecoder(target.getOrd(), in, cx);
            }
        } else {
            if (!(target.get() instanceof BIFile)) throw new IllegalStateException("Don't know how to load from " + target.get().getType());
            pxFile = (BIFile)target.get();
            decoder = new PxDecoder(pxFile, cx);
        }
        if (widget != null) return widget;
        widget = decoder.decodeDocument();
        for (PxProperty pxProperty : pxProperties = decoder.getPxProperties()) {
            pxProperty.apply(widget);
        }
        return widget;
    }

    public static String getWebWarnings(BWidget widget, Context cx) {
        boolean focusWarning = false;
        boolean differentGradientBorders = false;
        boolean imageBorders = false;
        StringBuilder b = new StringBuilder();
        SlotCursor c = widget.getProperties();
        while (c.next()) {
            BBrush.RadialGradient radial;
            BBrush brush;
            BValue value = c.get();
            if (value instanceof BBrush && (brush = (BBrush)value).getPaint() instanceof BBrush.RadialGradient && !(radial = (BBrush.RadialGradient)brush.getPaint()).getFocal().equals((Object)radial.getCenter())) {
                focusWarning = true;
            }
            if (!(value instanceof BBorder)) continue;
            BBorder border = (BBorder)value;
            try {
                if (border.encodeToString().contains("bottom(") && (border.topBrush.getPaint() instanceof BBrush.Gradient || border.leftBrush.getPaint() instanceof BBrush.Gradient || border.rightBrush.getPaint() instanceof BBrush.Gradient || border.bottomBrush.getPaint() instanceof BBrush.Gradient)) {
                    differentGradientBorders = true;
                }
                if (!(border.topBrush.getPaint() instanceof BBrush.Image) && !(border.rightBrush.getPaint() instanceof BBrush.Image) && !(border.bottomBrush.getPaint() instanceof BBrush.Image) && !(border.leftBrush.getPaint() instanceof BBrush.Image)) continue;
                imageBorders = true;
            }
            catch (Exception exception) {}
        }
        if (focusWarning) {
            b.append(LEX.getText("validateMedia.radialFocalWarning", cx));
        }
        if (differentGradientBorders) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(LEX.getText("validateMedia.differentGradientBorders", cx));
        }
        if (imageBorders) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(LEX.getText("validateMedia.imageBorders", cx));
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }
}

