/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.RadioButtonTheme;
import com.tridium.ui.theme.custom.CustomToggleButtonTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class CustomRadioButtonTheme
extends CustomToggleButtonTheme
implements RadioButtonTheme {
    public CustomRadioButtonTheme() {
        NSS nss = CustomRadioButtonTheme.getNSS();
        NSS radio = nss.selectNode("button radio");
        this.regFallbackValue(radio, "normalPadding", "padding", "2 2 2 18");
    }

    @Override
    String getNSSSelector() {
        return "button radio";
    }

    @Override
    public IPoint getLabelOffset(BAbstractButton button) {
        return this.noOffset;
    }

    @Override
    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean selected = ((BToggleButton)b).isSelected();
        double x = 0.0;
        double y = b.getHeight() / 2.0 - 6.0;
        double w = 12.0;
        double h = 12.0;
        g.setBrush(this.getControlForeground(b));
        g.strokeLine(x, y + h / 2.0, x + w / 2.0, y);
        g.strokeLine(x + w / 2.0, y, x + w, y + h / 2.0);
        g.strokeLine(x + w, y + h / 2.0, x + w / 2.0, y + h);
        g.strokeLine(x + w / 2.0, y + h, x, y + h / 2.0);
        if (pressed && mouseOver) {
            g.setBrush(this.getControlShadow(b));
        } else {
            g.setBrush(this.getControlHighlight(b));
        }
        g.strokeLine(x + 1.0, y + h / 2.0, x + w / 2.0, y + 1.0);
        g.setBrush(this.getControlShadow(b));
        g.strokeLine(x + w - 1.0, y + h / 2.0, x + w / 2.0, y + h - 1.0);
        g.strokeLine(x + w - 2.0, y + h / 2.0, x + w / 2.0, y + h - 2.0);
        if (selected) {
            g.setBrush(this.getControlForeground(b));
            g.strokeLine(x + 4.0, y + h / 2.0, x + w / 2.0, y + 4.0);
            g.strokeLine(x + 5.0, y + h / 2.0 + 1.0, x + w / 2.0 + 1.0, y + 5.0);
            g.strokeLine(x + 6.0, y + h / 2.0 + 2.0, x + w / 2.0 + 2.0, y + 6.0);
            g.strokeLine(x + 5.0, y + h / 2.0, x + w / 2.0, y + 5.0);
            g.strokeLine(x + 6.0, y + h / 2.0 + 1.0, x + w / 2.0 + 1.0, y + 6.0);
        }
        if (b.hasFocus() && b.isFocusTraversable()) {
            BInsets padding = this.getNormalPadding();
            x = padding.left - 2.0;
            y = padding.top;
            w = b.getWidth() - (x + padding.right);
            h = b.getHeight() - (y + padding.bottom);
            this.paintFocus(g, new RectGeom(x, y, w, h));
        }
    }
}

