/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.ExpandablePaneTheme;
import com.tridium.ui.theme.custom.CustomPaneTheme;
import com.tridium.ui.theme.custom.CustomThemeUtils;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;

public class CustomExpandablePaneTheme
extends CustomPaneTheme
implements ExpandablePaneTheme {
    @Override
    String getNSSSelector() {
        return "pane expandable-pane";
    }

    @Override
    public void paintButton(Graphics g, BWidget widget, RectGeom r, boolean isExpanded, boolean isOverButton) {
        int dir = isExpanded ? 0 : 1;
        g.setBrush(BColor.black);
        int x = (int)r.x;
        int y = (int)r.y;
        int w = (int)r.width;
        int h = (int)r.height - 2;
        CustomThemeUtils.paintArrow(g, dir, x, y - 2, w, h);
        CustomThemeUtils.paintArrow(g, dir, x, y + 2, w, h);
        if (isOverButton) {
            g.setBrush(this.getControlHighlight(widget));
            g.strokeLine((double)(x + 1), (double)(y + 1), (double)(x + w - 2), (double)(y + 1));
            g.strokeLine((double)(x + 1), (double)(y + 1), (double)(x + 1), (double)(y + h - 2));
            g.setBrush(this.getControlShadow(widget));
            g.strokeLine((double)(x + w - 1), (double)(y + 1), (double)(x + w - 1), (double)(y + h - 2));
            g.strokeLine((double)(x + 1), (double)(y + h - 2), (double)(x + w - 1), (double)(y + h - 2));
        }
    }

    @Override
    public double getExpanderWidth() {
        return 17.0;
    }
}

