/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.SpinnerButtonTheme;
import com.tridium.ui.theme.curium.CuriumThemeUtils;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class CuriumSpinnerButtonTheme
extends CuriumWidgetTheme
implements SpinnerButtonTheme {
    static Point noOffset = new Point(0.0, 0.0);
    static Point pressedOffset = new Point(1.0, 1.0);
    public static final double SPINNER_WIDTH = 80.0;

    @Override
    public double getSpinnerWidth() {
        return 80.0;
    }

    @Override
    public boolean isStacked() {
        return false;
    }

    @Override
    public IPoint getLabelOffset(BAbstractButton b) {
        BAbstractButton.MenuController c = b.getMenuController();
        if (c != null && !c.isMenuDistinct() && b.isMenuPressed()) {
            return pressedOffset;
        }
        if (b.isPressed() && b.isMouseOver()) {
            return pressedOffset;
        }
        if (b instanceof BToggleButton && ((BToggleButton)b).isSelected()) {
            return pressedOffset;
        }
        return noOffset;
    }

    @Override
    public void paintArrows(Graphics g, BAbstractButton up, BAbstractButton down, boolean translateUp, boolean translateDown) {
        IPoint offset = this.getLabelOffset(up);
        if (translateUp) {
            g.translate(offset.x(), offset.y());
        }
        int width = (int)up.getWidth();
        int height = (int)up.getHeight();
        int centerX = width / 2 + 1;
        int centerY = height / 2 + 1;
        CuriumThemeUtils.paintArrow(g, 0, 0.0, 0.0, width, height);
        if (translateUp) {
            g.translate(-offset.x(), -offset.y());
        }
        offset = this.getLabelOffset(down);
        if (translateDown) {
            g.translate(offset.x(), offset.y());
        }
        CuriumThemeUtils.paintArrow(g, 1, up.getWidth(), 0.0, width, height);
        if (translateDown) {
            g.translate(-offset.x(), -offset.y());
        }
    }
}

