/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.PropertySheetTreeTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.curium.CuriumTreeTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public class CuriumPropertySheetTreeTheme
extends CuriumTreeTheme
implements PropertySheetTreeTheme {
    private BBrush dividerBrush = BColor.make((int)0xBBBBBB).toBrush();

    @Override
    public void paintExpander(Graphics g, BWidget widget, double x, double y, boolean isExpandable, boolean isExpanded) {
        if (!isExpandable) {
            return;
        }
        double EXPANDER_DIM = this.getExpanderHeight();
        g.setBrush(Theme.widget().getControlHighlight());
        g.strokeLine(x, y, x + EXPANDER_DIM - 2.0, y);
        g.strokeLine(x, y, x, y + EXPANDER_DIM - 2.0);
        g.setBrush(Theme.widget().getControlShadow());
        g.strokeLine(x + EXPANDER_DIM - 1.0, y, x + EXPANDER_DIM - 1.0, y + EXPANDER_DIM - 1.0);
        g.strokeLine(x, y + EXPANDER_DIM - 1.0, x + EXPANDER_DIM - 1.0, y + EXPANDER_DIM - 1.0);
        if (isExpandable) {
            g.setBrush(Theme.widget().getTextBrush());
            this.paintExpanderHelper(g, x, y, EXPANDER_DIM - 1.0, EXPANDER_DIM - 1.0, isExpanded);
        }
    }

    private void paintExpanderHelper(Graphics g, double x, double y, double w, double h, boolean expanded) {
        double pad = Math.max(w / 3.0, 2.0);
        g.strokeLine(x + pad, y + h / 2.0, x + (w - pad), y + h / 2.0);
        if (!expanded) {
            g.strokeLine(x + w / 2.0, y + pad, x + w / 2.0, y + h - pad);
        }
    }

    @Override
    public BBrush getDividerColor(IStylable widget) {
        return this.dividerBrush;
    }

    @Override
    public BBrush getHeaderColor(IStylable widget) {
        return this.getTextBrush();
    }

    @Override
    public BBrush getHeaderBackground(IStylable widget) {
        return this.getControlBackground();
    }
}

