/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.px;

import com.tridium.ui.px.PxPropertyComponent;
import com.tridium.ui.px.Target;
import com.tridium.ui.px.TargetArray;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxProperty;

public class PxPropertyComponentArray {
    private List<PxPropertyComponent> arr = new ArrayList<PxPropertyComponent>();

    public void add(PxPropertyComponent pc) {
        this.arr.add(pc);
    }

    public void remove(PxPropertyComponent pc) {
        this.arr.remove(pc);
    }

    public void remove(int idx) {
        this.arr.remove(idx);
    }

    public PxPropertyComponent get(BComponent comp) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getComponent() != comp) continue;
            return this.get(i);
        }
        return null;
    }

    public int size() {
        return this.arr.size();
    }

    public PxPropertyComponent get(int index) {
        return this.arr.get(index);
    }

    public PxPropertyComponent[] forWidgets(BWidget[] widgets) {
        ArrayList<PxPropertyComponent> wa = new ArrayList<PxPropertyComponent>();
        for (int i = 0; i < this.size(); ++i) {
            for (BWidget widget : widgets) {
                if (this.get(i).getWidget() != widget) continue;
                wa.add(this.get(i));
            }
        }
        return wa.toArray(new PxPropertyComponent[0]);
    }

    public void addAll(PxPropertyComponent[] pc) {
        Collections.addAll(this.arr, pc);
    }

    public void removeAll(PxPropertyComponent[] pc) {
        for (PxPropertyComponent aPc : pc) {
            this.arr.remove(aPc);
        }
    }

    public PxProperty[] getPxProperties(BComponent[] comps, String propName) {
        HashSet<PxProperty> set = new HashSet<PxProperty>();
        for (BComponent comp : comps) {
            PxProperty g = this.getPxProperty(comp, propName);
            if (g == null) continue;
            set.add(g);
        }
        return set.toArray(new PxProperty[0]);
    }

    public PxProperty getPxProperty(BComponent comp, String propName) {
        PxPropertyComponent pc = this.get(comp);
        return pc == null ? null : pc.getTargets().getPxProperty(propName);
    }

    public BWidget[] getWidgets(PxProperty pxProp) {
        ArrayList<BWidget> arr = new ArrayList<BWidget>();
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent pc = this.get(i);
            if (!pc.getTargets().hasProperty(pxProp)) continue;
            arr.add(pc.getWidget());
        }
        return arr.toArray(new BWidget[0]);
    }

    public void setValue(PxProperty pxProp) {
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent pc = this.get(i);
            BComponent comp = pc.getComponent();
            for (Target target : pc.getTargets().forProperty(pxProp)) {
                comp.set(target.getPropertyName(), pxProp.getValue());
                pc.getWidget().bindingsChanged();
            }
        }
    }

    public void setDefaultValue(PxProperty pxProp) {
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent pc = this.get(i);
            BComponent comp = pc.getComponent();
            for (Target target : pc.getTargets().forProperty(pxProp)) {
                Property p = comp.getProperty(target.getPropertyName());
                comp.set(p, p.getDefaultValue());
                pc.getWidget().bindingsChanged();
            }
        }
    }

    public PxPropertyComponentArray deepClone() {
        PxPropertyComponentArray gcomps = new PxPropertyComponentArray();
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent oldC = this.get(i);
            PxPropertyComponent newC = new PxPropertyComponent(oldC.getComponent());
            gcomps.add(newC);
            TargetArray oldT = oldC.getTargets();
            TargetArray newT = newC.getTargets();
            for (int j = 0; j < oldT.size(); ++j) {
                Target z = oldT.get(j);
                newT.add(z.getPxProperty(), z.getPropertyName());
            }
        }
        return gcomps;
    }

    public void replaceWidgets(BWidget[] oldWidgets, BWidget[] newWidgets) {
        if (oldWidgets.length != newWidgets.length) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < oldWidgets.length; ++i) {
            this.doReplace(oldWidgets[i], newWidgets[i]);
        }
    }

    private void doReplace(BWidget ow, BWidget nw) {
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent pc = this.get(i);
            if (pc.getWidget() != ow) continue;
            BComponent comp = pc.getComponent();
            comp = comp instanceof BWidget ? nw : (BComponent)nw.get(comp.getPropertyInParent().getName());
            pc.setComponent(comp);
            TargetArray gt = pc.getTargets();
            for (int j = 0; j < gt.size(); ++j) {
                Target z = gt.get(j);
                comp.set(z.getPropertyName(), z.getPxProperty().getValue());
                pc.getWidget().bindingsChanged();
            }
        }
    }

    public void addTarget(PxProperty pxProp, BComponent comp, String propName) {
        PxPropertyComponent pc = this.get(comp);
        if (pc == null) {
            pc = new PxPropertyComponent(comp);
            this.add(pc);
        }
        pc.addTarget(pxProp, propName);
        comp.set(propName, pxProp.getValue());
        pc.getWidget().bindingsChanged();
    }

    public void removeTarget(PxProperty pxProp, BComponent comp, String propName) {
        PxPropertyComponent pc = this.get(comp);
        pc.removeTarget(pxProp, propName);
        if (!pc.hasTargets()) {
            this.remove(pc);
        }
        Property p = comp.getProperty(propName);
        comp.set(p, p.getDefaultValue());
        pc.getWidget().bindingsChanged();
    }

    public void updateTargets(BWidget root, PxProperty[] properties) {
        for (PxProperty property : properties) {
            property.setTargets(new SlotPath[0]);
        }
        HashMap<PxProperty, List> hash = new HashMap<PxProperty, List>();
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent pc = this.get(i);
            Optional compSlot = CompUtil.slotPathFromAncestor((BComplex)root, (BComplex)pc.getComponent());
            if (!compSlot.isPresent()) continue;
            TargetArray gt = pc.getTargets();
            for (int j = 0; j < gt.size(); ++j) {
                Target t = gt.get(j);
                PxProperty prop = t.getPxProperty();
                List arr = hash.computeIfAbsent(prop, k -> new ArrayList());
                arr.add(new SlotPath(((SlotPath)compSlot.get()).getBody() + "/" + t.getPropertyName()));
            }
        }
        for (Map.Entry pxPropertyListEntry : hash.entrySet()) {
            PxProperty prop = (PxProperty)pxPropertyListEntry.getKey();
            List arr = (List)pxPropertyListEntry.getValue();
            prop.setTargets(arr.toArray(new SlotPath[0]));
        }
    }

    public String toString() {
        return this.arr.toString();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------------------------\n");
        for (int i = 0; i < this.size(); ++i) {
            PxPropertyComponent pc = this.get(i);
            sb.append(pc.getComponent().toDebugString()).append("\n");
            TargetArray gt = pc.getTargets();
            for (int j = 0; j < gt.size(); ++j) {
                Target z = gt.get(j);
                sb.append("    ").append(z.getPxProperty().getName()).append(", ").append(z.getPropertyName()).append("\n");
            }
        }
        return sb.toString();
    }
}

