/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.PreviewRenderer;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BIDirectory;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;

public class DefaultPreviewRenderer
extends PreviewRenderer {
    Point nameLoc = new Point();
    Point sizeLoc = new Point();
    Point timeLoc = new Point();
    String name = "";
    String size = "";
    String time = "";

    public DefaultPreviewRenderer(BWidget parent) {
        super(parent);
    }

    @Override
    public void doPrepare(double width, double height) {
        if (!(this.file instanceof BIDirectory)) {
            this.name = this.file.getNavDisplayName(null);
            this.time = String.valueOf(this.file.getLastModified());
            long sz = this.file.getSize();
            this.size = sz < 1024L ? String.valueOf(sz) + " bytes" : String.valueOf(sz / 1024L) + " KB";
            BFont font = Theme.widget().getTextFont();
            BFont bold = Theme.widget().getBoldText();
            double ta = font.getAscent();
            double th = font.getHeight();
            double nw = bold.width(this.name);
            double sw = font.width(this.size);
            double tw = font.width(this.time);
            double y = (height - th * 3.0) / 2.0;
            this.nameLoc.set((width - nw) / 2.0, y + ta);
            this.sizeLoc.set((width - sw) / 2.0, y + th + ta);
            this.timeLoc.set((width - tw) / 2.0, y + th * 2.0 + ta);
        }
    }

    @Override
    public void doPaint(Graphics g) {
        if (!this.file.isDirectory()) {
            g.setBrush(BColor.black);
            g.setFont(Theme.widget().getBoldText());
            g.drawString(this.name, this.nameLoc.x, this.nameLoc.y);
            g.setFont(Theme.widget().getTextFont());
            g.drawString(this.size, this.sizeLoc.x, this.sizeLoc.y);
            g.drawString(this.time, this.timeLoc.x, this.timeLoc.y);
        }
    }
}

