/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.BFileSpaceList;
import com.tridium.ui.file.BNFileChooser;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import java.io.File;
import java.lang.reflect.Method;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.util.UiLexicon;

public class BNDirectoryChooser
extends BDirectoryChooser {
    public static final Type TYPE = Sys.loadType(BNDirectoryChooser.class);
    final UiLexicon lex = UiLexicon.bajaui();
    FileChooserModel model;
    BTreeView treeView;
    BTree bookmarks;
    BFileSpaceList spaceList;
    BToolPane toolPane;
    BSplitPane split;
    BLabelPane spaceListPane;
    BLabelPane bookmarksPane;
    ConfirmCommand confirmCommand;
    CancelCommand cancelCommand;
    CreateDirCommand createDirCommand;
    BookmarkCommand bookmarkCommand;
    Point lastLocation;
    Size lastSize = new Size(450.0, 430.0);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNDirectoryChooser(BWidget parent) {
        this(parent, UiLexicon.bajaui().getText("dirChooser.confirm"));
    }

    public BNDirectoryChooser(BWidget parent, BFileSpace space) {
        this(parent, space, UiLexicon.bajaui().getText("dirChooser.confirm"));
    }

    public BNDirectoryChooser(BWidget parent, String confirmLabel) {
        this(parent, (BFileSpace)BFileSystem.INSTANCE, confirmLabel);
    }

    public BNDirectoryChooser(BWidget parent, BFileSpace space, String confirmLabel) {
        super(parent, UiLexicon.bajaui().getText("dirChooser.title"));
        this.model = new FileChooserModel((BSpace)space);
        this.model.setSupport(new DirChooserSupport());
        this.treeView = new BTreeView(this.model);
        this.treeView.setSelector(true);
        this.treeView.setSelection(new Selection());
        this.spaceList = new BFileSpaceList(this.model);
        this.bookmarks = new BTree(new BNFileChooser.BookmarkModel());
        this.bookmarks.setController(new BookmarkController());
        this.confirmCommand = new ConfirmCommand(confirmLabel);
        this.cancelCommand = new CancelCommand(this.lex.getText("fileChooser.cancel"));
        this.createDirCommand = new CreateDirCommand();
        this.createDirCommand.setEnabled(this.model.getSpace() instanceof BFileSpace && this.model.getDirectory() instanceof BIFile);
        this.bookmarkCommand = new BookmarkCommand();
        BToolBar toolbar = new BToolBar();
        toolbar.addButton(null, this.createDirCommand);
        toolbar.add(null, (BValue)new BSeparator());
        toolbar.addButton(null, this.bookmarkCommand);
        BGridPane bottom = new BGridPane(2);
        bottom.setUniformColumnWidth(true);
        bottom.add(null, (BValue)new BButton(this.confirmCommand));
        bottom.add(null, (BValue)new BButton(this.cancelCommand));
        BEdgePane content = new BEdgePane();
        content.setTop(toolbar);
        content.setCenter(new BBorderPane((BWidget)new BScrollPane(this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        content.setBottom(new BBorderPane(bottom, 5.0, 0.0, 0.0, 0.0));
        BImage icon1 = BImage.make((String)"module://icons/x16/computer.png");
        BImage icon2 = BImage.make((String)"module://icons/x16/bookmark.png");
        BLabel label1 = new BLabel(icon1, this.lex.getText("fileChooser.spaces"));
        BLabel label2 = new BLabel(icon2, this.lex.getText("fileChooser.bookmarks"));
        this.spaceListPane = new BLabelPane(label1, (BWidget)this.spaceList);
        this.bookmarksPane = new BLabelPane(label2, (BWidget)this.bookmarks);
        this.toolPane = new BToolPane();
        this.toolPane.add("spaceList", (BValue)this.spaceListPane);
        this.toolPane.add("bookmarks", (BValue)this.bookmarksPane);
        this.split = new BSplitPane();
        this.split.setDividerPosition(40.0);
        this.split.setWidget1(new BBorderPane((BWidget)this.toolPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.split.setWidget2(content);
        this.setContent(new BBorderPane(this.split, 5.0, 5.0, 5.0, 5.0));
    }

    public BNDirectoryChooser() {
        super(null, "");
    }

    @Override
    public BOrd show() {
        this.bookmarks.setModel(new BNFileChooser.BookmarkModel());
        this.bookmarks.relayout();
        this.model.setDirectory(this.model.getDirectory());
        if (this.lastLocation == null) {
            this.setBoundsCenteredOnOwner();
        } else {
            this.setScreenBounds(this.lastLocation.x, this.lastLocation.y, this.lastSize.width, this.lastSize.height);
        }
        if (!this.getSpaceListVisible() && !this.getBookmarksVisible()) {
            this.split.setDividerPosition(0.0);
        }
        this.bookmarkCommand.setEnabled(this.getBookmarksVisible());
        this.treeView.getSelection().updateTree();
        this.open();
        BIFile[] files = this.model.getSelectedFiles();
        return files.length == 0 ? null : files[0].getNavOrd();
    }

    @Override
    public BOrd getCurrentDirectory() {
        return this.model.getDirectory().getNavOrd();
    }

    @Override
    public void setCurrentDirectory(BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        BINavNode node = (BINavNode)ord.resolve().get();
        this.model.setSpace(BOrd.toSpace((BObject)((BObject)node)));
        if (node instanceof BIFile) {
            this.model.setDirectory(node);
            this.model.select((BIFile)node);
        } else {
            this.model.setDirectory(node);
        }
    }

    @Override
    public BSpace[] getSpaces() {
        return this.spaceList.getSpaces();
    }

    @Override
    public void setSpaces(BSpace[] spaces) {
        this.spaceList.setSpaces(spaces);
    }

    public FileChooserModel getModel() {
        return this.model;
    }

    public BSpace getCurrentSpace() {
        return this.model.getSpace();
    }

    public void setCurrentSpace(BSpace space) {
        this.model.setSpace(space);
    }

    public BINavNode getCurrentNavDirectory() {
        return this.model.getDirectory();
    }

    public void setCurrentNavDirectory(BINavNode dir) {
        this.model.setDirectory(dir);
    }

    public void setCurrentDirectory(File dir) {
        BIFile bdir = (BIFile)BFileSystem.INSTANCE.localFileToOrd(dir).get();
        this.model.setDirectory((BINavNode)bdir);
    }

    public boolean getSpaceListVisible() {
        return this.toolPane.get("spaceList") != null;
    }

    public void setSpaceListVisible(boolean b) {
        if (b && this.toolPane.get("spaceList") == null) {
            this.toolPane.add("spaceList", (BValue)this.spaceListPane);
        } else if (!b && this.toolPane.get("spaceList") != null) {
            this.toolPane.remove("spaceList");
        }
        this.toolPane.relayout();
    }

    public boolean getBookmarksVisible() {
        return this.toolPane.get("bookmarks") != null;
    }

    public void setBookmarksVisible(boolean b) {
        if (b && this.toolPane.get("bookmarks") == null) {
            this.toolPane.add("bookmarks", (BValue)this.bookmarksPane);
        } else if (!b && this.toolPane.get("bookmarks") != null) {
            this.toolPane.remove("bookmarks");
        }
        this.toolPane.relayout();
    }

    @Override
    public void computePreferredSize() {
        this.setPreferredSize(this.lastSize.width, this.lastSize.height);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.lastSize.width = this.getWidth();
        this.lastSize.height = this.getHeight();
        try {
            this.lastLocation = this.translateToScreen(new Point(0.0, 0.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.cancelCommand.invoke();
    }

    void openBookmark(BBookmark bm) {
        try {
            BINavNode dir = (BINavNode)bm.getBookmarkOrd().resolve().get();
            BSpace space = BOrd.toSpace((BObject)((BObject)dir));
            if (!(space instanceof BFileSpace)) {
                throw new Exception("Space not instance of BFileSpace");
            }
            this.model.setSpace(space);
            this.model.setDirectory(dir);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, this.lex.getText("fileChooser.error"), (Object)this.lex.getText("fileChooser.bookmarkResolveError"), e);
        }
    }

    BBookmark makeForCurrentContext() {
        BSpace space = this.model.getSpace();
        BINavNode dir = this.model.getDirectory();
        String name = dir.getNavDisplayName(null);
        if (BModule.isModuleFileSpace((BISpace)space) && dir.getNavParent() == null) {
            name = ((BModule)BModule.getModule((BISpace)space).get()).getModuleName();
            space = BModuleSpace.INSTANCE;
            dir = space.getNavChild(name);
        }
        return new BBookmark(name, dir.getNavOrd(), dir.getNavIcon());
    }

    class Selection
    extends TreeSelection {
        Selection() {
        }

        @Override
        public void updateTree() {
            super.updateTree();
            boolean sel = this.getNode() != null;
            BNDirectoryChooser.this.createDirCommand.setEnabled(sel && BNDirectoryChooser.this.model.getSpace() instanceof BFileSpace && BNDirectoryChooser.this.model.getDirectory() instanceof BIFile);
            BNDirectoryChooser.this.bookmarkCommand.setEnabled(sel && BNDirectoryChooser.this.getBookmarksVisible());
        }
    }

    class DirChooserSupport
    extends FileChooserModel.Support {
        DirChooserSupport() {
        }

        @Override
        public void pathModified() {
            BNDirectoryChooser.this.treeView.scrollToVisible(BNDirectoryChooser.this.model.getDirectory());
            TreeNode node = BNDirectoryChooser.this.treeView.getSelection().getNode();
            if (node != null && node.getSubject() != BNDirectoryChooser.this.model.getDirectory() && node.getSubject() != BNDirectoryChooser.this.model.getSpace()) {
                BNDirectoryChooser.this.treeView.getSelection().deselectAll();
            }
            BNDirectoryChooser.this.createDirCommand.setEnabled(BNDirectoryChooser.this.model.getSpace() instanceof BFileSpace && BNDirectoryChooser.this.model.getDirectory() instanceof BIFile);
            BNDirectoryChooser.this.spaceList.relayout();
        }

        @Override
        public void selectionModified() {
            BIFile[] files = BNDirectoryChooser.this.model.getSelectedFiles();
            if (files.length > 0) {
                BNDirectoryChooser.this.model.setDirectory((BINavNode)files[0]);
            }
        }

        @Override
        public void chooseSelectedFiles() {
            BIFile[] files = BNDirectoryChooser.this.model.getSelectedFiles();
            if (files.length == 0) {
                return;
            }
            BNDirectoryChooser.this.close();
        }
    }

    class BookmarkController
    extends TreeController {
        BookmarkController() {
        }

        @Override
        protected void doSelectAction(TreeNode target, double x, double y) {
            BNFileChooser.Node node = (BNFileChooser.Node)target;
            if (node.item instanceof BBookmark) {
                BNDirectoryChooser.this.openBookmark((BBookmark)node.item);
            }
        }
    }

    class BookmarkCommand
    extends Command {
        BookmarkCommand() {
            super((BWidget)BNDirectoryChooser.this, BNDirectoryChooser.this.lex.module, "fileChooser.bookmarks");
        }

        @Override
        public CommandArtifact doInvoke() {
            try {
                BBookmark bm = BNDirectoryChooser.this.makeForCurrentContext();
                BNFileChooser.getFileBookmarks().add(null, (BValue)bm);
                BBookmarkOptions.make().save();
                BNDirectoryChooser.this.bookmarks.setModel(new BNFileChooser.BookmarkModel());
                BNDirectoryChooser.this.bookmarks.relayout();
            }
            catch (Exception e) {
                BDialog.error(this.getOwner(), "Error", (Object)"Add failed", e);
                return null;
            }
            try {
                Class cls = Sys.loadClass((String)"workbench", (String)"com.tridium.workbench.bookmark.BookmarkEvents");
                Object obj = cls.newInstance();
                Method method = cls.getDeclaredMethod("fireBookmarkChanged", new Class[0]);
                method.invoke(obj, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class CreateDirCommand
    extends Command {
        CreateDirCommand() {
            super((BWidget)BNDirectoryChooser.this, BNDirectoryChooser.this.lex.module, "fileChooser.createDir");
        }

        @Override
        public CommandArtifact doInvoke() {
            String title = BNDirectoryChooser.this.lex.getText("fileChooser.title");
            try {
                BFileSpace space = (BFileSpace)BNDirectoryChooser.this.model.getSpace();
                BIFile dir = (BIFile)BNDirectoryChooser.this.model.getDirectory();
                String newFolderName = BNDirectoryChooser.this.lex.getText("fileChooser.newFolder");
                newFolderName = BDialog.prompt(BNDirectoryChooser.this, title, newFolderName, 20);
                if (newFolderName != null) {
                    BDirectory newDir = space.makeDir(dir.getFilePath().merge(newFolderName));
                    TreeNode node = BNDirectoryChooser.this.treeView.getSelection().getNode();
                    if (node instanceof BTreeView.Root) {
                        ((BTreeView.Root)node).kids = null;
                    } else {
                        ((BTreeView.Node)node).kids = null;
                    }
                    BNDirectoryChooser.this.treeView.relayout();
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)BNDirectoryChooser.this, title, (Object)BNDirectoryChooser.this.lex.getText("fileChooser.createDirFailed"), e);
            }
            return null;
        }
    }

    class CancelCommand
    extends Command {
        CancelCommand(String label) {
            super(BNDirectoryChooser.this, label);
        }

        @Override
        public CommandArtifact doInvoke() {
            BNDirectoryChooser.this.model.deselectAll();
            BNDirectoryChooser.this.close();
            return null;
        }
    }

    class ConfirmCommand
    extends Command {
        ConfirmCommand(String label) {
            super(BNDirectoryChooser.this, label);
        }

        @Override
        public CommandArtifact doInvoke() {
            BNDirectoryChooser.this.model.chooseSelectedFiles();
            return null;
        }
    }
}

