/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.FileChooserModel;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;

public class BFileSpaceList
extends BTable {
    public static final Type TYPE = Sys.loadType(BFileSpaceList.class);
    FileChooserModel fileModel;
    Model model;
    int focusedRow = -1;
    MouseCursor origCursor;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFileSpaceList(FileChooserModel fileModel) {
        this(fileModel, false);
    }

    public BFileSpaceList(FileChooserModel fileModel, boolean writeable) {
        this.fileModel = fileModel;
        this.model = new Model();
        this.model.kids.add(fileModel.getSpace());
        if (!writeable) {
            this.model.kids.add((BSpace)BModuleSpace.INSTANCE);
        }
        this.setModel(this.model);
        this.setController(new Controller());
        this.setCellRenderer(new CellRenderer());
        this.setHeaderVisible(false);
        this.setHgridVisible(false);
        this.setVgridVisible(false);
        this.setMultipleSelection(false);
    }

    public BFileSpaceList() {
    }

    public void addSpace(BSpace space) {
        if (!this.model.kids.contains(space)) {
            this.model.kids.add(space);
        }
    }

    public BSpace[] getSpaces() {
        return this.model.kids.toArray(new BSpace[this.model.kids.size()]);
    }

    public void setSpaces(BSpace[] spaces) {
        this.model.kids.clear();
        for (int i = 0; i < spaces.length; ++i) {
            this.addSpace(spaces[i]);
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        @Override
        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            int row = cell.row;
            cell.selected = false;
            this.paintCellBackground(g, cell);
            if (row == BFileSpaceList.this.focusedRow) {
                g.setBrush(BColor.blue);
            } else {
                g.setBrush(BColor.black);
            }
            String str = String.valueOf(BFileSpaceList.this.model.getValueAt(row, 0));
            int x = 2;
            BImage image = BFileSpaceList.this.model.getRowIcon(row);
            g.drawImage(image, (double)x, (cell.height - image.getHeight()) / 2.0);
            BFont font = Theme.widget().getTextFont();
            double baseline = (cell.height + font.getAscent() - font.getDescent()) / 2.0;
            g.setFont(font);
            g.drawString(str, (double)(x += 18), baseline);
            if (row == BFileSpaceList.this.focusedRow) {
                g.strokeLine((double)x, cell.height - 1.0, (double)x + font.width(str) - 1.0, cell.height - 1.0);
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        @Override
        protected void cellPressed(BMouseEvent event, int row, int column) {
            BSpace space = BFileSpaceList.this.model.getSpace(row);
            BFileSpaceList.this.fileModel.setSpace(space);
            BFileSpaceList.this.fileModel.setDirectory(null);
        }

        @Override
        protected void cellEntered(BMouseEvent event, int row, int column) {
            if (BFileSpaceList.this.origCursor == null) {
                BFileSpaceList.this.origCursor = this.getTable().getMouseCursor();
                this.getTable().setMouseCursor(MouseCursor.hand);
            }
            BFileSpaceList.this.focusedRow = row;
            this.getTable().repaint();
        }

        @Override
        protected void cellExited(BMouseEvent event, int row, int column) {
            this.getTable().setMouseCursor(BFileSpaceList.this.origCursor);
            BFileSpaceList.this.origCursor = null;
            BFileSpaceList.this.focusedRow = -1;
            this.getTable().repaint();
        }
    }

    class Model
    extends TableModel {
        ArrayList<BSpace> kids = new ArrayList();

        Model() {
        }

        @Override
        public int getRowCount() {
            return this.kids.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int col) {
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            BSpace space = this.kids.get(row);
            String s = space.getNavDisplayName(null);
            if (space instanceof BFileSpace && space != BFileSystem.INSTANCE) {
                s = s + " on " + space.getSession().getNavDisplayName(null);
            }
            return s;
        }

        @Override
        public BImage getRowIcon(int row) {
            BIcon icon = this.kids.get(row).getIcon();
            return BImage.make((BIcon)icon);
        }

        @Override
        public Object getSubject(int row) {
            return this.kids.get(row);
        }

        public BSpace getSpace(int row) {
            return this.kids.get(row);
        }
    }
}

