/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.NPopup;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;

final class FocusManager {
    static final int PRESSED = 401;
    static final int RELEASED = 402;
    static final int TYPED = 400;
    static final int GAINED = 1004;
    static final int LOST = 1005;
    static final Logger log = Logger.getLogger("ui.focus");
    private AwtShellManager shellManager;
    private BWidget shell;
    private boolean inFocus;
    private BWidget focus;
    private BWidget focusBeforeLoss;
    private boolean ignoreUntilTabRelease;
    private boolean onlyAltPressed;
    private BWidget focusBeforeTemp;
    private BWidget inPress;
    BKeyEvent lastKeyEvent;
    boolean takeBack;

    FocusManager(AwtShellManager shellManager) {
        this.shellManager = shellManager;
        this.shell = shellManager.getShell();
    }

    final void process(FocusEvent event) {
        this.shellManager.userActivity();
        switch (event.getID()) {
            case 1004: {
                this.inFocus = true;
                if (this.focusBeforeLoss == null) {
                    this.focusBeforeLoss = this.traverse(true);
                }
                this.changed(this.focusBeforeLoss, true);
                return;
            }
            case 1005: {
                this.inFocus = false;
                this.focusBeforeLoss = this.focus;
                this.inPress = null;
                if (this.takeBack && ((AwtUiEnv)AwtUiEnv.get()).getOpposite(event) == null) {
                    this.takeBack = false;
                    this.shellManager.requestFocus();
                    break;
                }
                this.changed(null, true);
                return;
            }
        }
    }

    final void process(KeyEvent event) {
        BWidget menuBar;
        this.shellManager.userActivity();
        this.trace("process", event);
        int id = event.getID();
        int keyCode = event.getKeyCode();
        if (NPopup.cancel(event)) {
            return;
        }
        BWidget inPress = this.inPress;
        if (id == 401) {
            this.inPress = inPress = this.focus;
        } else if (id == 402) {
            this.inPress = null;
        }
        if (id == 401 && event.getKeyCode() == 123) {
            this.shellManager.debug();
        }
        if (id == 401 && keyCode == 27 && this.shell instanceof BWidgetShell) {
            ((BWidgetShell)this.shell).handleEscape();
            return;
        }
        if (inPress != null && !this.ignoreUntilTabRelease && this.fireKeyEvent(inPress, event)) {
            return;
        }
        if (keyCode == 9) {
            if (id == 401) {
                if (event.isShiftDown()) {
                    this.changed(this.traverse(false), false);
                } else {
                    this.changed(this.traverse(true), false);
                }
                this.ignoreUntilTabRelease = true;
            } else if (id == 402) {
                this.ignoreUntilTabRelease = false;
            }
        }
        if (id == 401 && keyCode == 10 && this.shell instanceof BWidgetShell) {
            ((BWidgetShell)this.shell).handleEnter();
            return;
        }
        if (id == 401 && this.shell instanceof BWidgetShell) {
            BActionMenuItem item = this.getAccelerator(this.convert(null, event));
            if (item != null) {
                item.invokeAction();
            }
            this.onlyAltPressed = keyCode == 18;
        }
        boolean bl = this.onlyAltPressed = this.onlyAltPressed && keyCode == 18;
        if (id == 402 && keyCode == 18 && this.shell instanceof BWidgetShell && this.onlyAltPressed && (menuBar = ((BWidgetShell)this.shell).getMenuBar()) instanceof BMenuBar) {
            BWidget[] children = menuBar.getChildWidgets();
            if (children.length > 0) {
                ((BMenuBar)menuBar).focus((BMenu)children[0]);
            }
            return;
        }
        if (this.focus != null && keyCode != 10) {
            this.fireKeyEvent(this.focus, event);
        }
    }

    BActionMenuItem getAccelerator(BKeyEvent event) {
        BWidget menuBar = ((BWidgetShell)this.shell).getMenuBar();
        if (menuBar == null) {
            return null;
        }
        return this.getAccelerator(event, menuBar);
    }

    BActionMenuItem getAccelerator(BKeyEvent event, BWidget widget) {
        BActionMenuItem action;
        BAccelerator acc;
        if (widget instanceof BActionMenuItem && !(acc = (action = (BActionMenuItem)widget).getAccelerator()).isNull() && acc.isMatch(event) && action.isEnabled()) {
            return action;
        }
        BWidget[] kids = widget.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            BActionMenuItem found = this.getAccelerator(event, kids[i]);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    final boolean hasFocus(BWidget c) {
        return c == this.focus;
    }

    final BWidget getCurrentFocus() {
        return this.focus;
    }

    final void requestFocus(BWidget c) {
        if (c != this.focus) {
            if (this.inFocus) {
                this.changed(c, false);
            } else {
                this.focusBeforeLoss = c;
            }
        }
    }

    final void takeTempFocus(AwtShellManager tempShellManager) {
        if (this.focusBeforeTemp == null) {
            this.focusBeforeTemp = this.focus;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " takeTempFocus beforeTemp=" + FocusManager.toString(this.focusBeforeTemp));
        }
        this.shellManager = tempShellManager;
        this.shell = tempShellManager.getShell();
        this.changed(this.traverse(true), true);
    }

    final void releaseTempFocus(AwtShellManager origShellManager) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " releaseTempFocus beforeTemp=" + FocusManager.toString(this.focusBeforeTemp));
        }
        this.shellManager = origShellManager;
        this.shell = origShellManager.getShell();
        this.requestFocus(this.focusBeforeTemp);
        this.focusBeforeTemp = null;
        this.focusBeforeLoss = this.focus;
        this.takeBack = true;
        this.shellManager.requestFocus();
    }

    private BKeyEvent convert(BWidget src, KeyEvent e) {
        return new BKeyEvent(e.getID(), src, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
    }

    private boolean fireKeyEvent(BWidget src, KeyEvent e) {
        BKeyEvent event;
        if (log.isLoggable(Level.FINE)) {
            log.fine(" fire on " + src + " for event" + e);
        }
        this.lastKeyEvent = event = this.convert(src, e);
        src.fireKeyEvent(event);
        if (event.isConsumed()) {
            e.consume();
        }
        return event.isConsumed();
    }

    private void changed(BWidget newFocus, boolean temp) {
        if (this.focus == newFocus) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " changed " + FocusManager.toString(this.focus) + " -> " + FocusManager.toString(newFocus));
        }
        this.lastKeyEvent = null;
        if (this.focus != null) {
            this.fireFocusEvent(1005, this.focus, temp);
        }
        if (newFocus != null) {
            this.fireFocusEvent(1004, newFocus, temp);
        }
        this.focus = newFocus;
    }

    private void fireFocusEvent(int id, BWidget src, boolean temp) {
        try {
            BFocusEvent event = new BFocusEvent(id, src, temp);
            src.fireFocusEvent(event);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private BWidget traverse(boolean forward) {
        BWidget w = this.focus != null ? this.focus : this.shell;
        Traversal t = FocusManager.traversal(this.shell, w, new Traversal());
        if (forward) {
            if (t.next == null) {
                return t.first;
            }
            return t.next;
        }
        if (t.prev == null) {
            return t.last;
        }
        return t.prev;
    }

    private static Traversal traversal(BWidget w, BWidget current, Traversal t) {
        if (!w.isVisible() || !w.getEnabled()) {
            return t;
        }
        if (w.isFocusTraversable()) {
            if (t.first == null) {
                t.first = w;
            }
            if (t.saveNext) {
                t.next = w;
                t.saveNext = false;
            }
            if (w == current) {
                t.prev = t.last;
                t.saveNext = true;
            }
            t.last = w;
        }
        BWidget[] kids = w.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            FocusManager.traversal(kids[i], current, t);
        }
        return t;
    }

    public String toString() {
        String peer = "FocusManager";
        try {
            peer = TextUtil.getClassName(this.shellManager.getWindow().getClass());
            int dollar = peer.indexOf(36);
            if (dollar > 0) {
                peer = peer.substring(dollar + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return peer + " [" + Integer.toString(this.hashCode(), 36) + "]";
    }

    public static String toString(BWidget w) {
        if (w == null) {
            return "null";
        }
        return w.getType().getTypeName() + ":" + Integer.toString(w.hashCode(), 36);
    }

    String str(Component c) {
        if (c == null) {
            return "null";
        }
        while (!(c instanceof Window)) {
            c = c.getParent();
        }
        return TextUtil.getClassName(c.getClass()) + ":" + Integer.toString(c.hashCode(), 36);
    }

    String str(FocusEvent e) {
        return (e.isTemporary() ? "temp" : "perm") + " src=" + this.str(e.getComponent()) + " opp=" + this.str(((AwtUiEnv)AwtUiEnv.get()).getOpposite(e));
    }

    void trace(String msg, KeyEvent event) {
        this.trace(msg, event.getID(), event.getKeyCode(), event.getKeyChar(), event.getModifiers());
    }

    void trace(String msg, int id, int code, char ch, int mods) {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer s = new StringBuffer(this.toString());
        s.append(' ');
        s.append(msg);
        s.append(' ');
        switch (id) {
            case 401: {
                s.append("KeyPressed");
                break;
            }
            case 402: {
                s.append("KeyReleased");
                break;
            }
            case 400: {
                s.append("KeyTyped");
                break;
            }
            default: {
                s.append("KeyEvent");
            }
        }
        s.append("[code=").append(code);
        s.append(" char=");
        if (ch == '\n') {
            s.append("'\\n'");
        } else if (ch == '\r') {
            s.append("'\\r'");
        } else if (ch == '\t') {
            s.append("'\\t'");
        } else if (ch < ' ') {
            s.append("'?'");
        } else {
            s.append("'").append(ch).append("'");
        }
        if ((mods & 8) != 0) {
            s.append(" Alt");
        }
        if ((mods & 2) != 0) {
            s.append(" Ctrl");
        }
        if ((mods & 4) != 0) {
            s.append(" Meta");
        }
        if ((mods & 1) != 0) {
            s.append(" Shift");
        }
        s.append("]");
        log.fine(s.toString());
    }

    static class Traversal {
        BWidget first;
        BWidget prev;
        BWidget next;
        BWidget last;
        boolean saveNext;

        Traversal() {
        }

        void dump() {
            System.out.println("  first: " + this.first);
            System.out.println("  prev:  " + this.prev);
            System.out.println("  next:  " + this.next);
            System.out.println("  last:  " + this.last);
        }
    }
}

