/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.ui.enums.BAlign;

public class PaintUtil {
    static BColor glass1 = BColor.make((int)216, (int)240, (int)255);
    static BColor glass2 = BColor.make((int)180, (int)200, (int)246);
    static BColor glass3 = BColor.make((int)194, (int)216, (int)255);
    static BColor glass4 = BColor.make((int)172, (int)192, (int)236);
    static BColor glass5 = BColor.make((int)125, (int)140, (int)172);

    public static void drawRoundRect(Graphics g, int x, int y, int w, int h) {
        g.translate((double)x, (double)y);
        g.strokeLine(4.0, 0.0, (double)(w - 5), 0.0);
        g.strokeLine(0.0, 4.0, 0.0, (double)(h - 5));
        g.strokeLine((double)(w - 1), 4.0, (double)(w - 1), (double)(h - 5));
        g.strokeLine(4.0, (double)(h - 1), (double)(w - 5), (double)(h - 1));
        g.strokeLine(2.0, 1.0, 3.0, 1.0);
        g.strokeLine(1.0, 2.0, 1.0, 3.0);
        g.strokeLine((double)(w - 4), 1.0, (double)(w - 3), 1.0);
        g.strokeLine((double)(w - 2), 2.0, (double)(w - 2), 3.0);
        g.strokeLine((double)(w - 4), (double)(h - 2), (double)(w - 3), (double)(h - 2));
        g.strokeLine((double)(w - 2), (double)(h - 3), (double)(w - 2), (double)(h - 4));
        g.strokeLine(2.0, (double)(h - 2), 3.0, (double)(h - 2));
        g.strokeLine(1.0, (double)(h - 3), 1.0, (double)(h - 4));
        g.translate((double)(-x), (double)(-y));
    }

    public static void fillRoundRect(Graphics g, int x, int y, int w, int h) {
        g.translate((double)x, (double)y);
        g.fillRect(2.0, 2.0, (double)(w - 4), (double)(h - 4));
        g.strokeLine(4.0, 1.0, (double)(w - 5), 1.0);
        g.strokeLine(4.0, (double)(h - 2), (double)(w - 5), (double)(h - 2));
        g.strokeLine(1.0, 4.0, 1.0, (double)(h - 5));
        g.strokeLine((double)(w - 2), 4.0, (double)(w - 2), (double)(h - 5));
        g.translate((double)(-x), (double)(-y));
    }

    public static void paintGlassRect(Graphics g, int x, int y, int w, int h, boolean over) {
        g.translate((double)x, (double)y);
        if (over) {
            g.setBrush(glass1);
            g.fillRect(0.0, 0.0, (double)w, (double)h);
        } else {
            g.setBrush(glass2);
            g.fillRect(0.0, 0.0, (double)w, (double)h);
            g.setBrush(glass3);
            g.strokeLine(1.0, 1.0, (double)(w - 2), 1.0);
            g.strokeLine(1.0, 1.0, 1.0, (double)(h - 1));
            g.setBrush(glass4);
            g.strokeLine(2.0, (double)(h - 2), (double)(w - 2), (double)(h - 2));
            g.strokeLine((double)(w - 2), 2.0, (double)(w - 2), (double)(h - 2));
        }
        g.setBrush(glass5);
        g.strokeLine(1.0, 0.0, (double)(w - 2), 0.0);
        g.strokeLine(1.0, (double)(h - 1), (double)(w - 2), (double)(h - 1));
        g.strokeLine(0.0, 1.0, 0.0, (double)(h - 2));
        g.strokeLine((double)(w - 1), 1.0, (double)(w - 1), (double)(h - 2));
        g.translate((double)(-x), (double)(-y));
    }

    public static void drawArrow(Graphics g, double x, double y, double w, double h, BAlign direction) {
        PaintUtil.drawArrow(g, (int)x, (int)y, (int)w, (int)h, direction);
    }

    public static void drawArrow(Graphics g, int x, int y, int w, int h, BAlign direction) {
        int dir = direction.getOrdinal();
        switch (dir) {
            case 0: 
            case 2: {
                int neg;
                int mx = x + w / 2;
                int n = neg = dir == 0 ? 1 : -1;
                if (h < 7) {
                    int my = y + (h - 3) / 2;
                    if (dir == 2) {
                        my += 3;
                    }
                    g.strokeLine((double)mx, (double)(my + 0 * neg), (double)mx, (double)(my + 0 * neg));
                    g.strokeLine((double)(mx - 1), (double)(my + 1 * neg), (double)(mx + 1), (double)(my + 1 * neg));
                    g.strokeLine((double)(mx - 2), (double)(my + 2 * neg), (double)(mx + 2), (double)(my + 2 * neg));
                    break;
                }
                int my = y + (h - 4) / 2;
                if (dir == 2) {
                    my += 5;
                }
                g.strokeLine((double)mx, (double)(my + 0 * neg), (double)(mx - 4), (double)(my + 4 * neg));
                g.strokeLine((double)mx, (double)(my + 1 * neg), (double)(mx - 3), (double)(my + 4 * neg));
                g.strokeLine((double)mx, (double)(my + 2 * neg), (double)(mx - 3), (double)(my + 5 * neg));
                g.strokeLine((double)mx, (double)(my + 0 * neg), (double)(mx + 4), (double)(my + 4 * neg));
                g.strokeLine((double)mx, (double)(my + 1 * neg), (double)(mx + 3), (double)(my + 4 * neg));
                g.strokeLine((double)mx, (double)(my + 2 * neg), (double)(mx + 3), (double)(my + 5 * neg));
                break;
            }
            case 1: 
            case 3: {
                int mx = x + (w - 4) / 2;
                if (dir == 3) {
                    mx += 5;
                }
                int my = h / 2;
                int neg = dir == 1 ? 1 : -1;
                g.strokeLine((double)(mx + 0 * neg), (double)my, (double)(mx + 4 * neg), (double)(my - 4));
                g.strokeLine((double)(mx + 1 * neg), (double)my, (double)(mx + 4 * neg), (double)(my - 3));
                g.strokeLine((double)(mx + 2 * neg), (double)my, (double)(mx + 5 * neg), (double)(my - 3));
                g.strokeLine((double)(mx + 0 * neg), (double)my, (double)(mx + 4 * neg), (double)(my + 4));
                g.strokeLine((double)(mx + 1 * neg), (double)my, (double)(mx + 4 * neg), (double)(my + 3));
                g.strokeLine((double)(mx + 2 * neg), (double)my, (double)(mx + 5 * neg), (double)(my + 3));
            }
        }
    }

    public static void drawCircle(Graphics g, int cx, int cy, int radius) {
        PaintUtil.doCircle(false, g, cx, cy, radius);
    }

    public static void fillCircle(Graphics g, int cx, int cy, int radius) {
        PaintUtil.doCircle(true, g, cx, cy, radius);
    }

    private static void doCircle(boolean fill, Graphics g, int cx, int cy, int radius) {
        g.translate((double)cx, (double)cy);
        int x = 0;
        int y = radius;
        int d = 1 - radius;
        int deltaE = 3;
        int deltaSE = -2 * radius + 5;
        if (!fill) {
            PaintUtil.drawPoints(g, x, y);
        } else {
            PaintUtil.fillPoints(g, x, y);
        }
        while (y > x) {
            if (d < 0) {
                d += deltaE;
                deltaE += 2;
                deltaSE += 2;
                ++x;
            } else {
                d += deltaSE;
                deltaE += 2;
                deltaSE += 4;
                ++x;
                --y;
            }
            if (!fill) {
                PaintUtil.drawPoints(g, x, y);
                continue;
            }
            PaintUtil.fillPoints(g, x, y);
        }
        g.translate((double)(-cx), (double)(-cy));
    }

    private static void drawPoints(Graphics g, int x, int y) {
        g.strokeLine((double)x, (double)y, (double)x, (double)y);
        g.strokeLine((double)x, (double)(-y), (double)x, (double)(-y));
        g.strokeLine((double)(-x), (double)(-y), (double)(-x), (double)(-y));
        g.strokeLine((double)(-x), (double)y, (double)(-x), (double)y);
        if (x != y) {
            g.strokeLine((double)y, (double)x, (double)y, (double)x);
            g.strokeLine((double)y, (double)(-x), (double)y, (double)(-x));
            g.strokeLine((double)(-y), (double)(-x), (double)(-y), (double)(-x));
            g.strokeLine((double)(-y), (double)x, (double)(-y), (double)x);
        }
    }

    private static void fillPoints(Graphics g, int x, int y) {
        g.strokeLine((double)x, (double)y, (double)x, (double)(-y));
        g.strokeLine((double)(-x), (double)y, (double)(-x), (double)(-y));
        if (x != y) {
            g.strokeLine((double)y, (double)x, (double)y, (double)(-x));
            g.strokeLine((double)(-y), (double)x, (double)(-y), (double)(-x));
        }
    }

    public static void drawDashedLine(Graphics g, double x1, double y1, double x2, double y2) {
        PaintUtil.drawDashedLine(g, (int)x1, (int)y1, (int)x2, (int)y2);
    }

    public static void drawDashedLine(Graphics g, int x1, int y1, int x2, int y2) {
        PaintUtil.drawDashedLine(g, x1, y1, x2, y2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawDashedLine(Graphics g, int x1, int y1, int x2, int y2, int dashLength) {
        int ds = dashLength * 2;
        g.push();
        try {
            if (x1 == x2) {
                if (y1 > y2) {
                    int temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                g.clip((double)x1, (double)y1, 1.0, (double)(y2 - y1));
                for (int j = y1; j <= y2; j += ds) {
                    g.strokeLine((double)x1, (double)j, (double)x1, (double)(j + dashLength - 1));
                }
            } else if (y1 == y2) {
                if (x1 > x2) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                }
                g.clip((double)x1, (double)y1, (double)(x2 - x1), 1.0);
                for (int i = x1; i <= x2; i += ds) {
                    g.strokeLine((double)i, (double)y1, (double)(i + dashLength - 1), (double)y1);
                }
            } else {
                g.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
            }
        }
        finally {
            g.pop();
        }
    }

    public static void drawDashedRect(Graphics g, IRectGeom r) {
        PaintUtil.drawDashedRect(g, (int)r.x(), (int)r.y(), (int)r.width(), (int)r.height(), 1);
    }

    public static void drawDashedRect(Graphics g, IRectGeom r, int dashLength) {
        PaintUtil.drawDashedRect(g, (int)r.x(), (int)r.y(), (int)r.width(), (int)r.height(), dashLength);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int w, int h) {
        PaintUtil.drawDashedRect(g, x, y, w, h, 1);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int w, int h, int dashLength) {
        PaintUtil.drawDashedLine(g, x, y, x + w, y, dashLength);
        PaintUtil.drawDashedLine(g, x, y, x, y + h, dashLength);
        PaintUtil.drawDashedLine(g, x, y + h, x + w, y + h, dashLength);
        PaintUtil.drawDashedLine(g, x + w, y, x + w, y + h, dashLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillHatched(Graphics g, int x, int y, int w, int h) {
        g.push();
        g.clip((double)x, (double)y, (double)w, (double)h);
        try {
            int max = Math.max(w, h) * 2;
            for (int n = 5; n < max; n += 5) {
                g.strokeLine((double)x, (double)(y + n), (double)(x + n), (double)y);
            }
        }
        finally {
            g.pop();
        }
    }
}

