/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.util.UiLexicon;

public final class BZoomPane
extends BPane {
    public static final Property content = BZoomPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property zoomLevel = BZoomPane.newProperty((int)0, (double)1.0, null);
    public static final Type TYPE = Sys.loadType(BZoomPane.class);
    private volatile BTransform transform = BTransform.DEFAULT;
    private static final double zoomIncrement = 0.2;
    private static final double maxZoomLimit = 10.0;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public double getZoomLevel() {
        return this.getDouble(zoomLevel);
    }

    public void setZoomLevel(double v) {
        this.setDouble(zoomLevel, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BZoomPane() {
    }

    public BZoomPane(BWidget content) {
        this.setContent(content);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 2 && a.equals(zoomLevel)) {
            this.relayout();
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public void computePreferredSize() {
        this.calcTransform();
        BWidget child = this.getContent();
        child.computePreferredSize();
        Point pnt = new Point(child.getPreferredWidth(), child.getPreferredHeight());
        pnt = this.transform.transform((IPoint)pnt, pnt);
        this.setPreferredSize(Math.round(pnt.x), Math.round(pnt.y));
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.calcTransform();
        Point pnt = new Point(this.getWidth(), this.getHeight());
        pnt = this.transform.getInverse().transform((IPoint)pnt, pnt);
        this.getContent().setBounds(0.0, 0.0, Math.round(pnt.x), Math.round(pnt.y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        BWidget child = this.getContent();
        if (this.isVisible() && child.isVisible()) {
            double w = this.getWidth();
            double h = this.getHeight();
            if (g.getClip().intersects(0.0, 0.0, w, h)) {
                g.push();
                try {
                    g.clip(0.0, 0.0, w, h);
                    g.translate(0.0, 0.0);
                    g.transform(this.transform);
                    child.paint(g);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    g.pop();
                }
            }
        }
    }

    @Override
    public BWidget childAt(Point pt) {
        return super.childAt(this.transform.getInverse().transform((IPoint)pt, null));
    }

    @Override
    public Point translateToChild(BWidget child, Point pt) {
        if (child == this.getContent()) {
            this.transform.getInverse().transform((IPoint)pt, pt);
        } else {
            pt = super.translateToChild(child, pt);
        }
        return pt;
    }

    @Override
    public Point translateFromChild(BWidget child, Point pt) {
        if (child == this.getContent()) {
            this.transform.transform((IPoint)pt, pt);
        } else {
            pt = super.translateFromChild(child, pt);
        }
        return pt;
    }

    public void zoomIn() {
        double z = this.getZoomLevel() + 0.2;
        this.setZoomLevel(BZoomPane.round(z >= 10.0 ? 9.8 : z));
    }

    public void zoomOut() {
        double z = this.getZoomLevel() - 0.2;
        this.setZoomLevel(BZoomPane.round(z < 0.2 ? 0.2 : z));
    }

    public void zoomReset() {
        this.setZoomLevel(1.0);
    }

    private void calcTransform() {
        double z = this.getZoomLevel();
        this.transform = BTransform.makeScale((double)z, (double)z);
    }

    private static double round(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static final class ZoomResetCommand
    extends ZoomCommand {
        public ZoomResetCommand(BWidget owner, BZoomPane zoomPane) {
            super(owner, zoomPane, "commands.zoomReset");
        }

        @Override
        public CommandArtifact doInvoke() throws Exception {
            this.zoomPane.zoomReset();
            return null;
        }
    }

    public static final class ZoomOutCommand
    extends ZoomCommand {
        public ZoomOutCommand(BWidget owner, BZoomPane zoomPane) {
            super(owner, zoomPane, "commands.zoomOut");
        }

        @Override
        public CommandArtifact doInvoke() throws Exception {
            this.zoomPane.zoomOut();
            return null;
        }
    }

    public static final class ZoomInCommand
    extends ZoomCommand {
        public ZoomInCommand(BWidget owner, BZoomPane zoomPane) {
            super(owner, zoomPane, "commands.zoomIn");
        }

        @Override
        public CommandArtifact doInvoke() throws Exception {
            this.zoomPane.zoomIn();
            return null;
        }
    }

    private static abstract class ZoomCommand
    extends Command {
        protected BZoomPane zoomPane;

        protected ZoomCommand(BWidget owner, BZoomPane zoomPane, String key) {
            super(owner, UiLexicon.bajaui(), key);
            this.zoomPane = zoomPane;
        }

        public BZoomPane getZoomPane() {
            return this.zoomPane;
        }
    }
}

